/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class ManageDataSourcesAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ManageDataSourcesAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    static DbDataSource getDataSourceFromEvent(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            ManageDataSourcesAction.$$$reportNull$$$0(1);
        }
        PsiElement element2 = (PsiElement)e2.getData(CommonDataKeys.PSI_ELEMENT);
        PsiFile file = (PsiFile)e2.getData(CommonDataKeys.PSI_FILE);
        DataGrid dataGrid = (DataGrid)e2.getData(DatabaseDataKeys.DATA_GRID_KEY);
        DasDataSource system = (DasDataSource)ObjectUtils.coalesce((Object)DataGridUtilCore.getDatabaseSystem((CoreGrid<GridRow, GridColumn>)dataGrid), (Object)DbImplUtilCore.getForcedDataSource(file), (Object)((DbDataSource)PsiTreeUtil.getParentOfType((PsiElement)element2, DbDataSource.class, (boolean)false)));
        return (DbDataSource)ObjectUtils.tryCast((Object)system, DbDataSource.class);
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        Project project;
        if (e2 == null) {
            ManageDataSourcesAction.$$$reportNull$$$0(2);
        }
        if ((project = e2.getProject()) == null) {
            return;
        }
        DataSourceManagerDialog.showDialog(project, (Object)ManageDataSourcesAction.getDataSourceFromEvent(e2), null);
    }

    public void update(@NotNull AnActionEvent e2) {
        boolean enabled;
        Project project;
        if (e2 == null) {
            ManageDataSourcesAction.$$$reportNull$$$0(3);
        }
        if ((project = e2.getProject()) == null) {
            e2.getPresentation().setEnabledAndVisible(false);
            return;
        }
        KeyEvent keyEvent = (KeyEvent)ObjectUtils.tryCast((Object)e2.getInputEvent(), KeyEvent.class);
        boolean mainMenu = ActionPlaces.isMainMenuOrActionSearch((String)e2.getPlace());
        if (mainMenu) {
            e2.getPresentation().setText(DatabaseBundle.message("action.DatabaseView.PropertiesAction.menu.text", new Object[0]));
        } else if (ActionPlaces.isPopupPlace((String)e2.getPlace())) {
            e2.getPresentation().setText(DatabaseBundle.message("action.DatabaseView.PropertiesAction.popup.text", new Object[0]));
        }
        PsiElement element2 = (PsiElement)e2.getData(CommonDataKeys.PSI_ELEMENT);
        DbDataSource dataSource2 = (DbDataSource)PsiTreeUtil.getParentOfType((PsiElement)element2, DbDataSource.class, (boolean)false);
        boolean bl = enabled = mainMenu && keyEvent == null || e2.isFromActionToolbar() || dataSource2 != null && element2 == dataSource2;
        if (PlatformUtils.isDataGrip()) {
            boolean flag = mainMenu || enabled;
            e2.getPresentation().setEnabledAndVisible(flag);
            if (!enabled && keyEvent != null) {
                KeyboardShortcut shortcut;
                String actionId = e2.getActionManager().getId((AnAction)this);
                KeyboardShortcut keyboardShortcut = shortcut = actionId == null ? null : e2.getActionManager().getKeyboardShortcut(actionId);
                if (shortcut == null || !Comparing.equal((Object)KeyStroke.getKeyStrokeForEvent(keyEvent), (Object)shortcut.getFirstKeyStroke())) {
                    e2.getPresentation().setEnabled(false);
                }
            }
        } else {
            e2.getPresentation().setEnabledAndVisible(enabled);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ManageDataSourcesAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ManageDataSourcesAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceFromEvent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

