/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.Dbms;
import com.intellij.database.actions.BasicElementAction;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.MultiMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0014J,\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00020\u0012H\u0014J\u001c\u0010\u0014\u001a\u00020\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00020\u0012H\u0014R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/actions/HideSchemasAction;", "Lcom/intellij/database/actions/BasicElementAction;", "Lcom/intellij/database/model/basic/BasicNamespace;", "()V", "expandGroupItems", "", "getExpandGroupItems", "()Z", "cast", "node", "Lcom/intellij/database/model/basic/BasicNode;", "doIt", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "selection", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/database/model/basic/BasicModel;", "enabled", "intellij.database.impl"})
public final class HideSchemasAction
extends BasicElementAction<BasicNamespace> {
    @Override
    protected boolean getExpandGroupItems() {
        return false;
    }

    @Override
    @Nullable
    protected BasicNamespace cast(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        return node2 instanceof BasicNamespace ? (BasicNamespace)node2 : null;
    }

    @Override
    protected boolean enabled(@NotNull MultiMap<BasicModel, BasicNamespace> selection2) {
        Intrinsics.checkNotNullParameter(selection2, (String)"selection");
        for (BasicNamespace element2 : selection2.values()) {
            if (!Intrinsics.areEqual((Object)element2.getKind(), (Object)ObjectKind.DATABASE) || !element2.isCurrent()) continue;
            BasicModel basicModel = element2.getModel();
            if (!Intrinsics.areEqual((Object)(basicModel != null ? basicModel.getDbms() : null), (Object)Dbms.POSTGRES)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void doIt(@NotNull AnActionEvent e2, @NotNull Project project, @NotNull MultiMap<BasicModel, BasicNamespace> selection2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(selection2, (String)"selection");
        for (LocalDataSource dataSource2 : DataSourceStorage.getProjectStorage(project).getDataSources()) {
            DasModel model2;
            if (dataSource2 == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)dataSource2.getModel(), (String)"getModel(...)");
            if (!(model2 instanceof BasicModel) || !selection2.containsKey((Object)model2)) continue;
            DataSourceUtil.setNamespacesVisible(project, dataSource2, selection2.get((Object)model2), false);
        }
    }
}

