/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.actions.DatabaseStringUsageTarget;
import com.intellij.database.actions.FullTextSearchAction;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.ContainsInIndexedTextOperation;
import com.intellij.database.data.types.DasColumnRef;
import com.intellij.database.data.types.EqualsPredicateOperation;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.OperandType;
import com.intellij.database.data.types.PredicateOperation;
import com.intellij.database.data.types.PredicateSpec;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.data.types.PredicatesHelperKt;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.InterruptibleDatabaseConnection;
import com.intellij.database.dataSource.InterruptibleDatabaseConnectionKt;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.SimpleSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.fulltextsearch.FtsUtilKt;
import com.intellij.database.fulltextsearch.FullTextSearchDbElementUsage;
import com.intellij.database.fulltextsearch.FullTextSearchOptions;
import com.intellij.database.fulltextsearch.FullTextSearchOptionsStorage;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.PredicatesWhereClause;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0003\u000f\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/actions/FullTextSearchAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getSearchableTargets", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/psi/DbElement;", "elements", "getSelectedElements", "update", "Companion", "SearchGroup", "TableGrouper", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nFullTextSearchAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullTextSearchAction.kt\ncom/intellij/database/actions/FullTextSearchAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,345:1\n1#2:346\n*E\n"})
public final class FullTextSearchAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        JBIterable<DbElement> targets2 = this.getSearchableTargets(this.getSelectedElements(e2));
        e2.getPresentation().setEnabledAndVisible(targets2.isNotEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Project project = e2.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        JBIterable<DbElement> selectedTargets = this.getSearchableTargets(this.getSelectedElements(e2));
        List list = ((JBTreeTraverser)((JBTreeTraverser)DasUtil.dasTraverser().withRoots((Iterable)selectedTargets)).expandAndSkip(Conditions.or(DasUtil.byClass(DasNamespace.class), DasUtil.byClass(DasDataSource.class)))).filter(DbTable.class).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List targets2 = list;
        if (targets2.isEmpty()) {
            return;
        }
        FullTextSearchOptions options2 = new FullTextSearchOptions(FullTextSearchOptionsStorage.getText(), FullTextSearchOptionsStorage.getMatchCase(), FullTextSearchOptionsStorage.getSearchTarget(), FullTextSearchOptionsStorage.getLocation(), FullTextSearchOptionsStorage.getMaxNumOfFetchedRows());
        new DatabaseStringUsageTarget(project2, FullTextSearchAction.Companion.createFindModel(project2, ""), options2, targets2).showSettings();
    }

    private final JBIterable<DbElement> getSearchableTargets(JBIterable<DbElement> elements2) {
        JBIterable jBIterable = elements2.filter(arg_0 -> FullTextSearchAction.getSearchableTargets$lambda$0(getSearchableTargets.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    private final JBIterable<DbElement> getSelectedElements(AnActionEvent e2) {
        DataGrid grid = (DataGrid)e2.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (grid != null) {
            JBIterable jBIterable;
            JBIterable jBIterable2;
            DasTable table = DataGridUtil.getDatabaseTable(grid);
            DbDataSource dataSource2 = DataGridUtilCore.getDatabaseSystem((CoreGrid<GridRow, GridColumn>)((CoreGrid)grid));
            DbElement dbElement = DbImplUtil.findElement(dataSource2, table);
            if (dbElement != null) {
                DbElement it2 = dbElement;
                boolean bl = false;
                jBIterable2 = JBIterable.of((Object)it2);
            } else {
                jBIterable2 = jBIterable = null;
            }
            if (jBIterable2 == null) {
                JBIterable jBIterable3 = JBIterable.empty();
                jBIterable = jBIterable3;
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"empty(...)");
            }
            return jBIterable;
        }
        DataContext dataContext = e2.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        return DatabaseContextFun.getSelectedDbElementsExpandingGroups(dataContext);
    }

    private static final boolean getSearchableTargets$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J^\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J&\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0013H\u0002J\u0014\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002JA\u0010$\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0'0%2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b.J\u0018\u0010/\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u001bH\u0003J.\u00101\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00132\b\u00102\u001a\u0004\u0018\u000103J<\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u0002062\u0006\u0010-\u001a\u00020\u00142\u0006\u00107\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u00108\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u00109\u001a\u00020:J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0019H\u0002J\n\u0010>\u001a\u00020?*\u00020@\u00a8\u0006A"}, d2={"Lcom/intellij/database/actions/FullTextSearchAction$Companion;", "", "()V", "checkTables", "", "project", "Lcom/intellij/openapi/project/Project;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/usages/Usage;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "options", "Lcom/intellij/database/fulltextsearch/FullTextSearchOptions;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "tables", "", "Lcom/intellij/database/model/basic/BasicTableOrView;", "tablesCount", "", "currentTablesCount", "createFindModel", "Lcom/intellij/find/FindModel;", "text", "", "createSearcher", "Lcom/intellij/usages/UsageSearcher;", "targets", "Lcom/intellij/database/psi/DbTable;", "getDbDataSource", "Lcom/intellij/database/psi/DbDataSource;", "target", "Lcom/intellij/database/psi/DbElement;", "getPredicates", "", "Lcom/intellij/database/data/types/ColumnRef;", "", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "dbms", "Lcom/intellij/database/Dbms;", "version", "Lcom/intellij/database/util/Version;", "table", "getPredicates$intellij_database_impl", "qualifyTable", "dataSourceName", "search", "listener", "Lcom/intellij/usages/UsageViewManager$UsageViewStateListener;", "searchStatement", "builder", "Lcom/intellij/database/util/DdlBuilder;", "dbDataSource", "predicates", "insertNewLines", "", "setupViewPresentation", "Lcom/intellij/usages/UsageViewPresentation;", "findModel", "toDecorator", "Lcom/intellij/database/util/DbImplUtilCore$StringLiteralDecorator;", "Lcom/intellij/database/fulltextsearch/FullTextSearchOptions$Location;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nFullTextSearchAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullTextSearchAction.kt\ncom/intellij/database/actions/FullTextSearchAction$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n1313#2,2:346\n1789#3,3:348\n*S KotlinDebug\n*F\n+ 1 FullTextSearchAction.kt\ncom/intellij/database/actions/FullTextSearchAction$Companion\n*L\n196#1:346,2\n150#1:348,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void searchStatement(@NotNull DdlBuilder builder, @NotNull BasicTableOrView table, @NotNull DbDataSource dbDataSource, @NotNull FullTextSearchOptions options2, @NotNull List<PredicatesHelper.PredicateProducer> predicates, boolean insertNewLines) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)dbDataSource, (String)"dbDataSource");
            Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
            Intrinsics.checkNotNullParameter(predicates, (String)"predicates");
            DmlHelper ddlGenerator = DmlHelper.Companion.getEP().forDbms(dbDataSource.getDbms());
            SelectTask task = DmlTaskKt.allColumns(table).version(dbDataSource.getVersion()).limit(options2.getMaxNumOfFetchedRows()).insertNewLines(insertNewLines).whereClause(new PredicatesWhereClause(predicates, "OR", null, 4, null)).build(builder);
            ddlGenerator.generate(task);
        }

        public final void search(@NotNull Project project, @NotNull FullTextSearchOptions options2, @NotNull Collection<? extends DbTable> targets2, @Nullable UsageViewManager.UsageViewStateListener listener2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
            Intrinsics.checkNotNullParameter(targets2, (String)"targets");
            UsageViewManager usageViewManager = UsageViewManager.getInstance((Project)project);
            if (usageViewManager == null) {
                return;
            }
            UsageViewManager manager = usageViewManager;
            String string = options2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            FindModel findModel = this.createFindModel(project, string);
            DatabaseStringUsageTarget usageTarget = new DatabaseStringUsageTarget(project, findModel, options2, targets2);
            UsageViewPresentation presentation = this.setupViewPresentation(findModel);
            FindUsagesProcessPresentation findUsagesProcessPresentation = FindInProjectUtil.setupProcessPresentation((UsageViewPresentation)presentation);
            Intrinsics.checkNotNullExpressionValue((Object)findUsagesProcessPresentation, (String)"setupProcessPresentation(...)");
            FindUsagesProcessPresentation processPresentation = findUsagesProcessPresentation;
            UsageTarget[] usageTargetArray = new UsageTarget[]{usageTarget};
            manager.searchAndShowUsages(usageTargetArray, () -> Companion.search$lambda$0(project, options2, targets2), processPresentation, presentation, listener2);
        }

        private final UsageViewPresentation setupViewPresentation(FindModel findModel) {
            UsageViewPresentation usageViewPresentation = FindInProjectUtil.setupViewPresentation((FindModel)findModel);
            Intrinsics.checkNotNullExpressionValue((Object)usageViewPresentation, (String)"setupViewPresentation(...)");
            UsageViewPresentation presentation = usageViewPresentation;
            presentation.setUsageTypeFilteringAvailable(false);
            return presentation;
        }

        private final FindModel createFindModel(Project project, String text2) {
            FindModel findModel = new FindModel();
            findModel.setStringToFind(text2);
            findModel.setCustomScope((SearchScope)GlobalSearchScope.everythingScope((Project)project));
            findModel.setCustomScope(true);
            return findModel;
        }

        private final UsageSearcher createSearcher(Project project, FullTextSearchOptions options2, Collection<? extends DbTable> targets2) {
            return arg_0 -> Companion.createSearcher$lambda$3(targets2, project, options2, arg_0);
        }

        private final void checkTables(Project project, DatabaseConnection connection2, Processor<? super Usage> processor2, LocalDataSource dataSource2, FullTextSearchOptions options2, ProgressIndicator indicator, Collection<? extends BasicTableOrView> tables2, int tablesCount, int currentTablesCount) {
            DbDataSource dbDataSource = DbImplUtil.getDbDataSource(project, dataSource2);
            if (dbDataSource == null) {
                return;
            }
            DbDataSource dbDataSource2 = dbDataSource;
            DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect(dataSource2.getDbms());
            Intrinsics.checkNotNullExpressionValue((Object)databaseDialectEx, (String)"getDatabaseDialect(...)");
            DatabaseDialectEx dialect = databaseDialectEx;
            BasicTableOrView currentTable = null;
            int i2 = 0;
            Sequence<Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbElement>> $this$forEach$iv = FtsUtilKt.chooseElementsIterator(tables2, dbDataSource2, options2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DdlBuilder builder;
                Triple triple = (Triple)element$iv;
                boolean bl = false;
                List predicates = (List)triple.component1();
                BasicTableOrView table = (BasicTableOrView)triple.component2();
                DbElement element2 = (DbElement)triple.component3();
                indicator.checkCanceled();
                String string = dataSource2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                indicator.setText(Companion.qualifyTable(table, string));
                if (!Intrinsics.areEqual((Object)table, currentTable)) {
                    currentTable = table;
                    indicator.setFraction((double)(++i2 + currentTablesCount) / (double)tablesCount);
                }
                if (predicates.isEmpty()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)new DdlBuilder().withDialect(dialect).qualifyReferences(true), (String)"qualifyReferences(...)");
                Companion.searchStatement(builder, table, dbDataSource2, options2, predicates, false);
                SimpleSmartStatement simpleSmartStatement = SmartStatements.Companion.poweredBy(connection2).simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM));
                String string2 = builder.getStatement();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStatement(...)");
                int count = ((Number)simpleSmartStatement.execute(string2, StandardResultsProcessors.linesCount(options2.getMaxNumOfFetchedRows())).rightOr(0)).intValue();
                if (count <= 0) continue;
                processor2.process((Object)FullTextSearchDbElementUsage.Companion.create(element2, count, options2.getMaxNumOfFetchedRows(), predicates));
            }
        }

        @NotNull
        public final Map<ColumnRef, List<PredicatesHelper.PredicateProducer>> getPredicates$intellij_database_impl(@NotNull Dbms dbms, @Nullable Version version, @NotNull BasicTableOrView table, @NotNull FullTextSearchOptions options2) {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
            Object[] objectArray = new PredicateOperation[3];
            objectArray[0] = new EqualsPredicateOperation(null, 1, null);
            objectArray[1] = ContainsInIndexedTextOperation.INSTANCE;
            LikeOpType likeOpType = options2.getLocation().getLikeOpType();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)likeOpType), (String)"getLikeOpType(...)");
            objectArray[2] = new LikePredicateOperation(likeOpType, options2.isMatchCase(), false, 4, null);
            Set operations = SetsKt.setOf((Object[])objectArray);
            List list = DasUtil.getColumns(table).map(arg_0 -> Companion.getPredicates$lambda$5((Function1)new Function1<DasColumn, PredicateSpec>(options2, (Set<? extends PredicateOperation>)operations){
                final /* synthetic */ FullTextSearchOptions $options;
                final /* synthetic */ Set<PredicateOperation> $operations;
                {
                    this.$options = $options;
                    this.$operations = $operations;
                    super(1);
                }

                public final PredicateSpec invoke(DasColumn it2) {
                    Intrinsics.checkNotNull((Object)it2);
                    ColumnRef columnRef = new DasColumnRef(it2);
                    String string = this.$options.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    return new PredicateSpec(columnRef, new StringPredicateValue(string, false, 2, null), this.$operations);
                }
            }, arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
            List specs2 = list;
            PredicatesHelper predicatesHelper = PredicatesHelperKt.predicatesHelper(dbms);
            List<OperandType> list2 = options2.getSearchScope().getTypes();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getTypes(...)");
            return predicatesHelper.getPredicateProducers(specs2, list2, null, version, false);
        }

        @NlsSafe
        private final String qualifyTable(BasicTableOrView table, String dataSourceName) {
            StringBuilder b2 = new StringBuilder();
            boolean first2 = true;
            for (BasicElement par = table.getParent(); par != null; par = par.getParent()) {
                String name2;
                Intrinsics.checkNotNullExpressionValue((Object)par.getName(), (String)"getName(...)");
                if (!(!StringsKt.isBlank((CharSequence)name2))) continue;
                if (first2) {
                    first2 = false;
                } else {
                    b2.insert(0, ".");
                }
                b2.insert(0, name2);
            }
            if (!first2) {
                b2.insert(0, ".");
            }
            b2.insert(0, dataSourceName);
            return table.getName() + " (" + b2 + ")";
        }

        @NotNull
        public final DbImplUtilCore.StringLiteralDecorator toDecorator(@NotNull FullTextSearchOptions.Location $this$toDecorator) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$toDecorator), (String)"<this>");
            return switch (WhenMappings.$EnumSwitchMapping$0[$this$toDecorator.ordinal()]) {
                case 1 -> DbImplUtilCore.StringLiteralDecorator.CONTAINS;
                case 2 -> DbImplUtilCore.StringLiteralDecorator.STARTS_WITH;
                case 3 -> DbImplUtilCore.StringLiteralDecorator.ENDS_WITH;
                case 4 -> DbImplUtilCore.StringLiteralDecorator.PLAIN;
                case 5 -> DbImplUtilCore.StringLiteralDecorator.MATCHES;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        private final DbDataSource getDbDataSource(DbElement target2) {
            DbDataSource dbDataSource;
            if (target2 == null || target2 instanceof DbDataSource) {
                Intrinsics.checkNotNull((Object)target2, (String)"null cannot be cast to non-null type com.intellij.database.psi.DbDataSource");
                dbDataSource = (DbDataSource)target2;
            } else {
                dbDataSource = this.getDbDataSource(target2.getParent());
            }
            return dbDataSource;
        }

        private static final UsageSearcher search$lambda$0(Project $project, FullTextSearchOptions $options, Collection $targets) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$options, (String)"$options");
            Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
            return Companion.createSearcher($project, $options, $targets);
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit createSearcher$lambda$3$lambda$2(Collection $targets, ProgressIndicator $indicator, Project $project, Processor $processor, FullTextSearchOptions $options) {
            void $this$fold$iv;
            Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$processor, (String)"$processor");
            Intrinsics.checkNotNullParameter((Object)$options, (String)"$options");
            List<SearchGroup> groups2 = new TableGrouper($targets).getGroups();
            Iterable iterable = groups2;
            int initial$iv = 0;
            boolean $i$f$fold = false;
            int accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void g2;
                SearchGroup searchGroup = (SearchGroup)element$iv;
                int tablesCount = accumulator$iv;
                boolean bl = false;
                accumulator$iv = tablesCount + g2.getTables().size();
            }
            int tablesCount = accumulator$iv;
            $indicator.setFraction(0.0);
            $indicator.setIndeterminate(false);
            Ref.IntRef currentTablesCount = new Ref.IntRef();
            for (SearchGroup searchGroup : groups2) {
                Set<BasicTableOrView> tables2 = searchGroup.component1();
                LocalDataSource dataSource2 = searchGroup.component2();
                SearchPath searchPath = searchGroup.component3();
                try {
                    DatabaseSessionManager.getFacade($project, dataSource2, null, searchPath, false, null, DGDepartment.TEXT_SEARCH).runSync((Function1)new Function1<InterruptibleDatabaseConnection, Unit>($indicator, $project, (Processor<? super Usage>)$processor, dataSource2, $options, tables2, tablesCount, currentTablesCount){
                        final /* synthetic */ ProgressIndicator $indicator;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ Processor<? super Usage> $processor;
                        final /* synthetic */ LocalDataSource $dataSource;
                        final /* synthetic */ FullTextSearchOptions $options;
                        final /* synthetic */ Set<BasicTableOrView> $tables;
                        final /* synthetic */ int $tablesCount;
                        final /* synthetic */ Ref.IntRef $currentTablesCount;
                        {
                            this.$indicator = $indicator;
                            this.$project = $project;
                            this.$processor = $processor;
                            this.$dataSource = $dataSource;
                            this.$options = $options;
                            this.$tables = $tables;
                            this.$tablesCount = $tablesCount;
                            this.$currentTablesCount = $currentTablesCount;
                            super(1);
                        }

                        public final void invoke(@NotNull InterruptibleDatabaseConnection connection2) {
                            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
                            ProgressIndicator progressIndicator = this.$indicator;
                            Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"$indicator");
                            InterruptibleDatabaseConnectionKt.withCancelling(connection2, progressIndicator, (Function0<Unit>)((Function0)new Function0<Unit>(this.$project, connection2, this.$processor, this.$dataSource, this.$options, this.$indicator, this.$tables, this.$tablesCount, this.$currentTablesCount){
                                final /* synthetic */ Project $project;
                                final /* synthetic */ InterruptibleDatabaseConnection $connection;
                                final /* synthetic */ Processor<? super Usage> $processor;
                                final /* synthetic */ LocalDataSource $dataSource;
                                final /* synthetic */ FullTextSearchOptions $options;
                                final /* synthetic */ ProgressIndicator $indicator;
                                final /* synthetic */ Set<BasicTableOrView> $tables;
                                final /* synthetic */ int $tablesCount;
                                final /* synthetic */ Ref.IntRef $currentTablesCount;
                                {
                                    this.$project = $project;
                                    this.$connection = $connection;
                                    this.$processor = $processor;
                                    this.$dataSource = $dataSource;
                                    this.$options = $options;
                                    this.$indicator = $indicator;
                                    this.$tables = $tables;
                                    this.$tablesCount = $tablesCount;
                                    this.$currentTablesCount = $currentTablesCount;
                                    super(0);
                                }

                                public final void invoke() {
                                    DatabaseConnection databaseConnection = this.$connection;
                                    Processor<? super Usage> processor2 = this.$processor;
                                    Intrinsics.checkNotNullExpressionValue(processor2, (String)"$processor");
                                    ProgressIndicator progressIndicator = this.$indicator;
                                    Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"$indicator");
                                    com.intellij.database.actions.FullTextSearchAction$Companion.access$checkTables(FullTextSearchAction.Companion, this.$project, databaseConnection, processor2, this.$dataSource, this.$options, progressIndicator, this.$tables, this.$tablesCount, this.$currentTablesCount.element);
                                }
                            }));
                        }
                    });
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                currentTablesCount.element += tables2.size();
            }
            return Unit.INSTANCE;
        }

        private static final void createSearcher$lambda$3(Collection $targets, Project $project, FullTextSearchOptions $options, Processor processor2) {
            Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$options, (String)"$options");
            Intrinsics.checkNotNullParameter((Object)processor2, (String)"processor");
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            AsyncUtil.withAsyncFriendly(indicator, () -> Companion.createSearcher$lambda$3$lambda$2($targets, indicator, $project, processor2, $options));
        }

        private static final PredicateSpec getPredicates$lambda$5(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (PredicateSpec)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ void access$checkTables(Companion $this, Project project, DatabaseConnection connection2, Processor processor2, LocalDataSource dataSource2, FullTextSearchOptions options2, ProgressIndicator indicator, Collection tables2, int tablesCount, int currentTablesCount) {
            $this.checkTables(project, connection2, (Processor<? super Usage>)processor2, dataSource2, options2, indicator, tables2, tablesCount, currentTablesCount);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[FullTextSearchOptions.Location.values().length];
                try {
                    nArray[FullTextSearchOptions.Location.CONTAINS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FullTextSearchOptions.Location.STARTS_WITH.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FullTextSearchOptions.Location.ENDS_WITH.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FullTextSearchOptions.Location.LIKE_PATTERN.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FullTextSearchOptions.Location.MATCHES.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0086\u0002J\t\u0010\u0011\u001a\u00020\u0006H\u0086\u0002J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0086\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/actions/FullTextSearchAction$SearchGroup;", "", "tables", "", "Lcom/intellij/database/model/basic/BasicTableOrView;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "(Ljava/util/Set;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/util/SearchPath;)V", "getDataSource", "()Lcom/intellij/database/dataSource/LocalDataSource;", "getSearchPath", "()Lcom/intellij/database/util/SearchPath;", "getTables", "()Ljava/util/Set;", "component1", "component2", "component3", "intellij.database.impl"})
    public static final class SearchGroup {
        @NotNull
        private final Set<BasicTableOrView> tables;
        @NotNull
        private final LocalDataSource dataSource;
        @Nullable
        private final SearchPath searchPath;

        public SearchGroup(@NotNull Set<? extends BasicTableOrView> tables2, @NotNull LocalDataSource dataSource2, @Nullable SearchPath searchPath) {
            Intrinsics.checkNotNullParameter(tables2, (String)"tables");
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            this.tables = tables2;
            this.dataSource = dataSource2;
            this.searchPath = searchPath;
        }

        @NotNull
        public final Set<BasicTableOrView> getTables() {
            return this.tables;
        }

        @NotNull
        public final LocalDataSource getDataSource() {
            return this.dataSource;
        }

        @Nullable
        public final SearchPath getSearchPath() {
            return this.searchPath;
        }

        @NotNull
        public final Set<BasicTableOrView> component1() {
            return this.tables;
        }

        @NotNull
        public final LocalDataSource component2() {
            return this.dataSource;
        }

        @Nullable
        public final SearchPath component3() {
            return this.searchPath;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rJ(\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00160\u0014H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/actions/FullTextSearchAction$TableGrouper;", "", "myTargets", "", "Lcom/intellij/database/psi/DbTable;", "(Ljava/util/Collection;)V", "getAllSchemas", "Lcom/intellij/database/model/basic/BasicSchema;", "namespace", "Lcom/intellij/database/psi/DbNamespaceImpl;", "dbDataSource", "Lcom/intellij/database/psi/DbDataSource;", "getAllTables", "", "Lcom/intellij/database/model/basic/BasicTableOrView;", "schemas", "", "getGroups", "Lcom/intellij/database/actions/FullTextSearchAction$SearchGroup;", "groupedTables", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "", "getSchema", "getTable", "table", "mustReconnect", "", "dbms", "Lcom/intellij/database/Dbms;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nFullTextSearchAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullTextSearchAction.kt\ncom/intellij/database/actions/FullTextSearchAction$TableGrouper\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,345:1\n372#2,7:346\n372#2,7:362\n1446#3,5:353\n988#4:358\n1017#4,3:359\n1020#4,3:369\n152#5,3:372\n*S KotlinDebug\n*F\n+ 1 FullTextSearchAction.kt\ncom/intellij/database/actions/FullTextSearchAction$TableGrouper\n*L\n274#1:346,7\n320#1:362,7\n282#1:353,5\n320#1:358\n320#1:359,3\n320#1:369,3\n323#1:372,3\n*E\n"})
    public static final class TableGrouper {
        @NotNull
        private final Collection<DbTable> myTargets;

        public TableGrouper(@NotNull Collection<? extends DbTable> myTargets) {
            Intrinsics.checkNotNullParameter(myTargets, (String)"myTargets");
            this.myTargets = myTargets;
        }

        @NotNull
        public final List<SearchGroup> getGroups() {
            Map groupedTables = new LinkedHashMap();
            for (DbTable target2 : this.myTargets) {
                BasicTableOrView table;
                Object object;
                LocalDataSource dataSource2;
                DbDataSource dbDataSource;
                if (this.getTable(target2) == null || Companion.getDbDataSource(target2) == null || DbImplUtil.getMaybeLocalDataSource(dbDataSource) == null) continue;
                Map $this$getOrPut$iv = groupedTables;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(dataSource2);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(dataSource2, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).add(table);
            }
            return this.getGroups(groupedTables);
        }

        private final List<BasicTableOrView> getAllTables(Iterable<? extends BasicSchema> schemas2, DbDataSource dbDataSource) {
            List elements2 = new ArrayList();
            for (ObjectKind tableKind : ModelConsts.TABLE_OR_VIEW_KINDS) {
                Iterable<? extends BasicSchema> $this$flatMapTo$iv = schemas2;
                boolean $i$f$flatMapTo = false;
                Iterator<? extends BasicSchema> iterator = $this$flatMapTo$iv.iterator();
                while (iterator.hasNext()) {
                    BasicSchema element$iv;
                    BasicSchema s2 = element$iv = iterator.next();
                    boolean bl = false;
                    JBIterable jBIterable = s2.getDasChildren(tableKind).filter(BasicTableOrView.class).filter(arg_0 -> TableGrouper.getAllTables$lambda$2$lambda$1((Function1)new Function1<BasicTableOrView, Boolean>(dbDataSource){
                        final /* synthetic */ DbDataSource $dbDataSource;
                        {
                            this.$dbDataSource = $dbDataSource;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(BasicTableOrView it2) {
                            return DbImplUtil.findElement(this.$dbDataSource, it2) != null;
                        }
                    }, arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                    Iterable list$iv = (Iterable)jBIterable;
                    CollectionsKt.addAll((Collection)elements2, (Iterable)list$iv);
                }
            }
            return elements2;
        }

        private final Collection<BasicSchema> getAllSchemas(DbNamespaceImpl namespace, DbDataSource dbDataSource) {
            BasicSchema schema2 = this.getSchema(namespace);
            if (schema2 != null) {
                return CollectionsKt.listOf((Object)schema2);
            }
            JBIterable<DbElement> jBIterable = namespace.getDasChildren(ObjectKind.SCHEMA);
            Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"getDasChildren(...)");
            JBIterable<DbElement> dbSchemas = jBIterable;
            List schemas2 = new ArrayList();
            for (DbElement dbSchema : dbSchemas) {
                if (!(dbSchema instanceof DbNamespaceImpl) || (schema2 = this.getSchema((DbNamespaceImpl)dbSchema)) == null || DbImplUtil.findElement(dbDataSource, schema2) == null) continue;
                schemas2.add(schema2);
            }
            return schemas2;
        }

        private final BasicSchema getSchema(DbNamespaceImpl namespace) {
            Object d2 = namespace.getDelegate();
            return d2 instanceof BasicSchema ? (BasicSchema)d2 : null;
        }

        private final BasicTableOrView getTable(DbTable table) {
            Object object = table.getDelegate();
            return object instanceof BasicTableOrView ? (BasicTableOrView)object : null;
        }

        /*
         * WARNING - void declaration
         */
        private final List<SearchGroup> getGroups(Map<LocalDataSource, ? extends Set<? extends BasicTableOrView>> groupedTables) {
            ArrayList<SearchGroup> groups2 = new ArrayList<SearchGroup>();
            for (Map.Entry<LocalDataSource, ? extends Set<? extends BasicTableOrView>> entry : groupedTables.entrySet()) {
                LocalDataSource dataSource2 = entry.getKey();
                Set<? extends BasicTableOrView> tables2 = entry.getValue();
                Dbms dbms = dataSource2.getDbms();
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
                if (this.mustReconnect(dbms)) {
                    void $this$mapTo$iv;
                    void $this$groupByTo$iv$iv;
                    Map $this$groupBy$iv;
                    Sequence sequence = CollectionsKt.asSequence((Iterable)tables2);
                    boolean $i$f$groupBy = false;
                    Iterator iterator = $this$groupBy$iv;
                    Map destination$iv$iv = new LinkedHashMap();
                    boolean $i$f$groupByTo = false;
                    for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                        Object object;
                        BasicTableOrView it2 = (BasicTableOrView)element$iv$iv;
                        boolean bl = false;
                        SearchPath key$iv$iv = DbImplUtil.getDatabaseToSwitch(SearchPath.of(ObjectPaths.of(DbImplUtil.getSearchPathObject(DbImplUtil.getDatabaseDialect(dataSource2.getDbms()), it2))));
                        Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl2 = false;
                            List answer$iv$iv$iv = new ArrayList();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    $this$groupBy$iv = destination$iv$iv;
                    boolean $i$f$mapTo = false;
                    iterator = $this$mapTo$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry item$iv;
                        Map.Entry entry2 = item$iv = iterator.next();
                        Collection collection2 = groups2;
                        boolean bl = false;
                        SearchPath searchPath = (SearchPath)entry2.getKey();
                        List ts2 = (List)entry2.getValue();
                        collection2.add(new SearchGroup(CollectionsKt.toSet((Iterable)ts2), dataSource2, searchPath));
                    }
                    continue;
                }
                groups2.add(new SearchGroup(tables2, dataSource2, null));
            }
            return groups2;
        }

        private final boolean mustReconnect(Dbms dbms) {
            return dbms.isPostgres();
        }

        private static final boolean getAllTables$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

