/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DatabaseObjectRefactoring;
import com.intellij.database.actions.DbDeleteProvider;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasObjectFun;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbIndex;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableKey;
import com.intellij.database.schemaEditor.SchemaEditor;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.view.CommentQueryGenerator;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.DropQueryGenerator;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.builder.ForeignKeyModelBuilder;
import com.intellij.database.view.models.builder.IndexModelBuilder;
import com.intellij.database.view.models.builder.KeyModelBuilder;
import com.intellij.database.view.models.builder.TableModelBuilder;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.database.view.ui.DbBatchIndicesDialog;
import com.intellij.database.view.ui.DbRefactoringDialogHelper;
import com.intellij.database.view.ui.DbTableDialog;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.FieldPanel;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DdlActions {
    @NotNull
    static Pair<DbTable, Set<DbColumn>> getTableAndColumns(AnActionEvent e2) {
        DbTable tableElement;
        Set columns2 = DatabaseContextFun.getSelectedDbElements(e2.getDataContext(), DbColumn.class).toSet();
        Set tables2 = ContainerUtil.map2Set((Collection)columns2, (Function)((NullableFunction)element2 -> element2.getParent()));
        DbTable dbTable = tableElement = tables2.size() == 1 ? (DbTable)tables2.iterator().next() : null;
        if (tableElement == null) {
            @NotNull DataContext dataContext = e2.getDataContext();
            JBIterable<DbElement> selection2 = DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dataContext);
            DbElement element3 = (DbElement)selection2.single();
            tableElement = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)element3, DbTable.class, (boolean)false);
            columns2 = Collections.emptySet();
        }
        Pair pair = Pair.create((Object)tableElement, (Object)columns2);
        if (pair == null) {
            DdlActions.$$$reportNull$$$0(0);
        }
        return pair;
    }

    public static boolean isDbViewToolbar(@Nullable AnActionEvent e2) {
        return e2 != null && e2.getPlace().equals(ActionPlaces.getActionGroupPopupPlace((String)"DatabaseViewToolbar"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DdlActions", "getTableAndColumns"));
    }

    public static class CommentOnObjectAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                CommentOnObjectAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            JBIterable<DbElement> selection2;
            DbElement single;
            if (e2 == null) {
                CommentOnObjectAction.$$$reportNull$$$0(1);
            }
            BasicNamedElement element2 = (single = (DbElement)(selection2 = DatabaseContextFun.getSelectedDbElements(e2.getDataContext())).single()) == null ? null : (BasicNamedElement)ObjectUtils.tryCast((Object)single.getDelegate(), BasicNamedElement.class);
            BasicModel model2 = element2 == null ? null : element2.getModel();
            boolean visible = model2 != null && CommentQueryGenerator.canComment(model2, element2) && DbImplUtilCore.canConnectTo(single);
            e2.getPresentation().setVisible(visible);
            e2.getPresentation().setEnabled(visible && ImportUtil.canModify(single));
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            BasicModel model2;
            JBIterable<DbElement> selection2;
            DbElement single;
            if (e2 == null) {
                CommentOnObjectAction.$$$reportNull$$$0(2);
            }
            final BasicNamedElement element2 = (single = (DbElement)(selection2 = DatabaseContextFun.getSelectedDbElements(e2.getDataContext())).single()) == null ? null : (BasicNamedElement)ObjectUtils.tryCast((Object)single.getDelegate(), BasicNamedElement.class);
            BasicModel basicModel = model2 = element2 == null ? null : element2.getModel();
            if (model2 == null) {
                return;
            }
            BasicNamespace current = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.getSearchPathObjectForSwitch(single.getDataSource(), (DasObject)element2), BasicNamespace.class);
            final CommentQueryGenerator generator = new CommentQueryGenerator(single.getProject(), model2, element2);
            generator.setCurrentNamespace(current);
            new DatabaseScriptDialog(single.getProject(), single.getDataSource().getDelegateDataSource(), ObjectPaths.searchPathOf(current), DatabaseBundle.message("action.DatabaseView.Ddl.CommentOnObject.title", new Object[0])){
                private FieldPanel myComment;

                @Override
                protected ScriptingTask getTask() {
                    return generator.createTask(null);
                }

                @Override
                protected AsyncTask<ScriptingTask> applyAndGetTask() {
                    return AsyncTask.completed(this.getTask());
                }

                @Override
                protected void settingsChanged(ScriptingOptions options2) {
                    generator.setOptions(options2);
                    this.regenerate();
                }

                @Override
                protected JComponent createCenterPanel() {
                    this.myComment = new FieldPanel(DatabaseBundle.message("action.DatabaseView.Ddl.CommentOnObject.comment", new Object[0]), null, null, () -> this.regenerate());
                    this.myComment.setText(element2.getComment());
                    return new BorderLayoutPanel().addToTop((Component)this.myComment).addToCenter((Component)Objects.requireNonNull(super.createCenterPanel()));
                }

                private void regenerate() {
                    this.generateText(this.myComment.getText());
                }

                @Nullable
                public JComponent getPreferredFocusedComponent() {
                    return this.myComment.getTextField();
                }

                private void generateText(String comment) {
                    this.updateText(generator.generate(comment));
                }

                @Override
                protected void fillContext(@NotNull DatabaseRefactoringHandler handler2) {
                    if (handler2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    handler2.include(element2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/actions/DdlActions$CommentOnObjectAction$1", "fillContext"));
                }
            }.initAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$CommentOnObjectAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$CommentOnObjectAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class DropForeignKeyAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                DropForeignKeyAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            JBIterable<DbColumn> selection2;
            DbColumn column2;
            if (e2 == null) {
                DropForeignKeyAction.$$$reportNull$$$0(1);
            }
            boolean visible = (column2 = (DbColumn)(selection2 = DatabaseContextFun.getSelectedDbElements(e2.getDataContext(), DbColumn.class)).single()) != null && SchemaEditor.forDbms(DbImplUtilCore.getDbms(column2)).getDbEditorCaps().getTableEditorCaps(true).getForeignKeys().canRemove() && DbImplUtilCore.canConnectTo(column2) && DasUtil.isForeign(column2);
            e2.getPresentation().setVisible(visible);
            e2.getPresentation().setEnabled(visible && ImportUtil.canModify(column2));
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            DbColumn column2;
            DbTable table;
            if (e2 == null) {
                DropForeignKeyAction.$$$reportNull$$$0(2);
            }
            DbTable dbTable = table = (column2 = (DbColumn)DatabaseContextFun.getSelectedDbElements(e2.getDataContext(), DbColumn.class).first()) == null ? null : column2.getTable();
            if (table == null) {
                return;
            }
            DbDataSource dataSource2 = column2.getDataSource();
            BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(DbImplUtilCore.getSearchPathObjectForSwitch(column2)), BasicNamespace.class);
            BasicModel model2 = (BasicModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModel.class);
            if (model2 == null) {
                return;
            }
            DropQueryGenerator generator = new DropQueryGenerator(dataSource2.getProject(), model2);
            JBIterable selection2 = JBIterable.from(DasUtil.getForeignKeys(table)).filter(key2 -> DasUtil.containsName(column2.getName(), key2.getColumnsRef())).filter(DbElement.class);
            JBIterable<BasicElement> elements2 = DbDeleteProvider.getElements((JBIterable<DbElement>)selection2);
            generator.setItems((Iterable<BasicElement>)elements2);
            generator.setCurrentNamespace(namespace);
            DbDeleteProvider.showDialogAndRun(dataSource2.getProject(), dataSource2, ObjectPaths.searchPathOf(namespace), elements2, generator);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$DropForeignKeyAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$DropForeignKeyAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class DropPrimaryKeyAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                DropPrimaryKeyAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            JBIterable<DbElement> selection2;
            DbElement element2;
            DbTable tableElement;
            if (e2 == null) {
                DropPrimaryKeyAction.$$$reportNull$$$0(1);
            }
            boolean visible = (tableElement = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)(element2 = (DbElement)(selection2 = DatabaseContextFun.getSelectedDbElements(e2.getDataContext())).single()), DbTable.class, (boolean)false)) != null && SchemaEditor.forDbms(DbImplUtilCore.getDbms(tableElement)).getDbEditorCaps().getTableEditorCaps(true).getPrimaryKey().canRemove() && DbImplUtilCore.canConnectTo(tableElement) && DasUtil.getPrimaryKey(tableElement) != null;
            e2.getPresentation().setVisible(visible);
            e2.getPresentation().setEnabled(visible && ImportUtil.canModify(tableElement));
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            DbElement element2;
            DbTable table;
            if (e2 == null) {
                DropPrimaryKeyAction.$$$reportNull$$$0(2);
            }
            if ((table = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)(element2 = (DbElement)DatabaseContextFun.getSelectedDbElements(e2.getDataContext()).first()), DbTable.class, (boolean)false)) == null) {
                return;
            }
            DbTableKey pk = (DbTableKey)DasUtil.getPrimaryKey(table);
            if (pk == null) {
                return;
            }
            DbDataSource dataSource2 = pk.getDataSource();
            BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(DbImplUtilCore.getSearchPathObjectForSwitch(pk)), BasicNamespace.class);
            BasicModel model2 = (BasicModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModel.class);
            if (model2 == null) {
                return;
            }
            Project project = dataSource2.getProject();
            DropQueryGenerator generator = new DropQueryGenerator(project, model2);
            JBIterable selection2 = JBIterable.of((Object)pk);
            generator.setItems((Iterable<BasicElement>)DbDeleteProvider.getElements((JBIterable<DbElement>)selection2));
            generator.setCurrentNamespace(namespace);
            BasicElement pkElement = DasObjectFun.getBasicElement(pk);
            if (pkElement != null) {
                DbDeleteProvider.showDialogAndRun(project, dataSource2, ObjectPaths.searchPathOf(namespace), Collections.singleton(pkElement), generator);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$DropPrimaryKeyAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$DropPrimaryKeyAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class AddForeignKeyAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                AddForeignKeyAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                AddForeignKeyAction.$$$reportNull$$$0(1);
            }
            if (DdlActions.isDbViewToolbar(e2) || !DatabaseObjectRefactoring.isOldModifyEnabled()) {
                e2.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e2);
            boolean visible = pair.first != null && DbImplUtilCore.canConnectTo((DbElement)pair.first) && DbRefactoringDialogHelper.canAddForeignKey(new DatabaseEditorContext((DbElement)pair.first, null), (DasTable)pair.first);
            e2.getPresentation().setVisible(visible);
            e2.getPresentation().setEnabled(visible && ImportUtil.canModify((DbElement)pair.first));
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                AddForeignKeyAction.$$$reportNull$$$0(2);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e2);
            DbTable table = (DbTable)pair.first;
            BasicTable basicTable = (BasicTable)ObjectUtils.tryCast((Object)(table == null ? null : table.getDelegate()), BasicTable.class);
            Set columns2 = JBIterable.from((Iterable)((Iterable)pair.second)).transform(DbElement::getDelegate).filter(BasicTableColumn.class).toSet();
            if (basicTable == null) {
                return;
            }
            DbTableDialog dialog = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext(table, null), basicTable);
            DbRefactoringDialogHelper.bootstrap(dialog, (Computable<? extends DeObject>)((Computable)() -> {
                Ref newFk = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((ForeignKeyModelBuilder)((Object)TableModelBuilder.modify(((DatabaseTableEditor)dialog.getEditor()).getTableModel()).withForeignKey(""))).addRefRefs((Iterable<DeColumn>)DbRefactoringDialogHelper.export(dialog, columns2))).addAndGet((Ref<DeForeignKey>)newFk)).leave()).commit();
                return (DeObject)newFk.get();
            })).finishAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$AddForeignKeyAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$AddForeignKeyAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class AddPrimaryKeyAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                AddPrimaryKeyAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                AddPrimaryKeyAction.$$$reportNull$$$0(1);
            }
            if (DdlActions.isDbViewToolbar(e2) || !DatabaseObjectRefactoring.isOldModifyEnabled()) {
                e2.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e2);
            boolean visible = pair.first != null && DbImplUtilCore.canConnectTo((DbElement)pair.first) && DasUtil.getPrimaryKey((DasTable)pair.first) == null && DbRefactoringDialogHelper.canAddPrimaryKey(new DatabaseEditorContext((DbElement)pair.first, null), (DasTable)pair.first) && ((DbTable)pair.first).getKind() == ObjectKind.TABLE && !((Set)pair.second).isEmpty();
            e2.getPresentation().setVisible(visible);
            e2.getPresentation().setEnabled(visible && ImportUtil.canModify((DbElement)pair.first));
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                AddPrimaryKeyAction.$$$reportNull$$$0(2);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e2);
            DbTable table = (DbTable)pair.first;
            BasicTable basicTable = (BasicTable)ObjectUtils.tryCast((Object)(table == null ? null : table.getDelegate()), BasicTable.class);
            Set columns2 = JBIterable.from((Iterable)((Iterable)pair.second)).transform(DbElement::getDelegate).filter(BasicTableColumn.class).toSet();
            if (basicTable == null) {
                return;
            }
            DbTableDialog dialog = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext(table, null), basicTable);
            DbRefactoringDialogHelper.bootstrap(dialog, (Computable<? extends DeObject>)((Computable)() -> {
                Ref newKey = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableKeyModelBuilder)((TableModelBuilder.TableKeyModelBuilder)((KeyModelBuilder)((Object)((TableModelBuilder.TableKeyModelBuilder)TableModelBuilder.modify(((DatabaseTableEditor)dialog.getEditor()).getTableModel()).withKey("")).setPrimary(true, false))).addColumns((Iterable<DeColumn>)DbRefactoringDialogHelper.export(dialog, columns2), DasIndex.Sorting.NONE)).addAndGet((Ref<DeTableKey>)newKey)).leave()).commit();
                return (DeObject)newKey.get();
            })).finishAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$AddPrimaryKeyAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$AddPrimaryKeyAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class BatchAddIndicesAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                BatchAddIndicesAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        @NotNull
        private static List<DbColumn> getColumns(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                BatchAddIndicesAction.$$$reportNull$$$0(1);
            }
            Set columns2 = DatabaseContextFun.getSelectedDbElements(e2.getDataContext(), DbColumn.class).toSet();
            DbDataSource dataSource2 = null;
            for (DbColumn column2 : columns2) {
                if (dataSource2 == null) {
                    dataSource2 = column2.getDataSource();
                }
                if (dataSource2 == column2.getDataSource()) continue;
                List<DbColumn> list = Collections.emptyList();
                if (list == null) {
                    BatchAddIndicesAction.$$$reportNull$$$0(2);
                }
                return list;
            }
            return new ArrayList<DbColumn>(columns2);
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                BatchAddIndicesAction.$$$reportNull$$$0(3);
            }
            if (DdlActions.isDbViewToolbar(e2) || !DatabaseObjectRefactoring.isOldModifyEnabled()) {
                e2.getPresentation().setEnabledAndVisible(false);
                return;
            }
            List<DbColumn> columns2 = BatchAddIndicesAction.getColumns(e2);
            boolean visible = columns2.size() > 1 && DbImplUtilCore.canConnectTo(columns2.get(0)) && DbBatchIndicesDialog.canAddAnything(new DatabaseEditorContext(columns2.get(0), null), columns2);
            e2.getPresentation().setVisible(visible);
            e2.getPresentation().setEnabled(visible && ImportUtil.canModify(columns2.get(0)));
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            List<DbColumn> columns2;
            List basicColumns;
            if (e2 == null) {
                BatchAddIndicesAction.$$$reportNull$$$0(4);
            }
            if ((basicColumns = JBIterable.from(columns2 = BatchAddIndicesAction.getColumns(e2)).transform(DbElement::getDelegate).filter(BasicTableColumn.class).toList()).size() < 2) {
                return;
            }
            DbBatchIndicesDialog.newBatchAddIndicesDialog(new DatabaseEditorContext(columns2.get(0), null), basicColumns).finishAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$BatchAddIndicesAction";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$BatchAddIndicesAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumns";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getColumns";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class AddIndexAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                AddIndexAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                AddIndexAction.$$$reportNull$$$0(1);
            }
            if (DdlActions.isDbViewToolbar(e2) || !DatabaseObjectRefactoring.isOldModifyEnabled()) {
                e2.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e2);
            boolean visible = pair.first != null && DbImplUtilCore.canConnectTo((DbElement)pair.first) && DbRefactoringDialogHelper.canAddIndex(new DatabaseEditorContext((DbElement)pair.first, null), (DasTable)pair.first) && !DbImplUtilCore.getDbms((DbElement)pair.first).isMongo();
            e2.getPresentation().setVisible(visible);
            e2.getPresentation().setEnabled(visible && ImportUtil.canModify((DbElement)pair.first));
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                AddIndexAction.$$$reportNull$$$0(2);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e2);
            DbTable table = (DbTable)pair.first;
            BasicTable basicTable = (BasicTable)ObjectUtils.tryCast((Object)(table == null ? null : table.getDelegate()), BasicTable.class);
            Set columns2 = JBIterable.from((Iterable)((Iterable)pair.second)).transform(DbElement::getDelegate).filter(BasicTableColumn.class).toSet();
            if (basicTable == null) {
                return;
            }
            DbTableDialog dialog = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext(table, null), basicTable);
            DbRefactoringDialogHelper.bootstrap(dialog, (Computable<? extends DeObject>)((Computable)() -> {
                Ref newIndex = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((IndexModelBuilder)((Object)TableModelBuilder.modify(((DatabaseTableEditor)dialog.getEditor()).getTableModel()).withIndex(""))).addColumns((Iterable<DeColumn>)DbRefactoringDialogHelper.export(dialog, columns2), DasIndex.Sorting.NONE)).addAndGet((Ref<DeIndex>)newIndex)).leave()).commit();
                return (DeObject)newIndex.get();
            })).finishAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$AddIndexAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$AddIndexAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class AddColumnAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                AddColumnAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                AddColumnAction.$$$reportNull$$$0(1);
            }
            if (DdlActions.isDbViewToolbar(e2) || !DatabaseObjectRefactoring.isOldModifyEnabled()) {
                e2.getPresentation().setEnabledAndVisible(false);
                return;
            }
            @NotNull DataContext dataContext = e2.getDataContext();
            JBIterable<DbElement> selection2 = DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dataContext);
            DbElement element2 = (DbElement)selection2.single();
            DbTable table = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)element2, DbTable.class, (boolean)false);
            boolean visible = table != null && SchemaEditor.forDbms(DbImplUtilCore.getDbms(table)).getDbEditorCaps().getTableEditorCaps(true).getColumns().canAdd() && DbImplUtilCore.canConnectTo(table) && DbRefactoringDialogHelper.canAddColumn(new DatabaseEditorContext(table, null), table) && table.getKind() == ObjectKind.TABLE;
            e2.getPresentation().setVisible(visible);
            e2.getPresentation().setEnabled(visible && ImportUtil.canModify(table));
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            DataContext dataContext;
            DbElement element2;
            DbTable table;
            if (e2 == null) {
                AddColumnAction.$$$reportNull$$$0(2);
            }
            if ((table = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)(element2 = (DbElement)DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dataContext = e2.getDataContext()).single()), DbTable.class, (boolean)false)) == null) {
                return;
            }
            AddColumnAction.perform(table, (DbColumn)PsiTreeUtil.getParentOfType((PsiElement)element2, DbColumn.class, (boolean)false), "new_column");
        }

        public static void perform(@NotNull DbTable table, @Nullable DbColumn anchor2, @NotNull String colName) {
            BasicTable basicTable;
            if (table == null) {
                AddColumnAction.$$$reportNull$$$0(3);
            }
            if (colName == null) {
                AddColumnAction.$$$reportNull$$$0(4);
            }
            if ((basicTable = (BasicTable)ObjectUtils.tryCast((Object)table.getDelegate(), BasicTable.class)) == null) {
                return;
            }
            DbTableDialog dialog = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext(table, null), basicTable);
            DbRefactoringDialogHelper.bootstrap(dialog, (Computable<? extends DeObject>)((Computable)() -> {
                List<DeColumn> columns2 = ((DatabaseTableEditor)dialog.getEditor()).getTable().columns;
                int idx = columns2.size();
                if (anchor2 != null && ((DatabaseTableEditor)dialog.getEditor()).getCaps().getColumns().canReorder()) {
                    String name2 = anchor2.getName();
                    idx = 0;
                    for (DeColumn column2 : columns2) {
                        ++idx;
                        if (!column2.name.equals(name2)) continue;
                        break;
                    }
                }
                Ref newCol = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableColumnModelBuilder)((TableModelBuilder.TableColumnModelBuilder)TableModelBuilder.modify(((DatabaseTableEditor)dialog.getEditor()).getTableModel()).withColumn(colName)).addAndGet((Ref<DeColumn>)newCol, idx)).leave()).commit();
                return (DeObject)newCol.get();
            })).finishAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$AddColumnAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$AddColumnAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class BatchModifyIndicesAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        @NotNull
        private static List<DbIndex> getIndicesToModify(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(1);
            }
            @NotNull DataContext dataContext = e2.getDataContext();
            JBIterable elements2 = DatabaseContextFun.getSelectedDbElementsExpandingGroups(dataContext).filter(DbIndex.class);
            DbDataSource dataSource2 = null;
            for (DbIndex element2 : elements2) {
                DbDataSource currentSource = element2.getDataSource();
                if (dataSource2 == null) {
                    dataSource2 = currentSource;
                }
                if (dataSource2 == currentSource) continue;
                List<DbIndex> list = Collections.emptyList();
                if (list == null) {
                    BatchModifyIndicesAction.$$$reportNull$$$0(2);
                }
                return list;
            }
            List list = elements2.toList();
            if (list == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(3);
            }
            return list;
        }

        public void update(@NotNull AnActionEvent e2) {
            List<DbIndex> indices;
            if (e2 == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(4);
            }
            boolean visible = (indices = BatchModifyIndicesAction.getIndicesToModify(e2)).size() > 1 && DbImplUtilCore.canConnectTo(indices.get(0)) && DbBatchIndicesDialog.canModifyAnything(new DatabaseEditorContext(indices.get(0), null), indices);
            e2.getPresentation().setVisible(visible);
            e2.getPresentation().setEnabled(visible && ImportUtil.canModify(indices.get(0)));
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            List<DbIndex> indices;
            if (e2 == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(5);
            }
            if ((indices = BatchModifyIndicesAction.getIndicesToModify(e2)).size() < 2) {
                return;
            }
            BatchModifyIndicesAction.showModifyIndicesDialogAndRun(indices);
        }

        public static void showModifyIndicesDialogAndRun(@NotNull List<DbIndex> indices) {
            if (indices == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(6);
            }
            List basicIndices = JBIterable.from(indices).transform(DbElement::getDelegate).filter(BasicIndex.class).toList();
            DbBatchIndicesDialog.newBatchModifyIndicesDialog(new DatabaseEditorContext(indices.get(0), null), basicIndices).finishAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$BatchModifyIndicesAction";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indices";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$BatchModifyIndicesAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndicesToModify";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getIndicesToModify";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "showModifyIndicesDialogAndRun";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class AddTableAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                AddTableAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                AddTableAction.$$$reportNull$$$0(1);
            }
            if (DdlActions.isDbViewToolbar(e2) || !DatabaseObjectRefactoring.isOldModifyEnabled()) {
                e2.getPresentation().setEnabledAndVisible(false);
                return;
            }
            DbElement element2 = AddTableAction.getElement(e2);
            DbElement parent2 = (DbElement)((Object)DbImplUtil.getTopSingleNamespace(element2));
            boolean visible = parent2 != null && parent2.getKind() == ObjectKind.SCHEMA && (DbImplUtilCore.canConnectTo(parent2) || DbImplUtilCore.isDdlElement(element2)) && !DbImplUtilCore.getDbms(element2).isMongo();
            e2.getPresentation().setVisible(visible);
            e2.getPresentation().setEnabled(visible && ImportUtil.canModify(parent2) && AddTableAction.canDoAnything(element2));
        }

        private static boolean canDoAnything(DbElement element2) {
            return SchemaEditor.forDbms(DbImplUtilCore.getDbms(element2)).getDbEditorCaps().getTableEditorCaps(false).canDoAnything();
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            DbElement element2;
            if (e2 == null) {
                AddTableAction.$$$reportNull$$$0(2);
            }
            if ((element2 = AddTableAction.getElement(e2)) == null) {
                return;
            }
            DasNamespace namespace = DbImplUtil.getTopSingleNamespace(element2);
            Pair<BasicElement, DatabaseEditorContext> info2 = DatabaseObjectRefactoring.prepareForEditing((DbNamespaceImpl)namespace, namespace);
            if (info2 == null || !(info2.first instanceof BasicSchema)) {
                return;
            }
            AddTableAction.showAddTableDialogAndRun((BasicSchema)info2.first, (DatabaseEditorContext)info2.second, "table_name", ContainerUtil.emptyList());
        }

        @Nullable
        private static DbElement getElement(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                AddTableAction.$$$reportNull$$$0(3);
            }
            @NotNull DataContext dataContext = e2.getDataContext();
            return (DbElement)DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dataContext).first();
        }

        public static void showAddTableDialogAndRun(@Nullable BasicSchema schema2, @Nullable DatabaseEditorContext context, @NotNull String defaultName, @NotNull Collection<String> columnNames) {
            if (defaultName == null) {
                AddTableAction.$$$reportNull$$$0(4);
            }
            if (columnNames == null) {
                AddTableAction.$$$reportNull$$$0(5);
            }
            if (context != null) {
                DbRefactoringDialogHelper.newAddTableDialog(context, schema2, defaultName, columnNames).finishAndShow();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$AddTableAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$AddTableAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "showAddTableDialogAndRun";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

