/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.session.PerProjectFileAttributes;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseToggleNotebookModeAction
extends ToggleAction {
    private static final Logger LOG = Logger.getInstance(DatabaseToggleNotebookModeAction.class);
    private static final String NOTEBOOK_SETTING_ID_KEY = "database.notebook.setting.id";
    private static final PerProjectFileAttributes ourFileAttributes = new PerProjectFileAttributes("database.notebook.mode", 1);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(1);
        }
        JdbcConsole console = DatabaseToggleNotebookModeAction.getConsole(e2);
        e2.getPresentation().setEnabledAndVisible(console != null);
        super.update(e2);
    }

    public boolean isSelected(@NotNull AnActionEvent e2) {
        JdbcConsole console;
        if (e2 == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(2);
        }
        return (console = DatabaseToggleNotebookModeAction.getConsole(e2)) != null && console.isNotebookMode();
    }

    public void setSelected(@NotNull AnActionEvent e2, boolean state) {
        JdbcConsole console;
        if (e2 == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(3);
        }
        if ((console = DatabaseToggleNotebookModeAction.getConsole(e2)) == null) {
            return;
        }
        console.setNotebookMode(state, true);
    }

    public static void setNotebookMode(@NotNull Project project, @NotNull JdbcConsole console, boolean state) {
        if (project == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(4);
        }
        if (console == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(5);
        }
        String id = DatabaseToggleNotebookModeAction.getCurrentSettingId();
        DaemonCodeAnalyzer.getInstance((Project)project).restart(console.getFile());
        FileAttribute attribute = ourFileAttributes.get(project);
        if (attribute != null) {
            DbImplUtilCore.writeVFSAttributeSafe(console.getVirtualFile(), attribute, new Value(id, state).toString());
        }
    }

    public static boolean isNotebookMode(@NotNull Project project, @NotNull VirtualFile file) {
        FileAttribute attribute;
        if (project == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(6);
        }
        if (file == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(7);
        }
        if ((attribute = ourFileAttributes.get(project)) == null) {
            return false;
        }
        String saved = DbImplUtilCore.readVFSAttributeSafe(file, attribute);
        Value value2 = saved == null ? null : Value.from(saved);
        return value2 == null || !value2.id.equals(DatabaseToggleNotebookModeAction.getCurrentSettingId()) ? DatabaseSettings.getSettings().notebookMode : value2.state;
    }

    public static boolean isAvailable(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(8);
        }
        if (file == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(9);
        }
        return !DbSrcUtilsCore.isDbSrcFile(file) && (DbImplUtil.isSqlScriptFile(project, file) || ScriptModelUtilCore.isJSFile(project, file));
    }

    public static void forgetSavedState() {
        PropertiesComponent.getInstance().setValue(NOTEBOOK_SETTING_ID_KEY, null);
    }

    @Nullable
    private static JdbcConsole getConsole(@NotNull AnActionEvent e2) {
        JdbcConsole console;
        if (e2 == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(10);
        }
        return (console = JdbcConsole.findConsole(e2)) == null ? null : (DatabaseToggleNotebookModeAction.isAvailable(console.getProject(), console.getVirtualFile()) ? console : null);
    }

    @NotNull
    private static String getCurrentSettingId() {
        PropertiesComponent component2 = PropertiesComponent.getInstance();
        String value2 = component2.getValue(NOTEBOOK_SETTING_ID_KEY);
        if (value2 == null) {
            String result2 = UUID.randomUUID().toString();
            component2.setValue(NOTEBOOK_SETTING_ID_KEY, result2);
            String string = result2;
            if (string == null) {
                DatabaseToggleNotebookModeAction.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = value2;
        if (string == null) {
            DatabaseToggleNotebookModeAction.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DatabaseToggleNotebookModeAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DatabaseToggleNotebookModeAction";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentSettingId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setNotebookMode";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isNotebookMode";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getConsole";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }

    private static class Value {
        final String id;
        final boolean state;

        Value(@NotNull String id, boolean state) {
            if (id == null) {
                Value.$$$reportNull$$$0(0);
            }
            this.id = id;
            this.state = state;
        }

        public String toString() {
            return this.id + " " + this.state;
        }

        @Nullable
        static Value from(@NotNull String s2) {
            String[] values2;
            if (s2 == null) {
                Value.$$$reportNull$$$0(1);
            }
            if ((values2 = s2.split(" ")).length != 2) {
                return null;
            }
            try {
                String id = UUID.fromString(values2[0]).toString();
                boolean state = Boolean.parseBoolean(values2[1]);
                return new Value(id, state);
            }
            catch (Exception e2) {
                LOG.warn((Throwable)e2);
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DatabaseToggleNotebookModeAction$Value";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "from";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

