/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSourceExportImportHelperKt;
import com.intellij.database.dataSource.DataSourceSerializedSettingsTransferable;
import com.intellij.database.dataSource.DataSourceSettingsCapsule;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u001a\u0018\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002\u001a \u0010\u000e\u001a\u00020\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u001a#\u0010\u000e\u001a\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0003\u00a2\u0006\u0002\b\u0012\u001a\n\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u001a\u0013\u0010\u0016\u001a\u00020\u00012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0017\u001a&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007\u001a&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u001c2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007\u001a\u001e\u0010\u001d\u001a\u00020\u00012\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f2\u0006\u0010\u0019\u001a\u00020\u0007H\u0000\u001a\u001c\u0010 \u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\"\u001a\"\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\u001c2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u001c\u00a8\u0006$"}, d2={"applyDataSource", "", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "project", "Lcom/intellij/openapi/project/Project;", "doCopyDataSourceSettings", "", "dss", "", "finishTestDataSource", "dataSource", "storage", "Lcom/intellij/database/access/DatabaseCredentials;", "focusOnDataSources", "dataSources", "dbDataSources", "Lcom/intellij/database/psi/DbDataSource;", "focusOnDbDataSources", "getTextFromClipboard", "getTransferableFromClipboard", "Ljava/awt/datatransfer/Transferable;", "importDataSourcesFromClipboard", "Lorg/jetbrains/annotations/Nullable;", "importDataSourcesFromTextDirectly", "text", "groupPath", "importDataSourcesFromTextViaDialog", "", "putExportedSettingsIntoTheClipboard", "ids", "", "removeDataSources", "dsIds", "", "showDataSourcesConfigurationDialog", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDataSourceSettingsHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceSettingsHelper.kt\ncom/intellij/database/actions/DataSourceSettingsHelperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,144:1\n1549#2:145\n1620#2,3:146\n37#3,2:149\n*S KotlinDebug\n*F\n+ 1 DataSourceSettingsHelper.kt\ncom/intellij/database/actions/DataSourceSettingsHelperKt\n*L\n29#1:145\n29#1:146,3\n34#1:149,2\n*E\n"})
public final class DataSourceSettingsHelperKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String doCopyDataSourceSettings(@NotNull Collection<? extends LocalDataSource> dss2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(dss2, (String)"dss");
        String string = DataSourceExportImportHelperKt.exportDataSourcesSettings(dss2);
        if (string == null) {
            return null;
        }
        String text2 = string;
        Iterable $this$map$iv = dss2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            LocalDataSource localDataSource = (LocalDataSource)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            String string2 = it2.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUniqueId(...)");
            collection2.add(string2);
        }
        DataSourceSettingsHelperKt.putExportedSettingsIntoTheClipboard((List)destination$iv$iv, text2);
        return text2;
    }

    public static final void putExportedSettingsIntoTheClipboard(@NotNull Iterable<String> ids, @NotNull String text2) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Collection $this$toTypedArray$iv = CollectionsKt.toList(ids);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        DataSourceSerializedSettingsTransferable transferHandle = new DataSourceSerializedSettingsTransferable(thisCollection$iv.toArray(new String[0]), text2);
        CopyPasteManager.getInstance().setContents((Transferable)transferHandle);
    }

    public static final void importDataSourcesFromClipboard(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = DataSourceSettingsHelperKt.getTextFromClipboard();
        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
            return;
        }
        String text2 = string;
        if (DataSourceExportImportHelperKt.isDataSourceSettings(text2)) {
            DataSourceSettingsHelperKt.importDataSourcesFromTextViaDialog(text2, project, "");
        }
    }

    private static final String getTextFromClipboard() {
        Transferable t = DataSourceSettingsHelperKt.getTransferableFromClipboard();
        if (t == null) {
            return null;
        }
        if (t.isDataFlavorSupported(DataSourceSerializedSettingsTransferable.FLAVOR)) {
            Object object = t.getTransferData(DataSourceSerializedSettingsTransferable.FLAVOR);
            DataSourceSettingsCapsule dataSourceSettingsCapsule = object instanceof DataSourceSettingsCapsule ? (DataSourceSettingsCapsule)object : null;
            return dataSourceSettingsCapsule != null ? dataSourceSettingsCapsule.content : null;
        }
        if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            Object object = t.getTransferData(DataFlavor.stringFlavor);
            return object instanceof String ? (String)object : null;
        }
        return null;
    }

    @Nullable
    public static final Transferable getTransferableFromClipboard() {
        CopyPasteManager cpm = CopyPasteManager.getInstance();
        return cpm.getContents();
    }

    @NotNull
    public static final Collection<LocalDataSource> importDataSourcesFromTextDirectly(@NotNull String text2, @NotNull Project project, @Nullable String groupPath) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ArrayList<LocalDataSource> dataSources2 = DataSourceExportImportHelperKt.importDataSourceFromText(text2, project);
        for (LocalDataSource dataSource2 : dataSources2) {
            dataSource2.setGroupName(groupPath);
            Intrinsics.checkNotNull((Object)dataSource2);
            DataSourceSettingsHelperKt.applyDataSource(dataSource2, project);
        }
        DataSourceSettingsHelperKt.focusOnDataSources((Collection<? extends LocalDataSource>)dataSources2, project);
        return dataSources2;
    }

    @NotNull
    public static final List<DbDataSource> importDataSourcesFromTextViaDialog(@NotNull String text2, @NotNull Project project, @Nullable String groupPath) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ArrayList<LocalDataSource> dataSources2 = DataSourceExportImportHelperKt.importDataSourceFromText(text2, project);
        if (!Intrinsics.areEqual((Object)groupPath, (Object)"")) {
            for (LocalDataSource dataSource2 : dataSources2) {
                dataSource2.setGroupName(groupPath);
            }
        }
        return DataSourceSettingsHelperKt.showDataSourcesConfigurationDialog(project, (List<? extends LocalDataSource>)dataSources2);
    }

    @NotNull
    public static final List<DbDataSource> showDataSourcesConfigurationDialog(@NotNull Project project, @NotNull List<? extends LocalDataSource> dataSources2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(dataSources2, (String)"dataSources");
        if (dataSources2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List<DbDataSource> list = DataSourceManagerDialog.showDialog(DbPsiFacade.getInstance(project), null, null, (Consumer<? super DatabaseConfigEditor>)((Consumer)arg_0 -> DataSourceSettingsHelperKt.showDataSourcesConfigurationDialog$lambda$1((Function1)new Function1<DatabaseConfigEditor, Unit>(dataSources2){
            final /* synthetic */ List<LocalDataSource> $dataSources;
            {
                this.$dataSources = $dataSources;
                super(1);
            }

            public final void invoke(DatabaseConfigEditor editor2) {
                for (LocalDataSource dataSource2 : this.$dataSources) {
                    DatabaseCredentials databaseCredentials = editor2.getSecretService();
                    Intrinsics.checkNotNullExpressionValue((Object)databaseCredentials, (String)"getSecretService(...)");
                    DataSourceSettingsHelperKt.access$finishTestDataSource(dataSource2, databaseCredentials);
                    editor2.onCreated(dataSource2);
                }
            }
        }, arg_0)));
        Intrinsics.checkNotNullExpressionValue(list, (String)"showDialog(...)");
        List<DbDataSource> dss2 = list;
        DataSourceSettingsHelperKt.focusOnDbDataSources((Collection<? extends DbDataSource>)dss2, project);
        return dss2;
    }

    public static final void applyDataSource(@NotNull LocalDataSource ds, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DataSourceSettingsHelperKt.finishTestDataSource(ds, DatabaseCredentials.Companion.getInstance());
        DataSourceStorage.getProjectStorage(project).addDataSource(ds);
    }

    private static final void finishTestDataSource(LocalDataSource dataSource2, DatabaseCredentials storage) {
        block0: {
            String key2 = "test-user-password";
            String string = dataSource2.getAdditionalProperty(key2);
            if (string == null) break block0;
            String it2 = string;
            boolean bl = false;
            dataSource2.setAdditionalProperty(key2, null);
            DatabaseCredentialsAuthProvider.Companion.saveCredentialsConfig(dataSource2, storage, new DatabaseCredentialsAuthProvider.UserPassCredentials(dataSource2.getUsername(), new OneTimeString(it2), LocalDataSource.Storage.PERSIST), false);
            dataSource2.setAutoSynchronize(true);
        }
    }

    private static final void focusOnDataSources(Collection<? extends LocalDataSource> dataSources2, Project project) {
        Project project2 = project;
        if (project2 == null) {
            project2 = DefaultProjectFactory.getInstance().getDefaultProject();
        }
        Project p2 = project2;
        ArrayList dbDataSources = new ArrayList(dataSources2.size());
        for (LocalDataSource localDataSource : dataSources2) {
            DbDataSource x = DbImplUtil.getDbDataSource(p2, localDataSource);
            if (x == null) continue;
            ((Collection)dbDataSources).add(x);
        }
        if (dbDataSources.isEmpty()) {
            return;
        }
        Collection collection2 = dbDataSources;
        Intrinsics.checkNotNull((Object)p2);
        DataSourceSettingsHelperKt.focusOnDbDataSources(collection2, p2);
    }

    @JvmName(name="focusOnDbDataSources")
    private static final void focusOnDbDataSources(Collection<? extends DbDataSource> dbDataSources, Project project) {
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> DataSourceSettingsHelperKt.focusOnDataSources$lambda$4(application, project, dbDataSources));
    }

    public static final void removeDataSources(@NotNull Project project, @NotNull Set<String> dsIds) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(dsIds, (String)"dsIds");
        DataSourceStorage dataSourceStorage = DataSourceStorage.getProjectStorage(project);
        ArrayList dsToRemove = new ArrayList(dsIds.size());
        for (String id : dsIds) {
            LocalDataSource ds = dataSourceStorage.getDataSourceById(id);
            if (ds == null) continue;
            ((Collection)dsToRemove).add(ds);
        }
        for (LocalDataSource ds : dsToRemove) {
            dataSourceStorage.removeDataSource(ds);
        }
    }

    private static final void showDataSourcesConfigurationDialog$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void focusOnDataSources$lambda$4$lambda$3(Project $project, Collection $dbDataSources) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$dbDataSources, (String)"$dbDataSources");
        DatabaseView.refreshViewAndSelect($project, $dbDataSources);
    }

    private static final void focusOnDataSources$lambda$4(Application $application, Project $project, Collection $dbDataSources) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$dbDataSources, (String)"$dbDataSources");
        $application.runReadAction(() -> DataSourceSettingsHelperKt.focusOnDataSources$lambda$4$lambda$3($project, $dbDataSources));
    }

    public static final /* synthetic */ void access$finishTestDataSource(LocalDataSource dataSource2, DatabaseCredentials storage) {
        DataSourceSettingsHelperKt.finishTestDataSource(dataSource2, storage);
    }
}

