/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.godot.lang.service;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspCommunicationChannel;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerManager;
import com.intellij.platform.lsp.api.LspServerSupportProvider;
import com.intellij.platform.lsp.api.ProjectWideLspServerDescriptor;
import com.intellij.platform.lsp.api.customization.FindReferencesSupport;
import com.intellij.platform.lsp.api.customization.LspCompletionSupport;
import com.intellij.platform.lsp.api.lsWidget.LspServerWidgetItem;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.model.godot.frontendBackend.GodotDescriptor;
import com.jetbrains.rider.model.godot.frontendBackend.LanguageServerConnectionMode;
import com.jetbrains.rider.plugins.godot.GodotIcons;
import com.jetbrains.rider.plugins.godot.GodotProjectDiscoverer;
import com.jetbrains.rider.plugins.godot.GodotProjectLifetimeService;
import com.jetbrains.rider.plugins.godot.Util;
import com.jetbrains.rider.plugins.godot.lang.service.GodotLspProjectService;
import com.jetbrains.rider.plugins.godot.lang.service.GodotLspServerWidgetItem;
import com.jetbrains.rider.plugins.godot.settings.GodotPluginOptionsPage;
import com.jetbrains.rider.util.NetUtils;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.CompletionItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/plugins/godot/lang/service/GodotLspServerSupportProvider;", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider;", "()V", "allReady", "", "discoverer", "Lcom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer;", "createLspServerWidgetItem", "Lcom/intellij/platform/lsp/api/lsWidget/LspServerWidgetItem;", "lspServer", "Lcom/intellij/platform/lsp/api/LspServer;", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileOpened", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "serverStarter", "Lcom/intellij/platform/lsp/api/LspServerSupportProvider$LspServerStarter;", "scheduleStartIfNeeded", "GodotLspServerDescriptor", "intellij.rider.plugins.godot"})
@SourceDebugExtension(value={"SMAP\nGodotLspServerSupportProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GodotLspServerSupportProvider.kt\ncom/jetbrains/rider/plugins/godot/lang/service/GodotLspServerSupportProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,151:1\n23#2:152\n*S KotlinDebug\n*F\n+ 1 GodotLspServerSupportProvider.kt\ncom/jetbrains/rider/plugins/godot/lang/service/GodotLspServerSupportProvider\n*L\n87#1:152\n*E\n"})
public final class GodotLspServerSupportProvider
implements LspServerSupportProvider {
    @NotNull
    public LspServerWidgetItem createLspServerWidgetItem(@NotNull LspServer lspServer, @Nullable VirtualFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        return new GodotLspServerWidgetItem(lspServer, currentFile, GodotIcons.Icons.Companion.getGodotLogo(), GodotPluginOptionsPage.class);
    }

    public void fileOpened(@NotNull Project project, @NotNull VirtualFile file, @NotNull LspServerSupportProvider.LspServerStarter serverStarter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)serverStarter, (String)"serverStarter");
        if (Util.Companion.isGdFile(file)) {
            GodotProjectDiscoverer discoverer = GodotProjectDiscoverer.Companion.getInstance(project);
            GodotLspProjectService lspService = GodotLspProjectService.Companion.getInstance(project);
            if (lspService.isScheduled().compareAndSet(false, true)) {
                Lifetime lifetime = GodotProjectLifetimeService.Companion.getLifetime(project);
                SourceExKt.adviseNotNull((ISource)((ISource)discoverer.getLspConnectionMode()), (Lifetime)lifetime, (Function1)((Function1)new Function1<LanguageServerConnectionMode, Unit>(project, this){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ GodotLspServerSupportProvider this$0;
                    {
                        this.$project = $project;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull LanguageServerConnectionMode lspConnectionMode2) {
                        Intrinsics.checkNotNullParameter((Object)((Object)lspConnectionMode2), (String)"lspConnectionMode");
                        if (lspConnectionMode2 == LanguageServerConnectionMode.Never) {
                            LspServerManager.Companion.getInstance(this.$project).stopServers(this.this$0.getClass());
                        } else {
                            GodotLspServerSupportProvider.access$scheduleStartIfNeeded(this.this$0, this.$project);
                        }
                    }
                }));
                SourceExKt.adviseNotNull((ISource)((ISource)discoverer.getUseDynamicPort()), (Lifetime)lifetime, (Function1)((Function1)new Function1<Boolean, Unit>(this, project){
                    final /* synthetic */ GodotLspServerSupportProvider this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(boolean it) {
                        GodotLspServerSupportProvider.access$scheduleStartIfNeeded(this.this$0, this.$project);
                    }
                }));
                SourceExKt.adviseNotNull((ISource)((ISource)discoverer.getGodotDescriptor()), (Lifetime)lifetime, (Function1)((Function1)new Function1<GodotDescriptor, Unit>(this, project){
                    final /* synthetic */ GodotLspServerSupportProvider this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(@NotNull GodotDescriptor it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        GodotLspServerSupportProvider.access$scheduleStartIfNeeded(this.this$0, this.$project);
                    }
                }));
                SourceExKt.adviseNotNull((ISource)((ISource)discoverer.getGodotPath()), (Lifetime)lifetime, (Function1)((Function1)new Function1<String, Unit>(this, project){
                    final /* synthetic */ GodotLspServerSupportProvider this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        GodotLspServerSupportProvider.access$scheduleStartIfNeeded(this.this$0, this.$project);
                    }
                }));
            }
            if (this.allReady(discoverer)) {
                GodotLspServerSupportProvider $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(GodotLspServerSupportProvider.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("ensureServerStarted");
                serverStarter.ensureServerStarted((LspServerDescriptor)new GodotLspServerDescriptor(project));
            }
        }
    }

    private final boolean allReady(GodotProjectDiscoverer discoverer) {
        return discoverer.getLspConnectionMode().getValue() != LanguageServerConnectionMode.Never && discoverer.getGodotPath().getValue() != null && discoverer.getRemoteHostPort().getValue() != null && discoverer.getGodotDescriptor().getValue() != null;
    }

    private final void scheduleStartIfNeeded(Project project) {
        GodotLspProjectService godotLspProjectService = GodotLspProjectService.Companion.getInstance(project);
        GodotProjectDiscoverer discoverer = GodotProjectDiscoverer.Companion.getInstance(project);
        if (!this.allReady(discoverer)) {
            return;
        }
        godotLspProjectService.queueRestart();
    }

    public static final /* synthetic */ void access$scheduleStartIfNeeded(GodotLspServerSupportProvider $this, Project project) {
        $this.scheduleStartIfNeeded(project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020)H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u0004\u0018\u00010\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u001b\u001a\u0004\u0018\u00010\u001c8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0016\u001a\u0004\b\u001d\u0010\u001eR\u001b\u0010 \u001a\u00020!8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u0016\u001a\u0004\b\"\u0010#\u00a8\u0006*"}, d2={"Lcom/jetbrains/rider/plugins/godot/lang/service/GodotLspServerSupportProvider$GodotLspServerDescriptor;", "Lcom/intellij/platform/lsp/api/ProjectWideLspServerDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "discoverer", "Lcom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer;", "getDiscoverer", "()Lcom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer;", "lspCommunicationChannel", "Lcom/intellij/platform/lsp/api/LspCommunicationChannel;", "getLspCommunicationChannel", "()Lcom/intellij/platform/lsp/api/LspCommunicationChannel;", "lspCompletionSupport", "Lcom/intellij/platform/lsp/api/customization/LspCompletionSupport;", "getLspCompletionSupport", "()Lcom/intellij/platform/lsp/api/customization/LspCompletionSupport;", "lspConnectionMode", "Lcom/jetbrains/rider/model/godot/frontendBackend/LanguageServerConnectionMode;", "getLspConnectionMode", "()Lcom/jetbrains/rider/model/godot/frontendBackend/LanguageServerConnectionMode;", "lspConnectionMode$delegate", "Lkotlin/Lazy;", "lspFindReferencesSupport", "Lcom/intellij/platform/lsp/api/customization/FindReferencesSupport;", "getLspFindReferencesSupport", "()Lcom/intellij/platform/lsp/api/customization/FindReferencesSupport;", "remoteHostPort", "", "getRemoteHostPort", "()Ljava/lang/Integer;", "remoteHostPort$delegate", "useDynamicPort", "", "getUseDynamicPort", "()Z", "useDynamicPort$delegate", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "isSupportedFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.rider.plugins.godot"})
    @SourceDebugExtension(value={"SMAP\nGodotLspServerSupportProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GodotLspServerSupportProvider.kt\ncom/jetbrains/rider/plugins/godot/lang/service/GodotLspServerSupportProvider$GodotLspServerDescriptor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,151:1\n23#2:152\n23#2:153\n12474#3,2:154\n*S KotlinDebug\n*F\n+ 1 GodotLspServerSupportProvider.kt\ncom/jetbrains/rider/plugins/godot/lang/service/GodotLspServerSupportProvider$GodotLspServerDescriptor\n*L\n123#1:152\n130#1:153\n145#1:154,2\n*E\n"})
    private static final class GodotLspServerDescriptor
    extends ProjectWideLspServerDescriptor {
        @NotNull
        private final GodotProjectDiscoverer discoverer;
        @NotNull
        private final Lazy lspConnectionMode$delegate;
        @NotNull
        private final Lazy remoteHostPort$delegate;
        @NotNull
        private final Lazy useDynamicPort$delegate;

        public GodotLspServerDescriptor(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project, "Godot");
            this.discoverer = GodotProjectDiscoverer.Companion.getInstance(project);
            this.lspConnectionMode$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LanguageServerConnectionMode>(this){
                final /* synthetic */ GodotLspServerDescriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final LanguageServerConnectionMode invoke() {
                    return (LanguageServerConnectionMode)((Object)this.this$0.getDiscoverer().getLspConnectionMode().getValue());
                }
            }));
            this.remoteHostPort$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
                final /* synthetic */ GodotLspServerDescriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Integer invoke() {
                    return this.this$0.getUseDynamicPort() ? Integer.valueOf(NetUtils.INSTANCE.findFreePort(500050, SetsKt.emptySet())) : (Integer)this.this$0.getDiscoverer().getRemoteHostPort().getValue();
                }
            }));
            this.useDynamicPort$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
                final /* synthetic */ GodotLspServerDescriptor this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    Object object = this.this$0.getDiscoverer().getUseDynamicPort().getValue();
                    Intrinsics.checkNotNull((Object)object);
                    return (Boolean)object != false && this.this$0.getDiscoverer().getLspConnectionMode().getValue() == LanguageServerConnectionMode.StartEditorHeadless;
                }
            }));
        }

        @NotNull
        public final GodotProjectDiscoverer getDiscoverer() {
            return this.discoverer;
        }

        @Nullable
        public final LanguageServerConnectionMode getLspConnectionMode() {
            Lazy lazy = this.lspConnectionMode$delegate;
            return (LanguageServerConnectionMode)((Object)lazy.getValue());
        }

        @Nullable
        public final Integer getRemoteHostPort() {
            Lazy lazy = this.remoteHostPort$delegate;
            return (Integer)lazy.getValue();
        }

        public final boolean getUseDynamicPort() {
            Lazy lazy = this.useDynamicPort$delegate;
            return (Boolean)lazy.getValue();
        }

        public boolean isSupportedFile(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return Util.Companion.isGdFile(file);
        }

        @NotNull
        public GeneralCommandLine createCommandLine() {
            GodotDescriptor godotDescriptor = (GodotDescriptor)this.discoverer.getGodotDescriptor().getValue();
            String basePath = godotDescriptor != null ? godotDescriptor.getMainProjectBasePath() : null;
            String godotPath = (String)this.discoverer.getGodotPath().getValue();
            String headlessArg = this.discoverer.getGodot4Path().getValue() != null ? "--headless" : "--no-window";
            String[] stringArray = new String[]{godotPath, "--path", String.valueOf(basePath), "--editor", headlessArg, "--lsp-port", String.valueOf(this.getRemoteHostPort())};
            GeneralCommandLine commandLine = new GeneralCommandLine(stringArray);
            GodotLspServerDescriptor $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GodotLspServerDescriptor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("createCommandLine commandLine=" + commandLine);
            return commandLine;
        }

        @NotNull
        public LspCommunicationChannel getLspCommunicationChannel() {
            GodotLspServerDescriptor $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GodotLspServerDescriptor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("lspCommunicationChannel port=" + this.getRemoteHostPort() + ", mode=" + this.getLspConnectionMode());
            Integer n = this.getRemoteHostPort();
            Intrinsics.checkNotNull((Object)n);
            return (LspCommunicationChannel)new LspCommunicationChannel.Socket(n.intValue(), this.getLspConnectionMode() == LanguageServerConnectionMode.StartEditorHeadless);
        }

        @NotNull
        public LspCompletionSupport getLspCompletionSupport() {
            return new LspCompletionSupport(){

                @Nullable
                public LookupElement createLookupElement(@NotNull CompletionParameters parameters, @NotNull CompletionItem item) {
                    Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                    Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                    LookupElement lookupElement = super.createLookupElement(parameters, item);
                    if (lookupElement == null) {
                        return null;
                    }
                    LookupElement item1 = lookupElement;
                    return PrioritizedLookupElement.withPriority((LookupElement)item1, (double)1.0);
                }
            };
        }

        @Nullable
        public FindReferencesSupport getLspFindReferencesSupport() {
            boolean bl;
            block2: {
                IdeaPluginDescriptor[] $this$any$iv = PluginManagerCore.getPlugins();
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    IdeaPluginDescriptor element$iv;
                    IdeaPluginDescriptor it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getPluginId().getIdString(), (Object)"ice.explosive.gdscript") && it.isEnabled())) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (bl) {
                return null;
            }
            return super.getLspFindReferencesSupport();
        }
    }
}

