/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.godot;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rider.model.godot.frontendBackend.GodotDescriptor;
import com.jetbrains.rider.model.godot.frontendBackend.GodotFrontendBackendModel;
import com.jetbrains.rider.model.godot.frontendBackend.LanguageServerConnectionMode;
import com.jetbrains.rider.plugins.godot.GodotProjectLifetimeService;
import com.jetbrains.rider.plugins.godot.MetadataCoreFileWatcher;
import com.jetbrains.rider.plugins.godot.MetadataMonoFileWatcher;
import com.jetbrains.rider.plugins.godot.run.configurations.GodotDebugRunConfiguration;
import com.jetbrains.rider.plugins.godot.run.configurations.GodotDebugRunConfigurationType;
import com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfiguration;
import com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfigurationType;
import java.io.File;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0019\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0019\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0019\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\tR\u0014\u0010\u0017\u001a\u00020\u0018X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0019\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\tR\u0019\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\t\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "godot3Path", "Lcom/jetbrains/rd/util/reactive/IProperty;", "", "getGodot3Path", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "godot4Path", "getGodot4Path", "godotDescriptor", "Lcom/jetbrains/rider/model/godot/frontendBackend/GodotDescriptor;", "getGodotDescriptor", "godotPath", "getGodotPath", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "lspConnectionMode", "Lcom/jetbrains/rider/model/godot/frontendBackend/LanguageServerConnectionMode;", "getLspConnectionMode", "port", "", "getPort", "()I", "remoteHostPort", "getRemoteHostPort", "useDynamicPort", "", "getUseDynamicPort", "getGodotPathFromCorePlayerRunConfiguration", "getGodotPathFromPlayerRunConfiguration", "Companion", "ProtocolListener", "intellij.rider.plugins.godot"})
@SourceDebugExtension(value={"SMAP\nGodotProjectDiscoverer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GodotProjectDiscoverer.kt\ncom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n288#2,2:111\n288#2,2:113\n*S KotlinDebug\n*F\n+ 1 GodotProjectDiscoverer.kt\ncom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer\n*L\n67#1:111,2\n80#1:113,2\n*E\n"})
public final class GodotProjectDiscoverer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IProperty<GodotDescriptor> godotDescriptor;
    @NotNull
    private final IProperty<LanguageServerConnectionMode> lspConnectionMode;
    @NotNull
    private final IProperty<Integer> remoteHostPort;
    @NotNull
    private final IProperty<Boolean> useDynamicPort;
    @NotNull
    private final Logger logger;
    @NotNull
    private final IProperty<String> godot3Path;
    @NotNull
    private final IProperty<String> godot4Path;
    @NotNull
    private final IProperty<String> godotPath;
    private final int port;

    public GodotProjectDiscoverer(final @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.godotDescriptor = (IProperty)new Property(null);
        this.lspConnectionMode = (IProperty)new Property(null);
        this.remoteHostPort = (IProperty)new Property(null);
        this.useDynamicPort = (IProperty)new Property(null);
        Logger logger = Logger.getInstance(GodotProjectDiscoverer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.godot3Path = (IProperty)new Property(null);
        this.godot4Path = (IProperty)new Property(null);
        this.godotPath = (IProperty)new Property(null);
        final Lifetime lifetime = GodotProjectLifetimeService.Companion.getLifetime(project);
        SourceExKt.adviseNotNull((ISource)((ISource)this.godot3Path), (Lifetime)lifetime, (Function1)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.getGodotPath().set((Object)it);
            }
        }));
        SourceExKt.adviseNotNull((ISource)((ISource)this.godot4Path), (Lifetime)lifetime, (Function1)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.getGodotPath().set((Object)it);
            }
        }));
        SourceExKt.adviseNotNull((ISource)((ISource)this.godotDescriptor), (Lifetime)lifetime, (Function1)((Function1)new Function1<GodotDescriptor, Unit>(){

            public final void invoke(@NotNull GodotDescriptor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                logger.info("Godot godotDescriptor: " + it);
                File basePath = new File(it.getMainProjectBasePath());
                LifetimeCoroutineUtilKt.launch$default((Lifetime)lifetime, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(basePath, this, project, null){
                    int label;
                    final /* synthetic */ File $basePath;
                    final /* synthetic */ GodotProjectDiscoverer this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.$basePath = $basePath;
                        this.this$0 = $receiver;
                        this.$project = $project;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                String string;
                                String g3path;
                                ResultKt.throwOnFailure((Object)object);
                                String string2 = MetadataMonoFileWatcher.Util.INSTANCE.getFromMonoMetadataPath(this.$basePath);
                                if (string2 == null && (string2 = MetadataMonoFileWatcher.Util.INSTANCE.getGodotPath(this.$basePath)) == null) {
                                    string2 = g3path = this.this$0.getGodotPathFromPlayerRunConfiguration(this.$project);
                                }
                                if ((string = MetadataCoreFileWatcher.Util.INSTANCE.getGodotPath(this.$basePath)) == null) {
                                    string = this.this$0.getGodotPathFromCorePlayerRunConfiguration(this.$project);
                                }
                                String g4path = string;
                                this.label = 1;
                                Object object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, g3path, g4path, null){
                                    int label;
                                    final /* synthetic */ GodotProjectDiscoverer this$0;
                                    final /* synthetic */ String $g3path;
                                    final /* synthetic */ String $g4path;
                                    {
                                        this.this$0 = $receiver;
                                        this.$g3path = $g3path;
                                        this.$g4path = $g4path;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.this$0.getGodot3Path().set((Object)this.$g3path);
                                                this.this$0.getGodot4Path().set((Object)this.$g4path);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        }));
        this.port = 23685;
    }

    @NotNull
    public final IProperty<GodotDescriptor> getGodotDescriptor() {
        return this.godotDescriptor;
    }

    @NotNull
    public final IProperty<LanguageServerConnectionMode> getLspConnectionMode() {
        return this.lspConnectionMode;
    }

    @NotNull
    public final IProperty<Integer> getRemoteHostPort() {
        return this.remoteHostPort;
    }

    @NotNull
    public final IProperty<Boolean> getUseDynamicPort() {
        return this.useDynamicPort;
    }

    @NotNull
    public final IProperty<String> getGodot3Path() {
        return this.godot3Path;
    }

    @NotNull
    public final IProperty<String> getGodot4Path() {
        return this.godot4Path;
    }

    @NotNull
    public final IProperty<String> getGodotPath() {
        return this.godotPath;
    }

    private final String getGodotPathFromCorePlayerRunConfiguration(Project project) {
        Object v0;
        block3: {
            RunManager runManager = RunManager.Companion.getInstance(project);
            Iterable $this$firstOrNull$iv = runManager.getAllSettings();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                boolean bl = false;
                if (!(it.getType() instanceof DotNetExeConfigurationType && Intrinsics.areEqual((Object)it.getName(), (Object)"Player"))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        RunnerAndConfigurationSettings playerSettings = v0;
        if (playerSettings != null) {
            RunConfiguration runConfiguration = playerSettings.getConfiguration();
            Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfiguration");
            DotNetExeConfiguration config = (DotNetExeConfiguration)runConfiguration;
            String path = config.getParameters().getExePath();
            if (((CharSequence)path).length() > 0 && new File(path).exists()) {
                return path;
            }
        }
        return null;
    }

    private final String getGodotPathFromPlayerRunConfiguration(Project project) {
        Object v0;
        block3: {
            RunManager runManager = RunManager.Companion.getInstance(project);
            Iterable $this$firstOrNull$iv = runManager.getAllSettings();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
                boolean bl = false;
                if (!(it.getType() instanceof GodotDebugRunConfigurationType && Intrinsics.areEqual((Object)it.getName(), (Object)"Player"))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        RunnerAndConfigurationSettings playerSettings = v0;
        if (playerSettings != null) {
            RunConfiguration runConfiguration = playerSettings.getConfiguration();
            Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.rider.plugins.godot.run.configurations.GodotDebugRunConfiguration");
            GodotDebugRunConfiguration config = (GodotDebugRunConfiguration)runConfiguration;
            String path = config.getParameters().getExePath();
            if (((CharSequence)path).length() > 0 && new File(path).exists()) {
                return path;
            }
        }
        return null;
    }

    public final int getPort() {
        return this.port;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.godot"})
    @SourceDebugExtension(value={"SMAP\nGodotProjectDiscoverer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GodotProjectDiscoverer.kt\ncom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer$Companion\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,110:1\n17#2,2:111\n*S KotlinDebug\n*F\n+ 1 GodotProjectDiscoverer.kt\ncom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer$Companion\n*L\n94#1:111,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GodotProjectDiscoverer getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$getService$iv = (ComponentManager)project;
            boolean $i$f$getService = false;
            Object object = $this$getService$iv.getService(GodotProjectDiscoverer.class);
            if (object == null) {
                throw new IllegalStateException("Service " + GodotProjectDiscoverer.class + " not found in container " + $this$getService$iv);
            }
            return (GodotProjectDiscoverer)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/plugins/godot/GodotProjectDiscoverer$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/model/godot/frontendBackend/GodotFrontendBackendModel;", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider.plugins.godot"})
    public static final class ProtocolListener
    implements SolutionExtListener<GodotFrontendBackendModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull GodotFrontendBackendModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
            SourceExKt.adviseNotNull((ISource)((ISource)model.getGodotDescriptor()), (Lifetime)lifetime, (Function1)((Function1)new Function1<GodotDescriptor, Unit>(session){
                final /* synthetic */ ClientProjectSession $session;
                {
                    this.$session = $session;
                    super(1);
                }

                public final void invoke(@NotNull GodotDescriptor it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    GodotProjectDiscoverer.Companion.getInstance(this.$session.getProject()).getGodotDescriptor().set((Object)it);
                }
            }));
            SourceExKt.adviseNotNull((ISource)((ISource)model.getBackendSettings().getLspConnectionMode()), (Lifetime)lifetime, (Function1)((Function1)new Function1<LanguageServerConnectionMode, Unit>(session){
                final /* synthetic */ ClientProjectSession $session;
                {
                    this.$session = $session;
                    super(1);
                }

                public final void invoke(@NotNull LanguageServerConnectionMode it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    GodotProjectDiscoverer.Companion.getInstance(this.$session.getProject()).getLspConnectionMode().set((Object)((Object)it));
                }
            }));
            SourceExKt.adviseNotNull((ISource)((ISource)model.getBackendSettings().getRemoteHostPort()), (Lifetime)lifetime, (Function1)((Function1)new Function1<Integer, Unit>(session){
                final /* synthetic */ ClientProjectSession $session;
                {
                    this.$session = $session;
                    super(1);
                }

                public final void invoke(int it) {
                    GodotProjectDiscoverer.Companion.getInstance(this.$session.getProject()).getRemoteHostPort().set((Object)it);
                }
            }));
            SourceExKt.adviseNotNull((ISource)((ISource)model.getBackendSettings().getUseDynamicPort()), (Lifetime)lifetime, (Function1)((Function1)new Function1<Boolean, Unit>(session){
                final /* synthetic */ ClientProjectSession $session;
                {
                    this.$session = $session;
                    super(1);
                }

                public final void invoke(boolean it) {
                    GodotProjectDiscoverer.Companion.getInstance(this.$session.getProject()).getUseDynamicPort().set((Object)it);
                }
            }));
        }
    }
}

