/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssNamedElement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.impl.CssNamedItemPresentation;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSFileType;
import org.jetbrains.plugins.sass.extensions.SassExtensionFunctionInfo;
import org.jetbrains.plugins.sass.extensions.SassRubyIntegrationHelper;
import org.jetbrains.plugins.scss.SCSSFileType;
import org.jetbrains.plugins.scss.index.SassScssDependencyManager;
import org.jetbrains.plugins.scss.psi.SCSSEachStatementImpl;
import org.jetbrains.plugins.scss.psi.SCSSForStatementImpl;
import org.jetbrains.plugins.scss.psi.SCSSIfStatementImpl;
import org.jetbrains.plugins.scss.psi.SCSSWhileStatementImpl;
import org.jetbrains.plugins.scss.psi.SassScssForwardAtRule;
import org.jetbrains.plugins.scss.psi.SassScssFunctionDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssFunctionDeclarationImpl;
import org.jetbrains.plugins.scss.psi.SassScssInclude;
import org.jetbrains.plugins.scss.psi.SassScssMixinDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssPlaceholderSelector;
import org.jetbrains.plugins.scss.psi.SassScssPropertyRuleset;
import org.jetbrains.plugins.scss.psi.SassScssStylesheetFile;
import org.jetbrains.plugins.scss.psi.SassScssUseAtRule;
import org.jetbrains.plugins.scss.psi.SassScssVariableDeclaration;

public final class SASSSCSSLangUtil {
    public static final int IMPORTED_ELEMENT_PRIORITY = 30;
    private static final int KEYWORD_ELEMENT_PRIORITY = 70;
    private static final String NMSTART = "(([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))";
    private static final String NMCHAR = "((([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))|([0-9_-]))";
    private static final String IDENT = "[_-]?(([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))((([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))|([0-9_-]))*";
    private static final Pattern IDENT_PATTERN = Pattern.compile("[_-]?(([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))((([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))|([0-9_-]))*");
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$?[_-]?(([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))((([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))|([0-9_-]))*");
    public static final Class[] ELEMENT_SCOPES = new Class[]{PsiFile.class, CssRuleset.class, CssAtRule.class, SassScssMixinDeclaration.class, SCSSForStatementImpl.class, SCSSEachStatementImpl.class, SCSSWhileStatementImpl.class, SCSSIfStatementImpl.class, SassScssInclude.class, SassScssFunctionDeclarationImpl.class};

    public static boolean isValidScope(PsiElement element) {
        for (Class scope : ELEMENT_SCOPES) {
            if (!scope.isInstance(element)) continue;
            return true;
        }
        return false;
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static String normalizeName(@Nullable String name) {
        if (name == null || !StringUtil.containsChar((String)name, (char)'-')) {
            return name;
        }
        return StringUtil.notNullize((String)name).replace('-', '_');
    }

    public static boolean isValidVariableName(@NotNull String name) {
        if (name == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(0);
        }
        return VARIABLE_PATTERN.matcher(name).matches();
    }

    public static boolean isValidMixinName(@NotNull String name) {
        if (name == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(1);
        }
        return IDENT_PATTERN.matcher(name).matches();
    }

    public static boolean isValidFunctionName(@NotNull String name) {
        if (name == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(2);
        }
        return IDENT_PATTERN.matcher(name).matches();
    }

    public static boolean isValidSelectorName(@NotNull String name) {
        if (name == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(3);
        }
        return IDENT_PATTERN.matcher(name).matches();
    }

    public static String restoreFullPropertyName(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(4);
        }
        StringBuilder result = new StringBuilder(propertyName);
        CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)context, CssDeclaration.class, (boolean)false);
        context = declaration != null ? declaration.getParent() : context;
        SassScssPropertyRuleset propertyRuleset = (SassScssPropertyRuleset)PsiTreeUtil.getParentOfType((PsiElement)context, SassScssPropertyRuleset.class);
        while (propertyRuleset != null) {
            String namespace = propertyRuleset.getNamespace();
            if (!namespace.isEmpty()) {
                result.insert(0, '-');
                result.insert(0, namespace);
            }
            propertyRuleset = (SassScssPropertyRuleset)PsiTreeUtil.getParentOfType((PsiElement)propertyRuleset, SassScssPropertyRuleset.class);
        }
        return result.toString();
    }

    public static boolean isVisibleDeclaration(@NotNull PsiElement declaration, @NotNull PsiElement referenceElement) {
        CssRuleset rulesetParent;
        if (declaration == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(5);
        }
        if (referenceElement == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(6);
        }
        if (declaration.getContainingFile().getOriginalFile() != referenceElement.getContainingFile().getOriginalFile()) {
            return SASSSCSSLangUtil.getOriginalScope(declaration) instanceof PsiFile;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)referenceElement, CssSelectorList.class, (boolean)false) != null && (rulesetParent = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, CssRuleset.class)) != null) {
            referenceElement = rulesetParent;
        }
        if ((declaration instanceof CssImport || declaration instanceof SassScssVariableDeclaration && !((SassScssVariableDeclaration)declaration).isGlobal()) && declaration.getTextOffset() > referenceElement.getTextOffset()) {
            return false;
        }
        PsiElement declarationScope = SASSSCSSLangUtil.getOriginalScope(declaration);
        PsiElement originalScope = SASSSCSSLangUtil.getOriginalScope(referenceElement);
        return declarationScope instanceof PsiFile || originalScope != null && PsiTreeUtil.isAncestor((PsiElement)declarationScope, (PsiElement)originalScope, (boolean)false);
    }

    @Nullable
    public static PsiElement getOriginalScope(PsiElement reference) {
        PsiElement myElementScope = PsiTreeUtil.getParentOfType((PsiElement)reference, (Class[])ELEMENT_SCOPES);
        if (myElementScope instanceof SassScssInclude && myElementScope.getParent() instanceof CssRuleset) {
            myElementScope = myElementScope.getParent();
        }
        PsiElement originalScope = myElementScope != null ? CompletionUtil.getOriginalElement((PsiElement)myElementScope) : null;
        return originalScope == null && myElementScope != null ? SASSSCSSLangUtil.getOriginalScope(myElementScope) : originalScope;
    }

    @Nullable
    public static ResolveResult filterOverriddenResults(Collection<? extends ResolveResult> result, PsiElement reference) {
        ResolveResult singleResult = null;
        PsiFile originalFile = reference.getContainingFile();
        for (ResolveResult resolveResult : result) {
            PsiElement resolvedElement = resolveResult.getElement();
            if (resolvedElement == null || originalFile != resolvedElement.getContainingFile()) continue;
            if (singleResult == null) {
                singleResult = resolveResult;
                continue;
            }
            PsiElement singleResultElement = singleResult.getElement();
            if (singleResultElement == null || resolvedElement.getTextOffset() <= singleResultElement.getTextOffset()) continue;
            singleResult = resolveResult;
        }
        return singleResult;
    }

    public static LookupElement createKeywordLookupItem(String keyword) {
        return SASSSCSSLangUtil.createKeywordLookupItem(keyword, null);
    }

    public static LookupElement createKeywordLookupItem(String keyword, @Nullable InsertHandler<LookupElement> insertHandler) {
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)keyword).bold().withInsertHandler(insertHandler), (double)70.0);
    }

    @NotNull
    public static LookupElement createMixinLookupItem(@Nullable String prefixFromForwardAtRule, @NotNull SassScssMixinDeclaration declaration, @Nullable String qualifier, boolean validResult, @NotNull String completionResultPrefix) {
        if (declaration == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(7);
        }
        if (completionResultPrefix == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(8);
        }
        ItemPresentation itemPresentation = declaration.getPresentation();
        Object tailText = validResult ? declaration.getParametersString() : declaration.getParametersString() + " implicitly imported";
        String declarationName = SASSSCSSLangUtil.normalizedDeclarationName(StringUtil.notNullize((String)prefixFromForwardAtRule) + declaration.getName(), completionResultPrefix);
        String lookupString = qualifier != null ? qualifier + "." + declarationName : declarationName;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.createWithSmartPointer((String)lookupString, (PsiElement)declaration).withIcon(itemPresentation.getIcon(false)).withBoldness(validResult).withTailText((String)tailText, true).withInsertHandler((InsertHandler)(declaration.hasParameters() ? ParenthesesInsertHandler.WITH_PARAMETERS : null)).withTypeText(itemPresentation.getLocationString(), true), (double)(validResult ? 30.0 : 0.0));
        if (lookupElement == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(9);
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement createVariableLookupItem(@Nullable String prefixFromForwardAtRule, @NotNull SassScssVariableDeclaration declaration, @Nullable String qualifier, boolean validResult, @NotNull String completionResultPrefix, boolean lookupStringWithDollar) {
        LookupElementBuilder lookupElementBuilder;
        if (declaration == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(10);
        }
        if (completionResultPrefix == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(11);
        }
        ItemPresentation itemPresentation = declaration.getPresentation();
        String tailText = validResult ? "" : " implicitly imported";
        String declarationName = SASSSCSSLangUtil.normalizedDeclarationName(StringUtil.notNullize((String)prefixFromForwardAtRule) + declaration.getName(), completionResultPrefix);
        if (qualifier != null) {
            String lookupString = qualifier + ".$" + declarationName;
            lookupElementBuilder = LookupElementBuilder.createWithSmartPointer((String)lookupString, (PsiElement)declaration).withInsertHandler((context, item) -> {
                char ch = context.getDocument().getCharsSequence().charAt(context.getStartOffset() - 1);
                if (ch == '$') {
                    context.getDocument().deleteString(context.getStartOffset() - 1, context.getStartOffset());
                }
            });
        } else {
            Object lookupString = lookupStringWithDollar ? "$" + declarationName : declarationName;
            lookupElementBuilder = LookupElementBuilder.createWithSmartPointer((String)lookupString, (PsiElement)declaration);
        }
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)lookupElementBuilder.withIcon(itemPresentation.getIcon(false)).withBoldness(validResult).withTailText(tailText, true).withTypeText(itemPresentation.getLocationString(), true), (double)(validResult ? 30.0 : 0.0));
        if (lookupElement == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(12);
        }
        return lookupElement;
    }

    public static LookupElement createFunctionLookupItem(@Nullable String prefixFromForwardAtRule, @NotNull SassScssFunctionDeclaration declaration, @Nullable String qualifier, boolean validResult, @Nullable String completionResultPrefix) {
        if (declaration == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(13);
        }
        ItemPresentation itemPresentation = declaration.getPresentation();
        String argumentsString = declaration.getParametersString();
        Object tailText = validResult ? argumentsString : argumentsString + " implicitly imported";
        String declarationName = SASSSCSSLangUtil.normalizedDeclarationName(StringUtil.notNullize((String)prefixFromForwardAtRule) + declaration.getName(), completionResultPrefix);
        String lookupString = qualifier != null ? qualifier + "." + declarationName : declarationName;
        boolean higherPriority = validResult && !"sass_functions.scss".equals(declaration.getContainingFile().getName());
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.createWithSmartPointer((String)lookupString, (PsiElement)declaration).withIcon(itemPresentation.getIcon(false)).withBoldness(higherPriority).withTailText((String)tailText, true).withInsertHandler((InsertHandler)(argumentsString.isEmpty() || "()".equals(argumentsString) ? ParenthesesInsertHandler.NO_PARAMETERS : ParenthesesInsertHandler.WITH_PARAMETERS)).withTypeText(itemPresentation.getLocationString(), true), (double)(higherPriority ? 30.0 : 0.0));
    }

    public static LookupElement createPlaceholderSelectorLookup(@NotNull SassScssPlaceholderSelector selector, @NotNull PsiElement navigationElement, boolean validResult) {
        if (selector == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(14);
        }
        if (navigationElement == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(15);
        }
        ItemPresentation itemPresentation = selector.getPresentation();
        if (selector != navigationElement) {
            itemPresentation = new CssNamedItemPresentation.WithCustomContext(itemPresentation, navigationElement);
        }
        String tailText = validResult ? "" : " implicitly imported";
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.createWithSmartPointer((String)selector.getName(), (PsiElement)navigationElement).withIcon(itemPresentation.getIcon(false)).withBoldness(validResult).withTailText(tailText, true).withTypeText(itemPresentation.getLocationString(), true), (double)(validResult ? 30.0 : 0.0));
    }

    public static LookupElement createCustomFunctionLookupItem(@NotNull SassExtensionFunctionInfo functionInfo, @Nullable String currentPrefix) {
        if (functionInfo == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(16);
        }
        String filePath = functionInfo.getFilePath();
        String fileName = PathUtil.getFileName((String)filePath);
        String argumentString = functionInfo.getArgumentsString();
        String declarationName = SASSSCSSLangUtil.normalizedDeclarationName(functionInfo.getName(), currentPrefix);
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)functionInfo, (String)declarationName).withIcon(AllIcons.Nodes.Lambda).withTailText("(" + argumentString + ")", true).withInsertHandler((InsertHandler)(argumentString.isEmpty() ? ParenthesesInsertHandler.NO_PARAMETERS : ParenthesesInsertHandler.WITH_PARAMETERS)).withTypeText(fileName.isEmpty() ? filePath : fileName, true), (double)30.0);
    }

    public static SearchScope restrictedBySassFilesScope(@NotNull SearchScope scope) {
        if (scope == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(17);
        }
        return scope instanceof GlobalSearchScope ? GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)scope), (FileType[])new FileType[]{SASSFileType.SASS, SCSSFileType.SCSS}) : scope;
    }

    public static GlobalSearchScope searchScopeWithSassStdlib(@NotNull PsiElement context) {
        if (context == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(18);
        }
        GlobalSearchScope baseScope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)context);
        if (SassRubyIntegrationHelper.getInstance().hasSassGem(ModuleUtilCore.findModuleForPsiElement((PsiElement)context))) {
            return baseScope;
        }
        VirtualFile virtualFile = SassScssDependencyManager.getInstance().getGlobalFunctionsFile();
        if (virtualFile == null) {
            return baseScope;
        }
        return baseScope.union((SearchScope)GlobalSearchScope.fileScope((Project)context.getProject(), (VirtualFile)virtualFile));
    }

    @NotNull
    public static String normalizedDeclarationName(@NotNull String declarationName, @Nullable String currentPrefix) {
        if (declarationName == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(19);
        }
        if (StringUtil.isNotEmpty((String)currentPrefix)) {
            String normalizedPrefix = SASSSCSSLangUtil.normalizeName(currentPrefix);
            String normalizedName = SASSSCSSLangUtil.normalizeName(declarationName);
            if (normalizedName.startsWith(normalizedPrefix)) {
                String string = currentPrefix + declarationName.substring(currentPrefix.length());
                if (string == null) {
                    SASSSCSSLangUtil.$$$reportNull$$$0(20);
                }
                return string;
            }
        }
        String string = declarationName;
        if (string == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    public static boolean nameEquals(@NotNull String first, @Nullable String second) {
        if (first == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(22);
        }
        if (second == null) {
            return false;
        }
        if (Strings.areSameInstance((String)first, (String)second)) {
            return true;
        }
        if (first.length() != second.length()) {
            return false;
        }
        for (int i = 0; i < first.length(); ++i) {
            char c2;
            char c1 = first.charAt(i);
            if (c1 == (c2 = second.charAt(i)) || c1 == '_' && c2 == '-' || c1 == '-' && c2 == '_') continue;
            return false;
        }
        return true;
    }

    public static <T extends CssNamedElement> ResolveResult @NotNull [] resolveQualifiedReference(@NotNull PsiReference qualifierRef, @NotNull String name, @NotNull Class<T> declarationClass) {
        if (qualifierRef == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(23);
        }
        if (name == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(24);
        }
        if (declarationClass == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(25);
        }
        if (name.startsWith("-") || name.startsWith("_")) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                SASSSCSSLangUtil.$$$reportNull$$$0(26);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        Map<PsiFile, String> usedFileToForwardingPrefix = SASSSCSSLangUtil.getUsedFileToForwardingPrefix(qualifierRef);
        if (usedFileToForwardingPrefix.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                SASSSCSSLangUtil.$$$reportNull$$$0(27);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        SmartList result = new SmartList();
        for (Map.Entry<PsiFile, String> entry : usedFileToForwardingPrefix.entrySet()) {
            String prefix;
            PsiFile file = entry.getKey();
            if (!(file instanceof SassScssStylesheetFile) || !name.startsWith(prefix = entry.getValue())) continue;
            String normalizedName = SASSSCSSLangUtil.normalizeName(name.substring(prefix.length()));
            for (CssNamedElement declaration : ((SassScssStylesheetFile)file).getTopLevelDeclarations(declarationClass)) {
                String declarationName = declaration.getName();
                if (declarationName == null || !normalizedName.equals(SASSSCSSLangUtil.normalizeName(declarationName)) || declarationName.startsWith("-") || declarationName.startsWith("_")) continue;
                result.add(new PsiElementResolveResult((PsiElement)declaration, true));
            }
        }
        ResolveResult[] resolveResultArray = result.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(28);
        }
        return resolveResultArray;
    }

    @NotNull
    private static @NotNull Map<@NotNull PsiFile, @NotNull String> getUsedFileToForwardingPrefix(@NotNull PsiReference qualifierRef) {
        PsiElement qualifierResolved;
        SassScssUseAtRule useAtRule;
        PsiFile[] targetFiles;
        if (qualifierRef == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(29);
        }
        PsiFile[] psiFileArray = targetFiles = (useAtRule = (SassScssUseAtRule)PsiTreeUtil.getParentOfType((PsiElement)(qualifierResolved = qualifierRef.resolve()), SassScssUseAtRule.class)) != null ? useAtRule.resolveTargetFiles() : PsiFile.EMPTY_ARRAY;
        if (targetFiles.length == 0) {
            Map<PsiFile, String> map = Collections.emptyMap();
            if (map == null) {
                SASSSCSSLangUtil.$$$reportNull$$$0(30);
            }
            return map;
        }
        HashMap<PsiFile, String> result = new HashMap<PsiFile, String>();
        HashSet<PsiFile> visited = new HashSet<PsiFile>();
        visited.add(qualifierRef.getElement().getContainingFile().getOriginalFile());
        for (PsiFile targetFile : targetFiles) {
            String filePrefix = "";
            result.put(targetFile, filePrefix);
            if (!(targetFile instanceof SassScssStylesheetFile)) continue;
            SASSSCSSLangUtil.processForwardsAndImports((SassScssStylesheetFile)targetFile, filePrefix, visited, (PairConsumer<SassScssStylesheetFile, String>)((PairConsumer)(file, prefix) -> result.put((PsiFile)file, (String)prefix)));
        }
        HashMap<PsiFile, String> hashMap = result;
        if (hashMap == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(31);
        }
        return hashMap;
    }

    public static void processForwardsAndImports(@NotNull SassScssStylesheetFile file, @NotNull String filePrefix, @NotNull Set<PsiFile> visited, @NotNull PairConsumer<SassScssStylesheetFile, String> fileAndPrefixProcessor) {
        if (file == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(32);
        }
        if (filePrefix == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(33);
        }
        if (visited == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(34);
        }
        if (fileAndPrefixProcessor == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(35);
        }
        if (!visited.add((PsiFile)file)) {
            return;
        }
        for (SassScssForwardAtRule forwardAtRule : SASSSCSSLangUtil.getForwardAtRules(file.getStylesheet())) {
            String forwardPrefix = forwardAtRule.getPrefix();
            PsiFile[] psiFileArray = forwardAtRule.resolveTargetFiles();
            int n = psiFileArray.length;
            for (int i = 0; i < n; ++i) {
                PsiFile targetFile = psiFileArray[i];
                if (!(targetFile instanceof SassScssStylesheetFile) || visited.contains(targetFile)) continue;
                String prefix = filePrefix + forwardPrefix;
                fileAndPrefixProcessor.consume((Object)((SassScssStylesheetFile)targetFile), (Object)prefix);
                SASSSCSSLangUtil.processForwardsAndImports((SassScssStylesheetFile)targetFile, prefix, visited, fileAndPrefixProcessor);
            }
        }
        for (CssImport cssImport : SASSSCSSLangUtil.getImportLikeAtRules(file.getStylesheet(), CssImport.class)) {
            for (PsiFile targetFile : cssImport.resolve()) {
                if (!(targetFile instanceof SassScssStylesheetFile) || visited.contains(targetFile)) continue;
                fileAndPrefixProcessor.consume((Object)((SassScssStylesheetFile)targetFile), (Object)filePrefix);
                SASSSCSSLangUtil.processForwardsAndImports((SassScssStylesheetFile)targetFile, filePrefix, visited, fileAndPrefixProcessor);
            }
        }
    }

    private static Collection<SassScssForwardAtRule> getForwardAtRules(CssStylesheet stylesheet) {
        return SASSSCSSLangUtil.getImportLikeAtRules(stylesheet, SassScssForwardAtRule.class);
    }

    @NotNull
    public static Collection<SassScssUseAtRule> getUseAtRules(@NotNull CssStylesheet stylesheet) {
        if (stylesheet == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(36);
        }
        return SASSSCSSLangUtil.getImportLikeAtRules(stylesheet, SassScssUseAtRule.class);
    }

    @NotNull
    private static <T extends PsiElement> Collection<T> getImportLikeAtRules(@NotNull CssStylesheet stylesheet, @NotNull Class<T> clazz) {
        if (stylesheet == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(37);
        }
        if (clazz == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(38);
        }
        List list = ContainerUtil.concat((List)PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)stylesheet.getImportList(), clazz), (List)PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)stylesheet.getRulesetList(), clazz));
        if (list == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(39);
        }
        return list;
    }

    public static Map<PsiFile, QualifierInfo> getFileToQualifierInfoMap(PsiElement context) {
        Map<PsiFile, String> fileToQualifierMap = SASSSCSSLangUtil.getFileToQualifierMap(context);
        if (fileToQualifierMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<PsiFile, QualifierInfo> result = new HashMap<PsiFile, QualifierInfo>();
        for (Map.Entry<PsiFile, String> entry : fileToQualifierMap.entrySet()) {
            result.put(entry.getKey(), new QualifierInfo(entry.getValue(), null));
        }
        HashSet<PsiFile> visited = new HashSet<PsiFile>();
        visited.add(context.getContainingFile().getOriginalFile());
        for (Map.Entry<PsiFile, String> entry : fileToQualifierMap.entrySet()) {
            PsiFile file = entry.getKey();
            String qualifier = entry.getValue();
            if (!(file instanceof SassScssStylesheetFile)) continue;
            SASSSCSSLangUtil.processForwardsAndImports((SassScssStylesheetFile)file, "", visited, (PairConsumer<SassScssStylesheetFile, String>)((PairConsumer)(forwardedFile, prefix) -> {
                if (!result.containsKey(forwardedFile)) {
                    result.put((PsiFile)forwardedFile, new QualifierInfo(qualifier, (String)prefix));
                }
            }));
        }
        return result;
    }

    private static Map<PsiFile, String> getFileToQualifierMap(PsiElement context) {
        Collection<Object> useAtRules;
        CssStylesheet stylesheet = (CssStylesheet)PsiTreeUtil.getParentOfType((PsiElement)context, CssStylesheet.class);
        Collection<Object> collection = useAtRules = stylesheet != null ? SASSSCSSLangUtil.getUseAtRules(stylesheet) : Collections.emptyList();
        if (useAtRules.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<PsiFile, String> result = new HashMap<PsiFile, String>();
        for (SassScssUseAtRule sassScssUseAtRule : useAtRules) {
            String qualifier = sassScssUseAtRule.getQualifier();
            if (qualifier == null) continue;
            for (PsiFile file : sassScssUseAtRule.resolveTargetFiles()) {
                result.put(file, qualifier);
            }
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 12, 20, 21, 26, 27, 28, 30, 31, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionResultPrefix";
                break;
            }
            case 9: 
            case 12: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/scss/SASSSCSSLangUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationElement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionInfo";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierRef";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationClass";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePrefix";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileAndPrefixProcessor";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stylesheet";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/scss/SASSSCSSLangUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createMixinLookupItem";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariableLookupItem";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizedDeclarationName";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveQualifiedReference";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedFileToForwardingPrefix";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportLikeAtRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isValidVariableName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isValidMixinName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidFunctionName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidSelectorName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "restoreFullPropertyName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isVisibleDeclaration";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createMixinLookupItem";
                break;
            }
            case 9: 
            case 12: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 39: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createVariableLookupItem";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionLookupItem";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createPlaceholderSelectorLookup";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createCustomFunctionLookupItem";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "restrictedBySassFilesScope";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "searchScopeWithSassStdlib";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "normalizedDeclarationName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "nameEquals";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveQualifiedReference";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getUsedFileToForwardingPrefix";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "processForwardsAndImports";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getUseAtRules";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getImportLikeAtRules";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 12, 20, 21, 26, 27, 28, 30, 31, 39 -> new IllegalStateException(string);
        };
    }

    public static class QualifierInfo {
        @NotNull
        public final String qualifier;
        @Nullable
        public final String prefixFromForwards;

        public QualifierInfo(@NotNull String qualifier, @Nullable String prefixFromForwards) {
            if (qualifier == null) {
                QualifierInfo.$$$reportNull$$$0(0);
            }
            this.qualifier = qualifier;
            this.prefixFromForwards = prefixFromForwards;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "org/jetbrains/plugins/scss/SASSSCSSLangUtil$QualifierInfo", "<init>"));
        }
    }
}

