/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.redrawer;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.SkikoProperties;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002BG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00128\u0010\u0005\u001a4\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u0004R\u0012\u0010\f\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u0004\u0018\u00018\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R@\u0010\u0005\u001a4\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/skiko/redrawer/RedrawerManager;", "R", "", "defaultRenderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "redrawerFactory", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "renderApi", "oldRedrawer", "(Lorg/jetbrains/skiko/GraphicsApi;Lkotlin/jvm/functions/Function2;)V", "_redrawer", "Ljava/lang/Object;", "_renderApi", "fallbackRenderApiQueue", "", "redrawer", "getRedrawer", "()Ljava/lang/Object;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "dispose", "", "findNextWorkingRenderApi", "recreation", "", "forceRenderApi", "skiko"})
@SourceDebugExtension(value={"SMAP\nRedrawerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedrawerManager.kt\norg/jetbrains/skiko/redrawer/RedrawerManager\n+ 2 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,50:1\n159#2,4:51\n*S KotlinDebug\n*F\n+ 1 RedrawerManager.kt\norg/jetbrains/skiko/redrawer/RedrawerManager\n*L\n33#1:51,4\n*E\n"})
public final class RedrawerManager<R> {
    @NotNull
    private final Function2<GraphicsApi, R, R> redrawerFactory;
    @Nullable
    private R _redrawer;
    @NotNull
    private final List<GraphicsApi> fallbackRenderApiQueue;
    @NotNull
    private GraphicsApi _renderApi;

    public RedrawerManager(@NotNull GraphicsApi defaultRenderApi, @NotNull Function2<? super GraphicsApi, ? super R, ? extends R> redrawerFactory) {
        Intrinsics.checkNotNullParameter((Object)((Object)defaultRenderApi), (String)"defaultRenderApi");
        Intrinsics.checkNotNullParameter(redrawerFactory, (String)"redrawerFactory");
        this.redrawerFactory = redrawerFactory;
        this.fallbackRenderApiQueue = CollectionsKt.toMutableList((Collection)SkikoProperties.INSTANCE.fallbackRenderApiQueue$skiko(defaultRenderApi));
        this._renderApi = this.fallbackRenderApiQueue.get(0);
    }

    @Nullable
    public final R getRedrawer() {
        return this._redrawer;
    }

    @NotNull
    public final GraphicsApi getRenderApi() {
        return this._renderApi;
    }

    public final void findNextWorkingRenderApi(boolean recreation) {
        if (recreation) {
            this.fallbackRenderApiQueue.add(0, this.getRenderApi());
        }
        boolean thrown = false;
        do {
            thrown = false;
            try {
                this._renderApi = this.fallbackRenderApiQueue.remove(0);
                this._redrawer = this.redrawerFactory.invoke((Object)this._renderApi, this.getRedrawer());
            }
            catch (RenderException e) {
                Logger this_$iv = Logger.INSTANCE;
                boolean $i$f$warn = false;
                if (this_$iv.getLoggerImpl().isWarnEnabled()) {
                    Throwable throwable = e;
                    SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
                    boolean bl = false;
                    String string = "Fallback to next API";
                    skikoLoggerInterface.warn(throwable, string);
                }
                thrown = true;
            }
        } while (thrown && !((Collection)this.fallbackRenderApiQueue).isEmpty());
        if (thrown) {
            throw new RenderException("Cannot fallback to any render API", null, 2, null);
        }
    }

    public static /* synthetic */ void findNextWorkingRenderApi$default(RedrawerManager redrawerManager2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        redrawerManager2.findNextWorkingRenderApi(bl);
    }

    public final void forceRenderApi(@NotNull GraphicsApi renderApi) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderApi), (String)"renderApi");
        this._renderApi = renderApi;
    }

    public final void dispose() {
        this._redrawer = null;
    }
}

