/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webpack;

import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfigEvaluationContext;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfigExecutor;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfigManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.webpack.WebpackConfigLocator;
import com.intellij.webpack.WebpackConfigManagerKt;
import com.intellij.webpack.WebpackConfiguration;
import java.util.Arrays;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="WebPackConfiguration")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u0013H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/webpack/WebpackConfigManager;", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "bundlerId", "", "getBundlerId", "()Ljava/lang/String;", "configuration", "Lcom/intellij/webpack/WebpackConfiguration;", "getConfiguration", "()Lcom/intellij/webpack/WebpackConfiguration;", "computeConfigEvaluationContext", "Ljava/util/Optional;", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigEvaluationContext;", "element", "Lcom/intellij/psi/PsiElement;", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "preferGlobalConfig", "", "findConfigFile", "from", "overrideWorkingDir", "config", "Companion", "intellij.webpack"})
@SourceDebugExtension(value={"SMAP\nWebpackConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebpackConfigManager.kt\ncom/intellij/webpack/WebpackConfigManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class WebpackConfigManager
extends WebBundlerConfigManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebpackConfiguration configuration;
    @NotNull
    private final String bundlerId;

    public WebpackConfigManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.configuration = new WebpackConfiguration(null, null, 2, null);
        this.bundlerId = "Webpack";
    }

    @NotNull
    protected WebpackConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public String getBundlerId() {
        return this.bundlerId;
    }

    @NotNull
    protected Optional<WebBundlerConfigEvaluationContext> computeConfigEvaluationContext(@NotNull PsiElement element, @NotNull VirtualFile directory, boolean preferGlobalConfig) {
        WebBundlerConfigEvaluationContext webBundlerConfigEvaluationContext;
        VirtualFile virtualFile;
        VirtualFile virtualFile2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        VirtualFile usedConfig = this.findConfigFile(element, directory, preferGlobalConfig);
        String workingDir = this.overrideWorkingDir(usedConfig, directory);
        VirtualFile it = virtualFile2 = usedConfig;
        boolean bl = false;
        Object object = virtualFile = WebpackConfigLocator.Companion.isAcceptableForWebpackConfig(it) ? virtualFile2 : null;
        if (virtualFile != null) {
            it = virtualFile;
            boolean bl2 = false;
            webBundlerConfigEvaluationContext = new WebBundlerConfigEvaluationContext(it, workingDir, this.getBundlerId());
        } else {
            webBundlerConfigEvaluationContext = null;
        }
        WebBundlerConfigEvaluationContext context = webBundlerConfigEvaluationContext;
        Optional<Object> optional = Optional.ofNullable(context);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    private final VirtualFile findConfigFile(PsiElement element, VirtualFile from, boolean preferGlobalConfig) {
        if (preferGlobalConfig) {
            VirtualFile virtualFile;
            String string;
            String it = string = this.getGlobalConfigPath();
            boolean bl = false;
            String string2 = ((CharSequence)it).length() > 0 ? string : null;
            if (string2 != null) {
                it = string2;
                boolean bl2 = false;
                virtualFile = this.findFile(it);
            } else {
                virtualFile = null;
            }
            return virtualFile;
        }
        VirtualFile virtualFile = (VirtualFile)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)WebpackConfigManagerKt.access$getEP_NAME$p().lazySequence(), (Function1)((Function1)new Function1<WebpackConfigLocator, VirtualFile>(this, element){
            final /* synthetic */ WebpackConfigManager this$0;
            final /* synthetic */ PsiElement $element;
            {
                this.this$0 = $receiver;
                this.$element = $element;
                super(1);
            }

            @Nullable
            public final VirtualFile invoke(@NotNull WebpackConfigLocator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.detectConfig(WebpackConfigManager.access$getProject(this.this$0), this.$element);
            }
        })));
        if (virtualFile == null) {
            String[] stringArray = WebpackConfigLocator.Companion.getWEBPACK_NAMES_ARRAY$intellij_webpack();
            virtualFile = JSProjectUtil.findFileUpToContentRoot((Project)this.getProject(), (VirtualFile)from, (String[])Arrays.copyOf(stringArray, stringArray.length));
        }
        return virtualFile;
    }

    private final String overrideWorkingDir(VirtualFile config, VirtualFile from) {
        if (config != null && JSLibraryUtil.hasDirectoryInPath((VirtualFile)config, (String)"node_modules", null)) {
            VirtualFile modulePackageJson = WebBundlerConfigExecutor.Companion.findPackageJson(from);
            VirtualFile virtualFile = modulePackageJson;
            return virtualFile != null && (virtualFile = virtualFile.getParent()) != null ? virtualFile.getPath() : null;
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final WebpackConfigManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Project access$getProject(WebpackConfigManager $this) {
        return $this.getProject();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/webpack/WebpackConfigManager$Companion;", "", "()V", "getInstance", "Lcom/intellij/webpack/WebpackConfigManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.webpack"})
    @SourceDebugExtension(value={"SMAP\nWebpackConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebpackConfigManager.kt\ncom/intellij/webpack/WebpackConfigManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,58:1\n31#2,2:59\n*S KotlinDebug\n*F\n+ 1 WebpackConfigManager.kt\ncom/intellij/webpack/WebpackConfigManager$Companion\n*L\n54#1:59,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final WebpackConfigManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<WebpackConfigManager> serviceClass$iv = WebpackConfigManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (WebpackConfigManager)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

