/*
 * Decompiled with CFR 0.152.
 */
package reactor.util.context;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import reactor.util.annotation.Nullable;

public interface ContextView {
    public <T> T get(Object var1);

    default public <T> T get(Class<T> key2) {
        T v = this.get((Object)key2);
        if (key2.isInstance(v)) {
            return v;
        }
        throw new NoSuchElementException("Context does not contain a value of type " + key2.getName());
    }

    @Nullable
    default public <T> T getOrDefault(Object key2, @Nullable T defaultValue) {
        if (!this.hasKey(key2)) {
            return defaultValue;
        }
        return this.get(key2);
    }

    default public <T> Optional<T> getOrEmpty(Object key2) {
        if (this.hasKey(key2)) {
            return Optional.of(this.get(key2));
        }
        return Optional.empty();
    }

    public boolean hasKey(Object var1);

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size();

    public Stream<Map.Entry<Object, Object>> stream();

    default public void forEach(BiConsumer<Object, Object> action2) {
        this.stream().forEach((? super T entry) -> action2.accept(entry.getKey(), entry.getValue()));
    }
}

