/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;

final class SimpleCompressionHandler
extends HttpContentCompressor {
    SimpleCompressionHandler() {
        super((CompressionOptions[])null);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            super.write(ctx, (Object)new DefaultHttpContent((ByteBuf)msg), promise);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    void decode(ChannelHandlerContext ctx, HttpRequest msg) {
        ArrayList out = new ArrayList();
        HttpRequest request2 = msg;
        try {
            if (msg instanceof FullHttpRequest && ((FullHttpRequest)msg).content().refCnt() == 0) {
                request2 = new DefaultHttpRequest(msg.protocolVersion(), msg.method(), msg.uri(), msg.headers());
            }
            super.decode(ctx, request2, out);
        }
        catch (DecoderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DecoderException((Throwable)e);
        }
        finally {
            ReferenceCountUtil.release((Object)request2);
            out.clear();
        }
    }
}

