/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.server.DefaultHttpServerRoutes;
import reactor.netty.http.server.HttpPredicate;
import reactor.netty.http.server.HttpRouteHandlerMetadata;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.server.WebsocketServerSpec;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;
import reactor.util.annotation.Nullable;

public interface HttpServerRoutes
extends BiFunction<HttpServerRequest, HttpServerResponse, Publisher<Void>> {
    public static final Predicate<HttpServerRequest> INDEX_PREDICATE = req -> {
        URI uri = URI.create(req.uri());
        return Objects.equals(req.method(), HttpMethod.GET) && (uri.getPath().endsWith("/") || uri.getPath().indexOf(46, uri.getPath().lastIndexOf(47)) == -1);
    };

    public static HttpServerRoutes newRoutes() {
        return new DefaultHttpServerRoutes();
    }

    default public HttpServerRoutes delete(String path2, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        return this.route(HttpPredicate.delete(path2), handler);
    }

    default public HttpServerRoutes directory(String uri, Path directory) {
        return this.directory(uri, directory, null);
    }

    public HttpServerRoutes directory(String var1, Path var2, @Nullable Function<HttpServerResponse, HttpServerResponse> var3);

    default public HttpServerRoutes file(String uri, Path path2) {
        return this.file(HttpPredicate.get(uri), path2, null);
    }

    default public HttpServerRoutes file(String uri, String path2) {
        Objects.requireNonNull(path2, "path");
        return this.file(HttpPredicate.get(uri), Paths.get(path2, new String[0]), null);
    }

    default public HttpServerRoutes file(Predicate<HttpServerRequest> uri, Path path2, @Nullable Function<HttpServerResponse, HttpServerResponse> interceptor) {
        Objects.requireNonNull(path2, "path");
        return this.route(uri, (req, resp) -> {
            if (!Files.isReadable(path2)) {
                return resp.send(ByteBufFlux.fromPath(path2));
            }
            if (interceptor != null) {
                return ((HttpServerResponse)interceptor.apply((HttpServerResponse)resp)).sendFile(path2);
            }
            return resp.sendFile(path2);
        });
    }

    default public HttpServerRoutes get(String path2, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        return this.route(HttpPredicate.get(path2), handler);
    }

    default public HttpServerRoutes head(String path2, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        return this.route(HttpPredicate.head(path2), handler);
    }

    default public HttpServerRoutes index(BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        return this.route(INDEX_PREDICATE, handler);
    }

    default public HttpServerRoutes options(String path2, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        return this.route(HttpPredicate.options(path2), handler);
    }

    default public HttpServerRoutes post(String path2, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        return this.route(HttpPredicate.post(path2), handler);
    }

    default public HttpServerRoutes put(String path2, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        return this.route(HttpPredicate.put(path2), handler);
    }

    public HttpServerRoutes removeIf(Predicate<? super HttpRouteHandlerMetadata> var1);

    public HttpServerRoutes route(Predicate<? super HttpServerRequest> var1, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> var2);

    public HttpServerRoutes comparator(Comparator<HttpRouteHandlerMetadata> var1);

    public HttpServerRoutes noComparator();

    default public HttpServerRoutes ws(String path2, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> handler) {
        return this.ws(path2, handler, WebsocketServerSpec.builder().build());
    }

    default public HttpServerRoutes ws(String path2, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> handler, WebsocketServerSpec configurer) {
        return this.ws(HttpPredicate.get(path2), handler, configurer);
    }

    default public HttpServerRoutes ws(Predicate<? super HttpServerRequest> condition, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> handler, WebsocketServerSpec websocketServerSpec) {
        return this.route(condition, (req, resp) -> {
            if (req.requestHeaders().containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.UPGRADE, true)) {
                HttpServerOperations ops = (HttpServerOperations)req;
                return ops.withWebsocketSupport(req.uri(), websocketServerSpec, handler);
            }
            return resp.sendNotFound();
        });
    }
}

