/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.handler.codec.http.HttpRequest;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.transport.AddressUtils;

final class DefaultHttpForwardedHeaderHandler
implements BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> {
    static final DefaultHttpForwardedHeaderHandler INSTANCE = new DefaultHttpForwardedHeaderHandler();
    static final String FORWARDED_HEADER = "Forwarded";
    static final String X_FORWARDED_IP_HEADER = "X-Forwarded-For";
    static final String X_FORWARDED_HOST_HEADER = "X-Forwarded-Host";
    static final String X_FORWARDED_PORT_HEADER = "X-Forwarded-Port";
    static final String X_FORWARDED_PROTO_HEADER = "X-Forwarded-Proto";
    static final Pattern FORWARDED_HOST_PATTERN = Pattern.compile("host=\"?([^;,\"]+)\"?");
    static final Pattern FORWARDED_PROTO_PATTERN = Pattern.compile("proto=\"?([^;,\"]+)\"?");
    static final Pattern FORWARDED_FOR_PATTERN = Pattern.compile("for=\"?([^;,\"]+)\"?");
    @Deprecated
    static final String FORWARDED_HEADER_VALIDATION = "reactor.netty.http.server.forwarded.strictValidation";
    static final boolean DEFAULT_FORWARDED_HEADER_VALIDATION = Boolean.parseBoolean(System.getProperty("reactor.netty.http.server.forwarded.strictValidation", "true"));

    DefaultHttpForwardedHeaderHandler() {
    }

    @Override
    public ConnectionInfo apply(ConnectionInfo connectionInfo, HttpRequest request2) {
        String forwardedHeader = request2.headers().get(FORWARDED_HEADER);
        if (forwardedHeader != null) {
            return this.parseForwardedInfo(connectionInfo, forwardedHeader);
        }
        return this.parseXForwardedInfo(connectionInfo, request2);
    }

    private ConnectionInfo parseForwardedInfo(ConnectionInfo connectionInfo, String forwardedHeader) {
        Matcher forMatcher;
        Matcher hostMatcher;
        String forwarded = forwardedHeader.split(",", 2)[0];
        Matcher protoMatcher = FORWARDED_PROTO_PATTERN.matcher(forwarded);
        if (protoMatcher.find()) {
            connectionInfo = connectionInfo.withScheme(protoMatcher.group(1).trim());
        }
        if ((hostMatcher = FORWARDED_HOST_PATTERN.matcher(forwarded)).find()) {
            connectionInfo = connectionInfo.withHostAddress(AddressUtils.parseAddress(hostMatcher.group(1), ConnectionInfo.getDefaultHostPort(connectionInfo.getScheme()), DEFAULT_FORWARDED_HEADER_VALIDATION));
        }
        if ((forMatcher = FORWARDED_FOR_PATTERN.matcher(forwarded)).find()) {
            connectionInfo = connectionInfo.withRemoteAddress(AddressUtils.parseAddress(forMatcher.group(1).trim(), connectionInfo.getRemoteAddress().getPort(), DEFAULT_FORWARDED_HEADER_VALIDATION));
        }
        return connectionInfo;
    }

    private ConnectionInfo parseXForwardedInfo(ConnectionInfo connectionInfo, HttpRequest request2) {
        String portHeader;
        String hostHeader;
        String protoHeader;
        String ipHeader = request2.headers().get(X_FORWARDED_IP_HEADER);
        if (ipHeader != null) {
            connectionInfo = connectionInfo.withRemoteAddress(AddressUtils.parseAddress(ipHeader.split(",", 2)[0], connectionInfo.getRemoteAddress().getPort()));
        }
        if ((protoHeader = request2.headers().get(X_FORWARDED_PROTO_HEADER)) != null) {
            connectionInfo = connectionInfo.withScheme(protoHeader.split(",", 2)[0].trim());
        }
        if ((hostHeader = request2.headers().get(X_FORWARDED_HOST_HEADER)) != null) {
            connectionInfo = connectionInfo.withHostAddress(AddressUtils.parseAddress(hostHeader.split(",", 2)[0].trim(), ConnectionInfo.getDefaultHostPort(connectionInfo.getScheme()), DEFAULT_FORWARDED_HEADER_VALIDATION));
        }
        if ((portHeader = request2.headers().get(X_FORWARDED_PORT_HEADER)) != null && !portHeader.isEmpty()) {
            String portStr = portHeader.split(",", 2)[0].trim();
            if (portStr.chars().allMatch(Character::isDigit)) {
                int port = Integer.parseInt(portStr);
                connectionInfo = connectionInfo.withHostAddress(AddressUtils.createUnresolved(connectionInfo.getHostAddress().getHostString(), port), connectionInfo.getHostName(), port);
            } else if (DEFAULT_FORWARDED_HEADER_VALIDATION) {
                throw new IllegalArgumentException("Failed to parse a port from " + portHeader);
            }
        }
        return connectionInfo;
    }
}

