/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import java.net.SocketAddress;
import java.time.Duration;
import java.util.function.Function;
import reactor.netty.http.server.AbstractHttpServerMetricsHandler;
import reactor.netty.http.server.ContextAwareHttpServerMetricsRecorder;
import reactor.netty.http.server.HttpServerOperations;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

final class ContextAwareHttpServerMetricsHandler
extends AbstractHttpServerMetricsHandler {
    final ContextAwareHttpServerMetricsRecorder recorder;

    ContextAwareHttpServerMetricsHandler(ContextAwareHttpServerMetricsRecorder recorder, @Nullable Function<String, String> methodTagValue, @Nullable Function<String, String> uriTagValue) {
        super(methodTagValue, uriTagValue);
        this.recorder = recorder;
    }

    ContextAwareHttpServerMetricsHandler(ContextAwareHttpServerMetricsHandler copy) {
        super(copy);
        this.recorder = copy.recorder;
    }

    @Override
    protected ContextAwareHttpServerMetricsRecorder recorder() {
        return this.recorder;
    }

    @Override
    protected void recordException(HttpServerOperations ops, String path2) {
        this.recorder().incrementErrorsCount((ContextView)ops.currentContext(), (SocketAddress)ops.remoteAddress(), path2);
    }

    @Override
    protected void recordRead(HttpServerOperations ops, String path2, String method) {
        Context contextView = ops.currentContext();
        this.recorder().recordDataReceivedTime(contextView, path2, method, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        this.recorder().recordDataReceived((ContextView)contextView, (SocketAddress)ops.remoteAddress(), path2, this.dataReceived);
    }

    @Override
    protected void recordWrite(HttpServerOperations ops, String path2, String method, String status) {
        Context contextView = ops.currentContext();
        Duration dataSentTimeDuration = Duration.ofNanos(System.nanoTime() - this.dataSentTime);
        this.recorder().recordDataSentTime(contextView, path2, method, status, dataSentTimeDuration);
        if (this.dataReceivedTime != 0L) {
            this.recorder().recordResponseTime(contextView, path2, method, status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        } else {
            this.recorder().recordResponseTime(contextView, path2, method, status, dataSentTimeDuration);
        }
        this.recorder().recordDataSent((ContextView)contextView, (SocketAddress)ops.remoteAddress(), path2, this.dataSent);
    }
}

