/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public final class WeakMap
implements Map<Object, Object> {
    public static final HiddenKey INVERTED_WEAK_MAP_KEY = new HiddenKey("InvertedWeakMap");

    private static Map<WeakMap, Object> getInvertedMap(Object k) {
        if (k instanceof JSObject) {
            return (Map)JSDynamicObject.getOrNull((JSObject)k, INVERTED_WEAK_MAP_KEY);
        }
        if (k instanceof Symbol) {
            return ((Symbol)k).getInvertedMap();
        }
        throw new IllegalArgumentException("key must be instanceof JSObject or Symbol");
    }

    private static Map<WeakMap, Object> putInvertedMap(Object k) {
        Map<WeakMap, Object> invertedMap = WeakMap.newInvertedMap();
        if (k instanceof JSObject) {
            JSObjectUtil.putHiddenProperty((JSObject)k, INVERTED_WEAK_MAP_KEY, invertedMap);
        } else if (k instanceof Symbol) {
            ((Symbol)k).setInvertedMap(invertedMap);
        } else {
            throw new IllegalArgumentException("key must be instanceof JSObject or Symbol");
        }
        return invertedMap;
    }

    @CompilerDirectives.TruffleBoundary
    public static Map<WeakMap, Object> newInvertedMap() {
        return new WeakHashMap<WeakMap, Object>();
    }

    @CompilerDirectives.TruffleBoundary
    public Map<WeakMap, Object> newInvertedMapWithEntry(Object key2, Object value2) {
        assert (WeakMap.getInvertedMap(key2) == null);
        WeakHashMap<WeakMap, Object> map2 = new WeakHashMap<WeakMap, Object>();
        map2.put(this, value2);
        return map2;
    }

    @Override
    public boolean containsKey(Object key2) {
        Map<WeakMap, Object> invertedMap = WeakMap.getInvertedMap(key2);
        return invertedMap == null ? false : invertedMap.containsKey(this);
    }

    @Override
    public Object get(Object key2) {
        Map<WeakMap, Object> invertedMap = WeakMap.getInvertedMap(key2);
        return invertedMap == null ? null : invertedMap.get(this);
    }

    @Override
    public Object put(Object key2, Object value2) {
        Map<WeakMap, Object> invertedMap = WeakMap.getInvertedMap(key2);
        if (invertedMap == null) {
            invertedMap = WeakMap.putInvertedMap(key2);
        }
        return invertedMap.put(this, value2);
    }

    @Override
    public Object remove(Object key2) {
        Map<WeakMap, Object> invertedMap = WeakMap.getInvertedMap(key2);
        return invertedMap == null ? null : invertedMap.remove(this);
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> m) {
        m.forEach(this::put);
    }

    @Override
    public boolean containsValue(Object value2) {
        throw WeakMap.unsupported();
    }

    @Override
    public int size() {
        throw WeakMap.unsupported();
    }

    @Override
    public boolean isEmpty() {
        throw WeakMap.unsupported();
    }

    @Override
    public void clear() {
        throw WeakMap.unsupported();
    }

    @Override
    public Set<Object> keySet() {
        throw WeakMap.unsupported();
    }

    @Override
    public Collection<Object> values() {
        throw WeakMap.unsupported();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        throw WeakMap.unsupported();
    }

    private static UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException("Not supported by WeakMap");
    }
}

