/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import java.util.Arrays;
import java.util.List;
import org.graalvm.collections.EconomicSet;

public class ForInIterator {
    public JSDynamicObject object;
    public Shape objectShape;
    public boolean objectWasVisited;
    public EconomicSet<Object> visitedKeys;
    public List<?> remainingKeys;
    public int remainingKeysSize;
    public int remainingKeysIndex;
    public Shape[] visitedShapes;
    public int visitedShapesSize;
    public boolean fastOwnKeys;
    public int protoDepth;
    public final boolean iterateValues;

    public ForInIterator(JSDynamicObject obj, boolean iterateValues) {
        this.object = obj;
        this.iterateValues = iterateValues;
        this.visitedShapes = new Shape[4];
    }

    public void addVisitedShape(Shape shape, Node node, InlinedBranchProfile growBranch) {
        if (this.visitedShapesSize >= this.visitedShapes.length) {
            growBranch.enter(node);
            this.visitedShapes = Arrays.copyOf(this.visitedShapes, this.visitedShapes.length * 2);
        }
        this.visitedShapes[this.visitedShapesSize++] = shape;
    }

    public boolean addVisitedKey(Object key2) {
        if (this.visitedKeys == null) {
            this.visitedKeys = Boundaries.economicSetCreate();
        }
        return Boundaries.economicSetAdd(this.visitedKeys, key2);
    }

    public boolean isVisitedKey(Object key2) {
        return this.visitedShapesSize > 0 && ForInIterator.visitedShapeSetContainsKey(this.visitedShapes, this.visitedShapesSize, key2) || this.visitedKeys != null && Boundaries.economicSetContains(this.visitedKeys, key2);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean visitedShapeSetContainsKey(Shape[] visitedShapes, int size, Object key2) {
        for (int i = 0; i < size; ++i) {
            Shape visitedShape = visitedShapes[i];
            if (!visitedShape.hasProperty(key2)) continue;
            return true;
        }
        return false;
    }
}

