/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.ArrayCopy;
import com.oracle.truffle.js.runtime.array.dyn.ContiguousDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;

public final class ZeroBasedDoubleArray
extends AbstractDoubleArray {
    private static final ZeroBasedDoubleArray ZERO_BASED_DOUBLE_ARRAY = (ZeroBasedDoubleArray)new ZeroBasedDoubleArray(0, ZeroBasedDoubleArray.createCache()).maybePreinitializeCache();

    public static ZeroBasedDoubleArray makeZeroBasedDoubleArray(JSDynamicObject object, int length2, int usedLength, double[] array, int integrityLevel) {
        ZeroBasedDoubleArray arrayType = (ZeroBasedDoubleArray)ZeroBasedDoubleArray.createZeroBasedDoubleArray().setIntegrityLevel(integrityLevel);
        JSAbstractArray.arraySetLength(object, length2);
        JSAbstractArray.arraySetUsedLength(object, usedLength);
        JSAbstractArray.arraySetArray(object, array);
        return arrayType;
    }

    public static ZeroBasedDoubleArray createZeroBasedDoubleArray() {
        return ZERO_BASED_DOUBLE_ARRAY;
    }

    private ZeroBasedDoubleArray(int integrityLevel, DynamicArray.DynamicArrayCache cache2) {
        super(integrityLevel, cache2);
    }

    @Override
    public double getInBoundsFastDouble(JSDynamicObject object, int index) {
        return ZeroBasedDoubleArray.getArray(object)[index];
    }

    @Override
    public void setInBoundsFast(JSDynamicObject object, int index, double value2) {
        ZeroBasedDoubleArray.getArray((JSDynamicObject)object)[index] = value2;
    }

    @Override
    public boolean isSupported(JSDynamicObject object, long index) {
        return ZeroBasedDoubleArray.isSupportedZeroBased(object, (int)index);
    }

    @Override
    protected int prepareInBoundsFast(JSDynamicObject object, long index) {
        return (int)index;
    }

    @Override
    protected int prepareInBounds(JSDynamicObject object, int index, Node node, AbstractWritableArray.SetSupportedProfileAccess profile) {
        ZeroBasedDoubleArray.prepareInBoundsZeroBased(object, index, node, profile);
        return index;
    }

    @Override
    protected int prepareSupported(JSDynamicObject object, int index, Node node, AbstractWritableArray.SetSupportedProfileAccess profile) {
        this.prepareSupportedZeroBased(object, index, node, profile);
        return index;
    }

    @Override
    protected void setLengthLess(JSDynamicObject object, long length2, Node node, ScriptArray.SetLengthProfileAccess profile) {
        this.setLengthLessZeroBased(object, length2, node, profile);
    }

    @Override
    public ZeroBasedObjectArray toObject(JSDynamicObject object, long index, Object value2) {
        double[] array = ZeroBasedDoubleArray.getArray(object);
        int length2 = this.lengthInt(object);
        int usedLength = ZeroBasedDoubleArray.getUsedLength(object);
        Object[] doubleCopy = ArrayCopy.doubleToObject(array, 0, usedLength);
        ZeroBasedObjectArray newArray = ZeroBasedObjectArray.makeZeroBasedObjectArray(object, length2, usedLength, doubleCopy, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedDoubleArray.traceArrayTransition(this, newArray, index, value2);
        }
        return newArray;
    }

    @Override
    public ContiguousDoubleArray toContiguous(JSDynamicObject object, long index, Object value2) {
        double[] array = ZeroBasedDoubleArray.getArray(object);
        int length2 = this.lengthInt(object);
        int usedLength = ZeroBasedDoubleArray.getUsedLength(object);
        ContiguousDoubleArray newArray = ContiguousDoubleArray.makeContiguousDoubleArray(object, length2, array, 0L, 0, usedLength, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedDoubleArray.traceArrayTransition(this, newArray, index, value2);
        }
        return newArray;
    }

    @Override
    public HolesDoubleArray toHoles(JSDynamicObject object, long index, Object value2) {
        double[] array = ZeroBasedDoubleArray.getArray(object);
        int length2 = this.lengthInt(object);
        int usedLength = ZeroBasedDoubleArray.getUsedLength(object);
        HolesDoubleArray newArray = HolesDoubleArray.makeHolesDoubleArray(object, length2, array, 0L, 0, usedLength, 0, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedDoubleArray.traceArrayTransition(this, newArray, index, value2);
        }
        return newArray;
    }

    @Override
    public long firstElementIndex(JSDynamicObject object) {
        return 0L;
    }

    @Override
    public long lastElementIndex(JSDynamicObject object) {
        return ZeroBasedDoubleArray.getUsedLength(object) - 1;
    }

    @Override
    public ScriptArray removeRangeImpl(JSDynamicObject object, long start, long end) {
        double[] array = ZeroBasedDoubleArray.getArray(object);
        int usedLength = ZeroBasedDoubleArray.getUsedLength(object);
        long moveLength = (long)usedLength - end;
        if (moveLength > 0L) {
            System.arraycopy(array, (int)end, array, (int)start, (int)moveLength);
        }
        if (start < (long)usedLength) {
            int newUsedLength = (int)(moveLength > 0L ? (long)usedLength - (end - start) : start);
            JSAbstractArray.arraySetUsedLength(object, newUsedLength);
        }
        return this;
    }

    @Override
    public ScriptArray shiftRangeImpl(JSDynamicObject object, long from2) {
        int usedLength = ZeroBasedDoubleArray.getUsedLength(object);
        if (from2 < (long)usedLength) {
            return ContiguousDoubleArray.makeContiguousDoubleArray(object, (long)this.lengthInt(object) - from2, ZeroBasedDoubleArray.getArray(object), -from2, (int)from2, (int)((long)usedLength - from2), this.integrityLevel);
        }
        return this.removeRangeImpl(object, 0L, from2);
    }

    @Override
    public ScriptArray addRangeImpl(JSDynamicObject object, long offset, int size) {
        return this.addRangeImplZeroBased(object, offset, size);
    }

    @Override
    public boolean hasHoles(JSDynamicObject object) {
        int length2 = this.lengthInt(object);
        int usedLength = ZeroBasedDoubleArray.getUsedLength(object);
        return usedLength < length2;
    }

    @Override
    protected ZeroBasedDoubleArray withIntegrityLevel(int newIntegrityLevel) {
        return new ZeroBasedDoubleArray(newIntegrityLevel, this.cache);
    }

    @Override
    public long nextElementIndex(JSDynamicObject object, long index) {
        return this.nextElementIndexZeroBased(object, index);
    }
}

