/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.AsyncIteratorHelperPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.AsyncIteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.control.AsyncGeneratorAwaitReturnNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.function.InternalCallNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.objects.AsyncGeneratorRequest;
import com.oracle.truffle.js.runtime.objects.Completion;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.ArrayDeque;

public class AsyncIteratorHelperPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<HelperIteratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new AsyncIteratorHelperPrototypeBuiltins();
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("AsyncIteratorHelper.prototype");
    public static final TruffleString CLASS_NAME = Strings.constant("AsyncIteratorHelper");
    public static final TruffleString TO_STRING_TAG = Strings.constant("Async Iterator Helper");
    private static final HiddenKey ITERATED_ID = new HiddenKey("Iterated");
    public static final HiddenKey IMPL_ID = new HiddenKey("ResumptionTarget");

    protected AsyncIteratorHelperPrototypeBuiltins() {
        super(PROTOTYPE_NAME, HelperIteratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, HelperIteratorPrototype builtinEnum) {
        switch (builtinEnum) {
            case next: {
                return AsyncIteratorHelperPrototypeBuiltinsFactory.AsyncIteratorHelperNextNodeGen.create(context, builtin, AsyncIteratorHelperPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case return_: {
                return AsyncIteratorHelperPrototypeBuiltinsFactory.IteratorHelperReturnNodeGen.create(context, builtin, AsyncIteratorHelperPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum HelperIteratorPrototype implements BuiltinEnum<HelperIteratorPrototype>
    {
        next(0),
        return_(0);

        private final int length;

        private HelperIteratorPrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class AsyncIteratorHelperNextNode
    extends AsyncIteratorHelperResumeNode {
        @Node.Child
        private JSFunctionCallNode callResolveNode = JSFunctionCallNode.createCall();
        @Node.Child
        private CreateIterResultObjectNode createIterResultObjectNode;

        protected AsyncIteratorHelperNextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getAsyncGeneratorStateNode = PropertyGetNode.createGetHidden(JSFunction.ASYNC_GENERATOR_STATE_ID, context);
            this.createIterResultObjectNode = CreateIterResultObjectNode.create(context);
        }

        @Override
        @Specialization
        protected final Object validateAndResume(VirtualFrame frame, Object thisObj) {
            return super.validateAndResume(frame, thisObj);
        }

        @Override
        protected final void performNextOrReturn(VirtualFrame frame, JSObject generator, PromiseCapabilityRecord promiseCapability) {
            JSFunction.AsyncGeneratorState state = (JSFunction.AsyncGeneratorState)((Object)this.getAsyncGeneratorStateNode.getValue(generator));
            if (state == JSFunction.AsyncGeneratorState.Completed) {
                JSDynamicObject iteratorResult = this.createIterResultObjectNode.execute(frame, Undefined.instance, true);
                this.callResolveNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getResolve(), iteratorResult));
            } else {
                Completion completion = Completion.forNormal(Undefined.instance);
                ArrayDeque<AsyncGeneratorRequest> queue = this.getAsyncGeneratorQueue(generator);
                AsyncGeneratorRequest request2 = AsyncGeneratorRequest.create(completion, promiseCapability);
                Boundaries.queueAdd(queue, request2);
                if (state == JSFunction.AsyncGeneratorState.SuspendedStart || state == JSFunction.AsyncGeneratorState.SuspendedYield) {
                    this.performResumeNext(generator, completion, state);
                } else assert (state == JSFunction.AsyncGeneratorState.Executing || state == JSFunction.AsyncGeneratorState.AwaitingReturn);
            }
        }
    }

    public static abstract class IteratorHelperReturnNode
    extends AsyncIteratorHelperResumeNode {
        @Node.Child
        private AsyncGeneratorAwaitReturnNode asyncGeneratorAwaitReturnNode;

        protected IteratorHelperReturnNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.asyncGeneratorAwaitReturnNode = AsyncGeneratorAwaitReturnNode.create(context);
        }

        @Override
        @Specialization
        protected final Object validateAndResume(VirtualFrame frame, Object thisObj) {
            return super.validateAndResume(frame, thisObj);
        }

        @Override
        protected final void performNextOrReturn(VirtualFrame frame, JSObject generator, PromiseCapabilityRecord promiseCapability) {
            Completion completion = Completion.forReturn(Undefined.instance);
            ArrayDeque<AsyncGeneratorRequest> queue = this.getAsyncGeneratorQueue(generator);
            AsyncGeneratorRequest request2 = AsyncGeneratorRequest.create(completion, promiseCapability);
            Boundaries.queueAdd(queue, request2);
            JSFunction.AsyncGeneratorState state = (JSFunction.AsyncGeneratorState)((Object)this.getAsyncGeneratorStateNode.getValue(generator));
            if (state == JSFunction.AsyncGeneratorState.SuspendedStart || state == JSFunction.AsyncGeneratorState.Completed) {
                this.asyncGeneratorAwaitReturnNode.executeAsyncGeneratorAwaitReturn(frame, generator, queue);
            } else if (state == JSFunction.AsyncGeneratorState.SuspendedYield) {
                this.performResumeNext(generator, completion, state);
            } else assert (state == JSFunction.AsyncGeneratorState.Executing || state == JSFunction.AsyncGeneratorState.AwaitingReturn);
        }
    }

    protected static abstract class AsyncIteratorHelperResumeNode
    extends JSBuiltinNode {
        @Node.Child
        private NewPromiseCapabilityNode newPromiseCapabilityNode;
        @Node.Child
        private PropertyGetNode getGeneratorResumptionTargetNode;
        @Node.Child
        protected PropertyGetNode getAsyncGeneratorStateNode;
        @Node.Child
        private PropertyGetNode getAsyncGeneratorQueueNode;
        @Node.Child
        private InternalCallNode internalCallNode;
        @Node.Child
        private JSFunctionCallNode callNode;
        @Node.Child
        private TryCatchNode.GetErrorObjectNode getErrorObjectNode;

        protected AsyncIteratorHelperResumeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.newPromiseCapabilityNode = NewPromiseCapabilityNode.create(context);
            this.getGeneratorResumptionTargetNode = PropertyGetNode.createGetHidden(IMPL_ID, context);
            this.getAsyncGeneratorStateNode = PropertyGetNode.createGetHidden(JSFunction.ASYNC_GENERATOR_STATE_ID, context);
            this.getAsyncGeneratorQueueNode = PropertyGetNode.createGetHidden(JSFunction.ASYNC_GENERATOR_QUEUE_ID, context);
            this.internalCallNode = InternalCallNode.create();
            this.callNode = JSFunctionCallNode.createCall();
        }

        protected Object validateAndResume(VirtualFrame frame, Object thisObj) {
            PromiseCapabilityRecord promiseCapability = this.newPromiseCapabilityNode.executeDefault();
            try {
                if (!JSObject.isJSObject(thisObj) || this.getGeneratorResumptionTargetNode.getValue(thisObj) == Undefined.instance) {
                    throw Errors.createTypeErrorIncompatibleReceiver(thisObj);
                }
                JSObject generator = (JSObject)thisObj;
                this.performNextOrReturn(frame, generator, promiseCapability);
            }
            catch (AbstractTruffleException ex) {
                if (this.getErrorObjectNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.getErrorObjectNode = this.insert(TryCatchNode.GetErrorObjectNode.create(this.getContext()));
                }
                Object error = this.getErrorObjectNode.execute(ex);
                this.callNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getReject(), error));
            }
            return promiseCapability.getPromise();
        }

        protected abstract void performNextOrReturn(VirtualFrame var1, JSObject var2, PromiseCapabilityRecord var3);

        protected final void performResumeNext(JSDynamicObject iterator, Completion completion, JSFunction.AsyncGeneratorState state) {
            assert (state == JSFunction.AsyncGeneratorState.SuspendedStart || state == JSFunction.AsyncGeneratorState.SuspendedYield) : state;
            JSFunctionObject resumptionClosure = (JSFunctionObject)this.getGeneratorResumptionTargetNode.getValue(iterator);
            ArrayDeque<AsyncGeneratorRequest> queue = this.getAsyncGeneratorQueue(iterator);
            assert (!queue.isEmpty());
            CallTarget resumptionTarget = JSFunction.getCallTarget(resumptionClosure);
            this.internalCallNode.execute(resumptionTarget, JSArguments.createOneArg(iterator, resumptionClosure, completion));
        }

        protected final ArrayDeque<AsyncGeneratorRequest> getAsyncGeneratorQueue(JSDynamicObject iterator) {
            return (ArrayDeque)this.getAsyncGeneratorQueueNode.getValue(iterator);
        }
    }

    protected static class CreateAsyncIteratorHelperNode
    extends JavaScriptBaseNode {
        @Node.Child
        private CreateObjectNode.CreateObjectWithPrototypeNode createObjectNode;
        @Node.Child
        private PropertySetNode setIteratedNode;
        @Node.Child
        private PropertySetNode setGeneratorResumptionTargetNode;
        @Node.Child
        private PropertySetNode setGeneratorState;
        @Node.Child
        private PropertySetNode setGeneratorQueue;
        @Node.Child
        private PropertySetNode setThisNode;

        public CreateAsyncIteratorHelperNode(JSContext context) {
            this.createObjectNode = CreateObjectNode.createOrdinaryWithPrototype(context);
            this.setIteratedNode = PropertySetNode.createSetHidden(ITERATED_ID, context);
            this.setGeneratorResumptionTargetNode = PropertySetNode.createSetHidden(IMPL_ID, context);
            this.setGeneratorState = PropertySetNode.createSetHidden(JSFunction.ASYNC_GENERATOR_STATE_ID, context);
            this.setGeneratorQueue = PropertySetNode.createSetHidden(JSFunction.ASYNC_GENERATOR_QUEUE_ID, context);
            this.setThisNode = PropertySetNode.createSetHidden(AsyncIteratorPrototypeBuiltins.AsyncIteratorAwaitNode.THIS_ID, context);
        }

        public JSDynamicObject execute(IteratorRecord iterated, JSFunctionObject start) {
            JSObject iterator = this.createObjectNode.execute(this.getRealm().getAsyncIteratorHelperPrototype());
            this.setIteratedNode.setValue(iterator, iterated);
            this.setGeneratorResumptionTargetNode.setValue(iterator, start);
            this.setGeneratorState.setValue(iterator, (Object)JSFunction.AsyncGeneratorState.SuspendedStart);
            this.setGeneratorQueue.setValue(iterator, new ArrayDeque(4));
            this.setThisNode.setValue(start, iterator);
            return iterator;
        }

        public static CreateAsyncIteratorHelperNode create(JSContext context) {
            return new CreateAsyncIteratorHelperNode(context);
        }
    }
}

