/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.spi.json;

import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class AbstractJsonProvider
implements JsonProvider {
    @Override
    public boolean isArray(Object obj) {
        return obj instanceof List;
    }

    @Override
    public Object getArrayIndex(Object obj, int idx) {
        return ((List)obj).get(idx);
    }

    @Override
    @Deprecated
    public final Object getArrayIndex(Object obj, int idx, boolean unwrap) {
        return this.getArrayIndex(obj, idx);
    }

    @Override
    public void setArrayIndex(Object array, int index, Object newValue) {
        if (!this.isArray(array)) {
            throw new UnsupportedOperationException();
        }
        List l = (List)array;
        if (index == l.size()) {
            l.add(newValue);
        } else {
            l.set(index, newValue);
        }
    }

    @Override
    public Object getMapValue(Object obj, String key2) {
        Map m = (Map)obj;
        if (!m.containsKey(key2)) {
            return JsonProvider.UNDEFINED;
        }
        return m.get(key2);
    }

    @Override
    public void setProperty(Object obj, Object key2, Object value2) {
        if (!this.isMap(obj)) {
            throw new JsonPathException("setProperty operation cannot be used with " + obj != null ? obj.getClass().getName() : "null");
        }
        ((Map)obj).put(key2.toString(), value2);
    }

    @Override
    public void removeProperty(Object obj, Object key2) {
        if (this.isMap(obj)) {
            ((Map)obj).remove(key2.toString());
        } else {
            List list2 = (List)obj;
            int index = key2 instanceof Integer ? (Integer)key2 : Integer.parseInt(key2.toString());
            list2.remove(index);
        }
    }

    @Override
    public boolean isMap(Object obj) {
        return obj instanceof Map;
    }

    @Override
    public Collection<String> getPropertyKeys(Object obj) {
        if (this.isArray(obj)) {
            throw new UnsupportedOperationException();
        }
        return ((Map)obj).keySet();
    }

    @Override
    public int length(Object obj) {
        if (this.isArray(obj)) {
            return ((List)obj).size();
        }
        if (this.isMap(obj)) {
            return this.getPropertyKeys(obj).size();
        }
        if (obj instanceof String) {
            return ((String)obj).length();
        }
        throw new JsonPathException("length operation cannot be applied to " + (obj != null ? obj.getClass().getName() : "null"));
    }

    @Override
    public Iterable<?> toIterable(Object obj) {
        if (this.isArray(obj)) {
            return (Iterable)obj;
        }
        throw new JsonPathException("Cannot iterate over " + obj != null ? obj.getClass().getName() : "null");
    }

    @Override
    public Object unwrap(Object obj) {
        return obj;
    }
}

