/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.spi.cache;

import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.internal.Utils;
import com.jayway.jsonpath.spi.cache.Cache;
import com.jayway.jsonpath.spi.cache.LRUCache;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class CacheProvider {
    private static final AtomicReferenceFieldUpdater<CacheProvider, Cache> UPDATER = AtomicReferenceFieldUpdater.newUpdater(CacheProvider.class, Cache.class, "cache");
    private static final CacheProvider instance = new CacheProvider();
    private volatile Cache cache;

    public static void setCache(Cache cache2) {
        Utils.notNull(cache2, "Cache may not be null");
        if (!UPDATER.compareAndSet(instance, null, cache2)) {
            throw new JsonPathException("Cache provider must be configured before cache is accessed and must not be registered twice.");
        }
    }

    public static Cache getCache() {
        return CacheHolder.CACHE;
    }

    private static Cache getDefaultCache() {
        return new LRUCache(400);
    }

    private static class CacheHolder {
        static final Cache CACHE;

        private CacheHolder() {
        }

        static {
            Cache cache2 = instance.cache;
            if (cache2 == null) {
                cache2 = CacheProvider.getDefaultCache();
                if (!UPDATER.compareAndSet(instance, null, cache2)) {
                    cache2 = instance.cache;
                }
            }
            CACHE = cache2;
        }
    }
}

