/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.postman.converter.auth.oauth2;

import com.intellij.httpClient.http.request.environment.auth.oauth2.ClientAuthentication;
import com.intellij.httpClient.postman.converter.PostmanEnvironmentConverterKt;
import com.intellij.httpClient.postman.converter.PostmanUniqueNameGenerator;
import com.intellij.httpClient.postman.converter.auth.HttpClientAuth;
import com.intellij.httpClient.postman.converter.auth.PostmanAuthProviderKt;
import com.intellij.httpClient.postman.converter.auth.oauth2.Oauth2AuthProviderKt;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpAuthEnv;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpClientHeader;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpEnvItem;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanAuthAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0002J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0002J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0002J\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007J6\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00072\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\b\b\u0002\u0010\u0018\u001a\u00020\u0005H\u0002J \u0010\u0019\u001a\u00020\u001a*\b\u0012\u0004\u0012\u00020\b0\u001b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0002J \u0010\u001c\u001a\u00020\u001a*\b\u0012\u0004\u0012\u00020\b0\u001b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0002J \u0010\u001d\u001a\u00020\u001a*\b\u0012\u0004\u0012\u00020\b0\u001b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/httpClient/postman/converter/auth/oauth2/Oauth2AuthProvider;", "", "()V", "existingNameBySecret", "", "", "tokenNameByExistingEnvs", "", "Lcom/intellij/httpClient/postman/converter/dto/httpClient/HttpEnvItem;", "uniqueNameGenerator", "Lcom/intellij/httpClient/postman/converter/PostmanUniqueNameGenerator;", "clientAuthentication", "Lcom/intellij/httpClient/http/request/environment/auth/oauth2/ClientAuthentication;", "attributes", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanAuthAttribute;", "generateEnvForAuthCodeGrantType", "generateEnvForClientCredentialsGrantType", "generateEnvForImplicitGrantType", "generateEnvForPasswordGrantType", "getOauth2", "Lcom/intellij/httpClient/postman/converter/auth/HttpClientAuth;", "getSecretsIfExists", "postmanKey", "httpClientKey", "name", "addAccessTokenIfExists", "", "", "addAuthUrlIfExists", "addRedirectUrlIfExists", "intellij.restClient"})
public final class Oauth2AuthProvider {
    @NotNull
    private final PostmanUniqueNameGenerator uniqueNameGenerator = new PostmanUniqueNameGenerator();
    @NotNull
    private final Map<List<HttpEnvItem>, String> tokenNameByExistingEnvs = new LinkedHashMap();
    @NotNull
    private final Map<String, String> existingNameBySecret = new LinkedHashMap();

    @Nullable
    public final HttpClientAuth getOauth2(@NotNull List<PostmanAuthAttribute> attributes) {
        HttpClientAuth httpClientAuth;
        String addTokenTo;
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        String string = PostmanAuthProviderKt.findValue$default(attributes, "grant_type", null, 2, null);
        if (string == null) {
            return null;
        }
        String grantType = string;
        String string2 = PostmanAuthProviderKt.findValue$default(attributes, "clientId", null, 2, null);
        if (string2 == null) {
            return null;
        }
        String clientId = string2;
        List variables2 = new ArrayList();
        variables2.add(new HttpEnvItem("Type", "OAuth2", false, 4, null));
        List<HttpEnvItem> envs2 = StringsKt.equals((String)grantType, (String)"authorization_code", (boolean)true) ? this.generateEnvForAuthCodeGrantType(attributes) : (StringsKt.equals((String)grantType, (String)"client_credentials", (boolean)true) ? this.generateEnvForClientCredentialsGrantType(attributes) : (StringsKt.equals((String)grantType, (String)"implicit", (boolean)true) ? this.generateEnvForImplicitGrantType(attributes) : (StringsKt.equals((String)grantType, (String)"password_credentials", (boolean)true) ? this.generateEnvForPasswordGrantType(attributes) : CollectionsKt.emptyList())));
        variables2.addAll((Collection)envs2);
        variables2.add(new HttpEnvItem("Client ID", clientId, false, 4, null));
        ClientAuthentication clientAuthEnv = this.clientAuthentication(attributes);
        variables2.add(new HttpEnvItem("Client Credentials", (String)ArraysKt.first((Object[])clientAuthEnv.getNames()), false, 4, null));
        String string3 = this.tokenNameByExistingEnvs.computeIfAbsent(variables2, arg_0 -> Oauth2AuthProvider.getOauth2$lambda$0((Function1)new Function1<List<? extends HttpEnvItem>, String>(this, attributes){
            final /* synthetic */ Oauth2AuthProvider this$0;
            final /* synthetic */ List<PostmanAuthAttribute> $attributes;
            {
                this.this$0 = $receiver;
                this.$attributes = $attributes;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull List<HttpEnvItem> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                PostmanUniqueNameGenerator postmanUniqueNameGenerator = Oauth2AuthProvider.access$getUniqueNameGenerator$p(this.this$0);
                String string = PostmanAuthProviderKt.findValue$default(this.$attributes, "tokenName", null, 2, null);
                if (string == null) {
                    string = "token";
                }
                return PostmanUniqueNameGenerator.generateUniqueName$default(postmanUniqueNameGenerator, string, false, 2, null);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"computeIfAbsent(...)");
        String tokenName2 = string3;
        HttpAuthEnv securityEnvironment = new HttpAuthEnv(tokenName2, variables2);
        String tokenEnv = PostmanEnvironmentConverterKt.toEnvVariable("$auth.token(\"" + tokenName2 + "\")");
        String string4 = PostmanAuthProviderKt.findValue$default(attributes, "addTokenTo", null, 2, null);
        if (string4 == null) {
            string4 = "header";
        }
        if (Intrinsics.areEqual((Object)(addTokenTo = string4), (Object)"queryParams")) {
            httpClientAuth = new HttpClientAuth.QueryParamAuth(tokenEnv, "access_token", securityEnvironment);
        } else {
            String string5 = PostmanAuthProviderKt.findValue$default(attributes, "headerPrefix", null, 2, null);
            if (string5 == null) {
                string5 = "Bearer";
            }
            String headerPrefix = string5;
            HttpClientHeader header2 = PostmanAuthProviderKt.generateAuthHeader$default(headerPrefix + " " + tokenEnv, null, 2, null);
            httpClientAuth = new HttpClientAuth.HeaderAuth(header2, securityEnvironment);
        }
        return httpClientAuth;
    }

    private final ClientAuthentication clientAuthentication(List<PostmanAuthAttribute> attributes) {
        String string = PostmanAuthProviderKt.findValue$default(attributes, "client_authentication", null, 2, null);
        if (string == null) {
            string = "none";
        }
        String clientAuth = string;
        return StringsKt.equals((String)clientAuth, (String)"header", (boolean)true) ? ClientAuthentication.BASIC : (StringsKt.equals((String)clientAuth, (String)"body", (boolean)true) ? ClientAuthentication.IN_BODY : ClientAuthentication.NONE);
    }

    private final List<HttpEnvItem> generateEnvForAuthCodeGrantType(List<PostmanAuthAttribute> attributes) {
        List envs2 = new ArrayList();
        envs2.add(new HttpEnvItem("Grant Type", "Authorization Code", false, 4, null));
        this.addAuthUrlIfExists(envs2, attributes);
        this.addAccessTokenIfExists(envs2, attributes);
        this.addRedirectUrlIfExists(envs2, attributes);
        envs2.addAll(Oauth2AuthProvider.getSecretsIfExists$default(this, attributes, "clientSecret", "Client Secret", null, 8, null));
        return envs2;
    }

    private final List<HttpEnvItem> generateEnvForClientCredentialsGrantType(List<PostmanAuthAttribute> attributes) {
        List envs2 = new ArrayList();
        envs2.add(new HttpEnvItem("Grant Type", "Client Credentials", false, 4, null));
        Oauth2AuthProviderKt.addIfExists$default(envs2, attributes, "accessTokenUrl", "Token URL", false, 8, null);
        envs2.addAll(Oauth2AuthProvider.getSecretsIfExists$default(this, attributes, "clientSecret", "Client Secret", null, 8, null));
        return envs2;
    }

    private final List<HttpEnvItem> generateEnvForImplicitGrantType(List<PostmanAuthAttribute> attributes) {
        List envs2 = new ArrayList();
        envs2.add(new HttpEnvItem("Grant Type", "Implicit", false, 4, null));
        this.addAuthUrlIfExists(envs2, attributes);
        this.addRedirectUrlIfExists(envs2, attributes);
        return envs2;
    }

    private final List<HttpEnvItem> generateEnvForPasswordGrantType(List<PostmanAuthAttribute> attributes) {
        List envs2 = new ArrayList();
        envs2.add(new HttpEnvItem("Grant Type", "Password", false, 4, null));
        this.addAccessTokenIfExists(envs2, attributes);
        envs2.addAll(Oauth2AuthProvider.getSecretsIfExists$default(this, attributes, "clientSecret", "Client Secret", null, 8, null));
        envs2.addAll((Collection)this.getSecretsIfExists(attributes, "password", "Password", "password"));
        envs2.addAll((Collection)this.getSecretsIfExists(attributes, "username", "Username", "username"));
        return envs2;
    }

    private final List<HttpEnvItem> getSecretsIfExists(List<PostmanAuthAttribute> attributes, String postmanKey, String httpClientKey, String name) {
        List list2;
        String secret = PostmanAuthProviderKt.findValue$default(attributes, postmanKey, null, 2, null);
        if (secret != null) {
            String string = this.existingNameBySecret.computeIfAbsent(secret, arg_0 -> Oauth2AuthProvider.getSecretsIfExists$lambda$1((Function1)new Function1<String, String>(this, name){
                final /* synthetic */ Oauth2AuthProvider this$0;
                final /* synthetic */ String $name;
                {
                    this.this$0 = $receiver;
                    this.$name = $name;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return PostmanUniqueNameGenerator.generateUniqueName$default(Oauth2AuthProvider.access$getUniqueNameGenerator$p(this.this$0), this.$name, false, 2, null);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"computeIfAbsent(...)");
            String secretName2 = string;
            Object[] objectArray = new HttpEnvItem[]{new HttpEnvItem(httpClientKey, PostmanEnvironmentConverterKt.toEnvVariable(secretName2), false, 4, null), new HttpEnvItem(secretName2, secret, true)};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    static /* synthetic */ List getSecretsIfExists$default(Oauth2AuthProvider oauth2AuthProvider2, List list2, String string, String string2, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = "clientSecret";
        }
        return oauth2AuthProvider2.getSecretsIfExists(list2, string, string2, string3);
    }

    private final void addAuthUrlIfExists(List<HttpEnvItem> $this$addAuthUrlIfExists, List<PostmanAuthAttribute> attributes) {
        Oauth2AuthProviderKt.addIfExists$default($this$addAuthUrlIfExists, attributes, "authUrl", "Auth URL", false, 8, null);
    }

    private final void addRedirectUrlIfExists(List<HttpEnvItem> $this$addRedirectUrlIfExists, List<PostmanAuthAttribute> attributes) {
        Oauth2AuthProviderKt.addIfExists$default($this$addRedirectUrlIfExists, attributes, "redirect_uri", "Redirect URL", false, 8, null);
    }

    private final void addAccessTokenIfExists(List<HttpEnvItem> $this$addAccessTokenIfExists, List<PostmanAuthAttribute> attributes) {
        Oauth2AuthProviderKt.addIfExists$default($this$addAccessTokenIfExists, attributes, "accessTokenUrl", "Token URL", false, 8, null);
    }

    private static final String getOauth2$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String getSecretsIfExists$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ PostmanUniqueNameGenerator access$getUniqueNameGenerator$p(Oauth2AuthProvider $this) {
        return $this.uniqueNameGenerator;
    }
}

