/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.postman.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.httpClient.postman.converter.BodyProviderKt;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpClientHeader;
import com.intellij.httpClient.postman.converter.dto.httpClient.HttpClientRequestBody;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanBody;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanFileBody;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanFormDataAttribute;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanFormDataFileSrc;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanModeType;
import com.intellij.httpClient.postman.converter.dto.postman.collection.PostmanUrlEncodedBodyAttribute;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a&\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0016\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0012\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0016\u0010\u0019\u001a\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0011H\u0002\u001a\u0012\u0010\u001c\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a\u0010\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0006\u0010 \u001a\u00020\u0015H\u0002\u001a\f\u0010!\u001a\u00020\"*\u00020\u0018H\u0000\u001a\f\u0010#\u001a\u00020\"*\u00020\u0018H\u0000\u001a\f\u0010$\u001a\u00020\"*\u00020\u0018H\u0000\u001a\f\u0010%\u001a\u00020\"*\u00020\u0018H\u0000\u001a\f\u0010&\u001a\u00020\"*\u00020\u0018H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"BOUNDARY", "", "CONTENT_DISPOSITION", "CONTENT_TYPE", "boundaryView", "name", "fileName", "value", "fileFormBoundaryView", "formAttribute", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanFormDataAttribute$FileFormData;", "getFileBody", "Lcom/intellij/httpClient/postman/converter/dto/httpClient/HttpClientRequestBody;", "file", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanFileBody;", "getFormDataBody", "formData", "", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanFormDataAttribute;", "getGraphqlBody", "graphQl", "Lcom/fasterxml/jackson/databind/JsonNode;", "getRawBody", "postmanBody", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanBody;", "getUrlEncodedBody", "attributes", "Lcom/intellij/httpClient/postman/converter/dto/postman/collection/PostmanUrlEncodedBodyAttribute;", "retrieveBody", "tryToRetrieveFileName", "path", "tryToRetrieveMimeType", "options", "isFile", "", "isFormData", "isGraphql", "isRaw", "isUrlEncoded", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nBodyProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BodyProvider.kt\ncom/intellij/httpClient/postman/converter/BodyProviderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,122:1\n1#2:123\n35#3:124\n*S KotlinDebug\n*F\n+ 1 BodyProvider.kt\ncom/intellij/httpClient/postman/converter/BodyProviderKt\n*L\n65#1:124\n*E\n"})
public final class BodyProviderKt {
    @NotNull
    private static final String CONTENT_TYPE = "Content-Type";
    @NotNull
    private static final String BOUNDARY = "WebAppBoundary";
    @NotNull
    private static final String CONTENT_DISPOSITION = "Content-Disposition: form-data";

    @Nullable
    public static final HttpClientRequestBody retrieveBody(@NotNull PostmanBody postmanBody) {
        HttpClientRequestBody httpClientRequestBody;
        Intrinsics.checkNotNullParameter((Object)postmanBody, (String)"postmanBody");
        if (BodyProviderKt.isRaw(postmanBody)) {
            httpClientRequestBody = BodyProviderKt.getRawBody(postmanBody);
        } else if (BodyProviderKt.isUrlEncoded(postmanBody)) {
            List<PostmanUrlEncodedBodyAttribute> list2 = postmanBody.getUrlencoded();
            if (list2 != null) {
                List<PostmanUrlEncodedBodyAttribute> it = list2;
                boolean bl = false;
                httpClientRequestBody = BodyProviderKt.getUrlEncodedBody(it);
            } else {
                httpClientRequestBody = null;
            }
        } else if (BodyProviderKt.isFormData(postmanBody)) {
            List<PostmanFormDataAttribute> list3 = postmanBody.getFormdata();
            if (list3 != null) {
                List<PostmanFormDataAttribute> it = list3;
                boolean bl = false;
                httpClientRequestBody = BodyProviderKt.getFormDataBody(it);
            } else {
                httpClientRequestBody = null;
            }
        } else if (BodyProviderKt.isFile(postmanBody)) {
            PostmanFileBody postmanFileBody = postmanBody.getFile();
            if (postmanFileBody != null) {
                PostmanFileBody it = postmanFileBody;
                boolean bl = false;
                httpClientRequestBody = BodyProviderKt.getFileBody(it);
            } else {
                httpClientRequestBody = null;
            }
        } else if (BodyProviderKt.isGraphql(postmanBody)) {
            JsonNode jsonNode = postmanBody.getGraphql();
            if (jsonNode != null) {
                JsonNode it = jsonNode;
                boolean bl = false;
                httpClientRequestBody = BodyProviderKt.getGraphqlBody(it);
            } else {
                httpClientRequestBody = null;
            }
        } else {
            httpClientRequestBody = null;
        }
        return httpClientRequestBody;
    }

    public static final boolean isRaw(@NotNull PostmanBody $this$isRaw) {
        Intrinsics.checkNotNullParameter((Object)$this$isRaw, (String)"<this>");
        return $this$isRaw.getMode() == PostmanModeType.raw || $this$isRaw.getRaw() != null;
    }

    public static final boolean isUrlEncoded(@NotNull PostmanBody $this$isUrlEncoded) {
        Intrinsics.checkNotNullParameter((Object)$this$isUrlEncoded, (String)"<this>");
        return $this$isUrlEncoded.getMode() == PostmanModeType.urlencoded || $this$isUrlEncoded.getUrlencoded() != null;
    }

    public static final boolean isFormData(@NotNull PostmanBody $this$isFormData) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)$this$isFormData, (String)"<this>");
        return $this$isFormData.getMode() == PostmanModeType.formdata || !((collection = (Collection)$this$isFormData.getFormdata()) == null || collection.isEmpty());
    }

    public static final boolean isFile(@NotNull PostmanBody $this$isFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isFile, (String)"<this>");
        return $this$isFile.getMode() == PostmanModeType.file || $this$isFile.getFile() != null;
    }

    public static final boolean isGraphql(@NotNull PostmanBody $this$isGraphql) {
        Intrinsics.checkNotNullParameter((Object)$this$isGraphql, (String)"<this>");
        return $this$isGraphql.getMode() == PostmanModeType.graphql || $this$isGraphql.getGraphql() != null;
    }

    private static final HttpClientRequestBody getRawBody(PostmanBody postmanBody) {
        HttpClientHeader httpClientHeader;
        String raw;
        block7: {
            block4: {
                Object object;
                block6: {
                    block5: {
                        String string = postmanBody.getRaw();
                        if (string == null) {
                            return null;
                        }
                        raw = string;
                        if (!(((CharSequence)raw).length() > 0)) break block4;
                        object = postmanBody.getOptions();
                        if (object == null) break block5;
                        JsonNode it = object;
                        boolean bl = false;
                        String string2 = BodyProviderKt.tryToRetrieveMimeType(it);
                        object = string2;
                        if (string2 != null) break block6;
                    }
                    object = "text/plain";
                }
                Object mimeType = object;
                httpClientHeader = new HttpClientHeader(CONTENT_TYPE, (String)mimeType, false, null, 12, null);
                break block7;
            }
            httpClientHeader = null;
        }
        HttpClientHeader header2 = httpClientHeader;
        return new HttpClientRequestBody(header2, raw);
    }

    private static final String tryToRetrieveMimeType(JsonNode options) {
        JsonNode jsonNode = options.get("raw").get("language");
        if (jsonNode == null) {
            return null;
        }
        JsonNode language = jsonNode;
        if (!language.isTextual()) {
            return null;
        }
        String langValue = language.textValue();
        if (!Intrinsics.areEqual((Object)langValue, (Object)"json")) {
            return null;
        }
        return "application/json";
    }

    /*
     * WARNING - void declaration
     */
    private static final HttpClientRequestBody getGraphqlBody(JsonNode graphQl) {
        String string;
        void condition$iv;
        String body2;
        JsonNode jsonNode = graphQl.get("query");
        if (jsonNode == null) {
            return null;
        }
        JsonNode query = jsonNode;
        JsonNode variables2 = graphQl.get("variables");
        String string2 = body2 = query.textValue();
        CharSequence charSequence = variables2.textValue();
        boolean bl = !(charSequence == null || charSequence.length() == 0);
        boolean $i$f$applyIf = false;
        if (condition$iv != false) {
            void $this$getGraphqlBody_u24lambda_u245 = $this$applyIf$iv;
            boolean bl2 = false;
            string = (String)$this$getGraphqlBody_u24lambda_u245 + "\n\n" + variables2.textValue();
        } else {
            string = $this$applyIf$iv;
        }
        void resultBody = string;
        Intrinsics.checkNotNull((Object)resultBody);
        return new HttpClientRequestBody(null, (String)resultBody, 1, null);
    }

    private static final HttpClientRequestBody getFileBody(PostmanFileBody file) {
        HttpClientHeader httpClientHeader;
        String string = file.getSrc();
        if (string == null) {
            return null;
        }
        String src = string;
        Path path2 = Paths.get(src, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path path3 = path2;
        String string2 = Files.probeContentType(path3);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            httpClientHeader = new HttpClientHeader(CONTENT_TYPE, it, false, null, 12, null);
        } else {
            httpClientHeader = null;
        }
        HttpClientHeader header2 = httpClientHeader;
        return new HttpClientRequestBody(header2, "< " + src);
    }

    private static final HttpClientRequestBody getFormDataBody(List<? extends PostmanFormDataAttribute> formData) {
        HttpClientHeader header2 = new HttpClientHeader(CONTENT_TYPE, "multipart/form-data; boundary=WebAppBoundary", false, null, 12, null);
        String boundary = "--WebAppBoundary";
        String body2 = CollectionsKt.joinToString$default((Iterable)formData, (CharSequence)("\n" + boundary + "\n"), (CharSequence)(boundary + "\n"), (CharSequence)("\n" + boundary), (int)0, null, (Function1)getFormDataBody.body.1.INSTANCE, (int)24, null);
        return new HttpClientRequestBody(header2, body2);
    }

    private static final String fileFormBoundaryView(PostmanFormDataAttribute.FileFormData formAttribute) {
        String string;
        PostmanFormDataFileSrc src = formAttribute.getSrc();
        if (src instanceof PostmanFormDataFileSrc.StringSrc) {
            string = ((PostmanFormDataFileSrc.StringSrc)src).getValue();
        } else if (src instanceof PostmanFormDataFileSrc.ListSrc) {
            Iterable iterable = ((PostmanFormDataFileSrc.ListSrc)src).getValue();
            String string2 = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
            string = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, (Function1)fileFormBoundaryView.path.1.INSTANCE, (int)30, null);
        } else {
            string = "Unknown";
        }
        String path2 = string;
        return BodyProviderKt.boundaryView(formAttribute.getKey(), BodyProviderKt.tryToRetrieveFileName(path2), "< " + path2);
    }

    private static final String tryToRetrieveFileName(String path2) {
        String string;
        try {
            Path path3 = Paths.get(path2, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
            Path path4 = path3.getFileName();
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"getFileName(...)");
            string = PathsKt.getName((Path)path4);
        }
        catch (InvalidPathException e) {
            String string2 = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
            string = StringsKt.substringAfterLast$default((String)path2, (String)string2, null, (int)2, null);
        }
        return string;
    }

    private static final String boundaryView(String name, String fileName, String value2) {
        Object object;
        block3: {
            String contentDisposition;
            block2: {
                contentDisposition = "Content-Disposition: form-data; name=\"" + name + "\"";
                object = fileName;
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = contentDisposition + "; filename=\"" + it + "\"";
                object = string;
                if (string != null) break block3;
            }
            object = contentDisposition;
        }
        Object contentDispositionValue = object;
        return (String)contentDispositionValue + "\n\n" + value2;
    }

    static /* synthetic */ String boundaryView$default(String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return BodyProviderKt.boundaryView(string, string2, string3);
    }

    private static final HttpClientRequestBody getUrlEncodedBody(List<PostmanUrlEncodedBodyAttribute> attributes) {
        HttpClientHeader header2 = new HttpClientHeader(CONTENT_TYPE, "application/x-www-form-urlencoded", false, null, 12, null);
        String body2 = CollectionsKt.joinToString$default((Iterable)attributes, (CharSequence)"&", null, null, (int)0, null, (Function1)getUrlEncodedBody.body.1.INSTANCE, (int)30, null);
        return new HttpClientRequestBody(header2, body2);
    }

    public static final /* synthetic */ String access$fileFormBoundaryView(PostmanFormDataAttribute.FileFormData formAttribute) {
        return BodyProviderKt.fileFormBoundaryView(formAttribute);
    }
}

