/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.microservices.actions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.httpClient.RestClientIcons;
import com.intellij.httpClient.actions.generation.HttpRequestGenerationManager;
import com.intellij.httpClient.actions.generation.HttpRequestPresentableError;
import com.intellij.httpClient.actions.generation.HttpRequestUrlPathInfo;
import com.intellij.httpClient.actions.generation.HttpRequestUrlsGenerationRequest;
import com.intellij.httpClient.actions.generation.RequestUrlContextInfo;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.executor.util.PartialResult;
import com.intellij.httpClient.executor.util.ResultsKt;
import com.intellij.httpClient.http.request.HttpRequestLanguage;
import com.intellij.httpClient.http.request.microservices.HttpRequestMicroservicesUtil;
import com.intellij.httpClient.microservices.actions.OpenInHttpClientIntention;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPathReference;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\nH\u0016J\u001d\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0002\u0010\u001cJ#\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0002J\"\u0010#\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010$\u001a\u00020\u00062\b\u0010%\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010&\u001a\u00020\u0006H\u0016\u00a8\u0006("}, d2={"Lcom/intellij/httpClient/microservices/actions/OpenInHttpClientIntention;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "Lcom/intellij/openapi/util/Iconable;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "checkFile", "", "file", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "", "getIcon", "Ljavax/swing/Icon;", "flags", "", "getSuspectReferences", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "getText", "getUrlPathReference", "Lcom/intellij/microservices/url/references/UrlPathReference;", "references", "([Lcom/intellij/psi/PsiReference;)Lcom/intellij/microservices/url/references/UrlPathReference;", "getWebReference", "Lcom/intellij/openapi/paths/WebReference;", "([Lcom/intellij/psi/PsiReference;)Lcom/intellij/openapi/paths/WebReference;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "isSuitableWebReference", "webReference", "startInWriteAction", "Manager", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nOpenInHttpClientIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenInHttpClientIntention.kt\ncom/intellij/httpClient/microservices/actions/OpenInHttpClientIntention\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n179#2,2:155\n26#3:157\n4098#4,11:158\n4098#4,11:170\n1#5:169\n*S KotlinDebug\n*F\n+ 1 OpenInHttpClientIntention.kt\ncom/intellij/httpClient/microservices/actions/OpenInHttpClientIntention\n*L\n58#1:155,2\n59#1:157\n64#1:158,11\n70#1:170,11\n*E\n"})
public final class OpenInHttpClientIntention
extends PsiElementBaseIntentionAction
implements Iconable,
HighPriorityAction {
    @NotNull
    public String getText() {
        String string = RestClientBundle.message("http.request.generate.request.in.http.client.action.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = RestClientBundle.message("http.request.generate.request.in.http.client.action.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = RestClientIcons.Http_requests_filetype;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Http_requests_filetype");
        return icon;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean checkFile(@Nullable PsiFile file) {
        return file != null && !Intrinsics.areEqual((Object)file.getLanguage(), (Object)((Object)HttpRequestLanguage.INSTANCE));
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiReference[] references = this.getSuspectReferences(element);
        WebReference webReference = this.getWebReference(references);
        return this.isSuitableWebReference(webReference, project) || this.getUrlPathReference(references) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSuitableWebReference(WebReference webReference, Project project) {
        if (webReference == null) return false;
        if (!webReference.isHttpRequestTarget()) return false;
        String string = webReference.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        if (((Collection)ResultsKt.unwrapSuccess((Iterable)Manager.INSTANCE.generationRequestsFromUrl(project, string))).isEmpty()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final PsiReference[] getSuspectReferences(PsiElement element) {
        PsiReference[] psiReferenceArray;
        PsiReference[] psiReferenceArray2;
        Object v0;
        block3: {
            void $this$firstOrNull$iv;
            Sequence sequence = SequencesKt.take((Sequence)PsiTreeUtilKt.parents((PsiElement)element, (boolean)true), (int)3);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!WebReference.isWebReferenceWorthy((PsiElement)it)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        PsiElement psiElement = v0;
        PsiReference[] psiReferenceArray3 = psiReferenceArray2 = psiElement != null ? psiElement.getReferences() : null;
        if (psiReferenceArray2 == null) {
            boolean $i$f$emptyArray = false;
            psiReferenceArray = new PsiReference[]{};
        } else {
            psiReferenceArray = psiReferenceArray2;
        }
        return psiReferenceArray;
    }

    /*
     * WARNING - void declaration
     */
    private final UrlPathReference getUrlPathReference(PsiReference[] references) {
        Object v0;
        block2: {
            void $this$filterIsInstanceTo$iv$iv;
            PsiReference[] $this$filterIsInstance$iv = references;
            boolean $i$f$filterIsInstance = false;
            PsiReference[] psiReferenceArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof UrlPathReference)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable = (List)destination$iv$iv;
            for (Object e : iterable) {
                UrlPathReference it = (UrlPathReference)e;
                boolean bl = false;
                if (!it.isAtEnd()) continue;
                v0 = e;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final WebReference getWebReference(PsiReference[] references) {
        void $this$filterIsInstanceTo$iv$iv;
        PsiReference[] $this$filterIsInstance$iv = references;
        boolean $i$f$filterIsInstance = false;
        PsiReference[] psiReferenceArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof WebReference)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (WebReference)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element) {
        List<PartialResult<HttpRequestUrlsGenerationRequest, HttpRequestPresentableError>> list2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (editor2 == null) {
            return;
        }
        PsiReference[] references = this.getSuspectReferences(element);
        UrlPathReference urlPathReference = this.getUrlPathReference(references);
        if (urlPathReference != null) {
            UrlPathContext urlPathContext = urlPathReference.getContext();
            list2 = HttpRequestMicroservicesUtil.generationRequestsFromUrlPathContext(project, urlPathContext);
        } else {
            WebReference webReference = this.getWebReference(references);
            if (webReference == null) {
                return;
            }
            WebReference webReference2 = webReference;
            String string = webReference2.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            list2 = Manager.INSTANCE.generationRequestsFromUrl(project, string);
        }
        List<PartialResult<HttpRequestUrlsGenerationRequest, HttpRequestPresentableError>> requestsInfo = list2;
        Manager.INSTANCE.generateRequests$intellij_restClient(requestsInfo, project, editor2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0003\u001a\u00020\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ(\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J.\u0010\u0012\u001a \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0013\u0012\u0004\u0012\u00020\u00140\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0015\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\t0\u0016H\u0003\u00a8\u0006\u0018"}, d2={"Lcom/intellij/httpClient/microservices/actions/OpenInHttpClientIntention$Manager;", "", "()V", "generateRequests", "", "requestsInfo", "", "Lcom/intellij/httpClient/executor/util/PartialResult;", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlsGenerationRequest;", "Lcom/intellij/httpClient/actions/generation/HttpRequestPresentableError;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "generateRequests$intellij_restClient", "generationRequestsFromUrl", "url", "", "parseWebReference", "Lkotlin/Triple;", "Lcom/intellij/httpClient/microservices/actions/OpenInHttpClientIntention$Manager$WebReferenceParseError;", "concatErrors", "", "WebReferenceParseError", "intellij.restClient"})
    @SourceDebugExtension(value={"SMAP\nOpenInHttpClientIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenInHttpClientIntention.kt\ncom/intellij/httpClient/microservices/actions/OpenInHttpClientIntention$Manager\n+ 2 Results.kt\ncom/intellij/httpClient/executor/util/ResultsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n50#2,2:155\n50#2,5:157\n52#2:162\n50#2,5:163\n53#2,2:168\n288#3,2:170\n1#4:172\n*S KotlinDebug\n*F\n+ 1 OpenInHttpClientIntention.kt\ncom/intellij/httpClient/microservices/actions/OpenInHttpClientIntention$Manager\n*L\n117#1:155,2\n119#1:157,5\n117#1:162\n119#1:163,5\n117#1:168,2\n131#1:170,2\n*E\n"})
    public static final class Manager {
        @NotNull
        public static final Manager INSTANCE = new Manager();

        private Manager() {
        }

        public final void generateRequests$intellij_restClient(@NotNull List<? extends PartialResult<HttpRequestUrlsGenerationRequest, ? extends HttpRequestPresentableError>> requestsInfo, @NotNull Project project, @NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter(requestsInfo, (String)"requestsInfo");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            List<HttpRequestUrlsGenerationRequest> requests2 = ResultsKt.unwrapSuccess((Iterable)requestsInfo);
            if (!((Collection)requests2).isEmpty()) {
                new HttpRequestGenerationManager(project).generateRequestsInHttpEditor(requests2);
            } else {
                String messageContent = this.concatErrors(ResultsKt.unwrapErrors((Iterable)requestsInfo));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)messageContent, (String)RestClientBundle.message("http.request.open.in.http.client.intention.error.title", new Object[0]), null);
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NotNull
        public final List<PartialResult<HttpRequestUrlsGenerationRequest, HttpRequestPresentableError>> generationRequestsFromUrl(@NotNull Project project, @NotNull String url) {
            PartialResult partialResult;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            PartialResult $this$flatMap$iv = this.parseWebReference(url);
            boolean $i$f$flatMap = false;
            PartialResult partialResult2 = $this$flatMap$iv;
            if (partialResult2 instanceof PartialResult.Success) {
                void $this$flatMap$iv2;
                Triple triple = (Triple)((PartialResult.Success)$this$flatMap$iv).getResult();
                boolean bl = false;
                String scheme = (String)triple.component1();
                String authority = (String)triple.component2();
                String urlPath = (String)triple.component3();
                PartialResult partialResult3 = HttpRequestUrlPathInfo.Companion.create$default(HttpRequestUrlPathInfo.Companion, project, urlPath, CollectionsKt.listOf((Object)"GET"), null, 8, null);
                boolean $i$f$flatMap2 = false;
                void var14_20 = $this$flatMap$iv2;
                if (var14_20 instanceof PartialResult.Success) {
                    HttpRequestUrlPathInfo urlInfo = (HttpRequestUrlPathInfo)((PartialResult.Success)$this$flatMap$iv2).getResult();
                    boolean bl2 = false;
                    partialResult = RequestUrlContextInfo.Companion.create(project, CollectionsKt.listOf((Object)scheme), CollectionsKt.listOf((Object)authority)).map((Function1)new Function1<RequestUrlContextInfo, HttpRequestUrlsGenerationRequest>(urlInfo){
                        final /* synthetic */ HttpRequestUrlPathInfo $urlInfo;
                        {
                            this.$urlInfo = $urlInfo;
                            super(1);
                        }

                        @NotNull
                        public final HttpRequestUrlsGenerationRequest invoke(@NotNull RequestUrlContextInfo context) {
                            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                            return new HttpRequestUrlsGenerationRequest(CollectionsKt.listOf((Object)this.$urlInfo), context);
                        }
                    });
                } else if (var14_20 instanceof PartialResult.PartialSuccess) {
                    HttpRequestUrlPathInfo urlInfo = (HttpRequestUrlPathInfo)((PartialResult.PartialSuccess)$this$flatMap$iv2).getResult();
                    boolean bl3 = false;
                    partialResult = RequestUrlContextInfo.Companion.create(project, CollectionsKt.listOf((Object)scheme), CollectionsKt.listOf((Object)authority)).map((Function1)new /* invalid duplicate definition of identical inner class */);
                } else {
                    if (!(var14_20 instanceof PartialResult.Error)) throw new NoWhenBranchMatchedException();
                    partialResult = $this$flatMap$iv2;
                }
            } else if (partialResult2 instanceof PartialResult.PartialSuccess) {
                Triple triple = (Triple)((PartialResult.PartialSuccess)$this$flatMap$iv).getResult();
                boolean bl = false;
                String scheme = (String)triple.component1();
                String authority = (String)triple.component2();
                String urlPath = (String)triple.component3();
                PartialResult $this$flatMap$iv2 = HttpRequestUrlPathInfo.Companion.create$default(HttpRequestUrlPathInfo.Companion, project, urlPath, CollectionsKt.listOf((Object)"GET"), null, 8, null);
                boolean $i$f$flatMap3 = false;
                PartialResult partialResult4 = $this$flatMap$iv2;
                if (partialResult4 instanceof PartialResult.Success) {
                    HttpRequestUrlPathInfo urlInfo = (HttpRequestUrlPathInfo)((PartialResult.Success)$this$flatMap$iv2).getResult();
                    boolean bl4 = false;
                    partialResult = RequestUrlContextInfo.Companion.create(project, CollectionsKt.listOf((Object)scheme), CollectionsKt.listOf((Object)authority)).map((Function1)new /* invalid duplicate definition of identical inner class */);
                } else if (partialResult4 instanceof PartialResult.PartialSuccess) {
                    HttpRequestUrlPathInfo urlInfo = (HttpRequestUrlPathInfo)((PartialResult.PartialSuccess)$this$flatMap$iv2).getResult();
                    boolean bl5 = false;
                    partialResult = RequestUrlContextInfo.Companion.create(project, CollectionsKt.listOf((Object)scheme), CollectionsKt.listOf((Object)authority)).map((Function1)new /* invalid duplicate definition of identical inner class */);
                } else {
                    if (!(partialResult4 instanceof PartialResult.Error)) throw new NoWhenBranchMatchedException();
                    partialResult = $this$flatMap$iv2;
                }
            } else {
                if (!(partialResult2 instanceof PartialResult.Error)) throw new NoWhenBranchMatchedException();
                partialResult = $this$flatMap$iv;
            }
            PartialResult generationRequest2 = partialResult;
            return CollectionsKt.listOf(generationRequest2);
        }

        private final PartialResult<Triple<String, String, String>, WebReferenceParseError> parseWebReference(String url) {
            String[] stringArray;
            Object v0;
            block4: {
                Iterable $this$firstOrNull$iv = UrlConstants.HTTP_SCHEMES;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)url, (String)it, (boolean)false, (int)2, null)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            String string = v0;
            if (string == null) {
                String string2 = RestClientBundle.message("http.request.open.in.http.client.intention.web.reference.scheme.error.message", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                return new PartialResult.Error<WebReferenceParseError>(new WebReferenceParseError(string2));
            }
            String scheme = string;
            String[] it = stringArray = StringsKt.removePrefix((String)url, (CharSequence)scheme);
            boolean bl = false;
            Object object = !(((CharSequence)it).length() == 0) ? stringArray : null;
            if (object == null) {
                String string3 = RestClientBundle.message("http.request.open.in.http.client.intention.web.reference.authority.error.message", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                return new PartialResult.Error<WebReferenceParseError>(new WebReferenceParseError(string3));
            }
            String[] withoutPrefix = object;
            stringArray = new String[]{"/"};
            List parsedWebReference = StringsKt.split$default((CharSequence)((CharSequence)withoutPrefix), (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            Object e = parsedWebReference.get(0);
            String string4 = (String)CollectionsKt.getOrNull((List)parsedWebReference, (int)1);
            if (string4 == null) {
                string4 = "";
            }
            return new PartialResult.Success<Triple>(new Triple((Object)scheme, e, (Object)string4));
        }

        @NlsSafe
        private final String concatErrors(Iterable<? extends HttpRequestPresentableError> $this$concatErrors) {
            return CollectionsKt.joinToString$default($this$concatErrors, (CharSequence)"\n", null, null, (int)0, null, (Function1)concatErrors.1.INSTANCE, (int)30, null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/httpClient/microservices/actions/OpenInHttpClientIntention$Manager$WebReferenceParseError;", "Lcom/intellij/httpClient/actions/generation/HttpRequestPresentableError;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "intellij.restClient"})
        private static final class WebReferenceParseError
        implements HttpRequestPresentableError {
            @NotNull
            private final String message;

            public WebReferenceParseError(@NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                this.message = message2;
            }

            @Override
            @NotNull
            public String getMessage() {
                return this.message;
            }
        }
    }
}

