/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.injection.http.request;

import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpMessageBody;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestContentDescriptor;
import com.intellij.httpClient.http.request.psi.HttpRequestMessagesGroup;
import com.intellij.httpClient.injection.http.request.HttpClientCustomBodyInjector;
import com.intellij.httpClient.injection.http.request.ImplicitMimeTypeProvider;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class HttpRequestBodyInjector
implements MultiHostInjector {
    private static final List<Class<? extends HttpRequestMessagesGroup>> INJECTION_CONTEXT = Collections.singletonList(HttpRequestMessagesGroup.class);

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            HttpRequestBodyInjector.$$$reportNull$$$0(0);
        }
        if (context == null) {
            HttpRequestBodyInjector.$$$reportNull$$$0(1);
        }
        if (context instanceof HttpRequestMessagesGroup) {
            Language language;
            HttpRequest httpRequest = (HttpRequest)PsiTreeUtil.getParentOfType((PsiElement)context, HttpRequest.class);
            if (httpRequest != null) {
                List<HttpClientCustomBodyInjector> bodyInjectors = HttpClientCustomBodyInjector.Companion.findAllApplicable(httpRequest);
                for (HttpClientCustomBodyInjector bodyInjector : bodyInjectors) {
                    bodyInjector.provideInjection(registrar, (HttpRequestMessagesGroup)context);
                }
            }
            if ((language = HttpRequestBodyInjector.getInjectedLanguage(context)) == null) {
                return;
            }
            List<HttpMessageBody> messages = ((HttpRequestMessagesGroup)context).getRequestMessageList().stream().filter(message2 -> message2 instanceof HttpMessageBody && message2.getTextLength() > 0).map(message2 -> (HttpMessageBody)message2).toList();
            if (!messages.isEmpty()) {
                MultiHostRegistrar injector = registrar.startInjecting(language);
                HttpRequestVariableSubstitutor substitutor2 = HttpRequestVariableSubstitutor.getDefault(context.getProject(), context.getContainingFile());
                for (int i = 0; i < messages.size(); ++i) {
                    HttpMessageBody message3 = messages.get(i);
                    String messageBody = message3.getText();
                    HttpRequestBodyInjector.injectBody(injector, substitutor2, message3, messageBody, i == messages.size() - 1 ? null : "\n", 0);
                }
                injector.doneInjecting();
            }
        }
    }

    public static void injectBody(@NotNull MultiHostRegistrar injector, @NotNull HttpRequestVariableSubstitutor substitutor2, @NotNull HttpMessageBody message2, @NotNull String messageText, @NonNls @Nullable String suffix, int messageOffset) {
        if (injector == null) {
            HttpRequestBodyInjector.$$$reportNull$$$0(2);
        }
        if (substitutor2 == null) {
            HttpRequestBodyInjector.$$$reportNull$$$0(3);
        }
        if (message2 == null) {
            HttpRequestBodyInjector.$$$reportNull$$$0(4);
        }
        if (messageText == null) {
            HttpRequestBodyInjector.$$$reportNull$$$0(5);
        }
        int lastVariableRangeEndOffset = 0;
        for (TextRange variableRange : HttpRequestPsiUtils.collectVariablesRangesInMessageBody(messageText)) {
            String variableName = HttpRequestPsiUtils.getVariableExpressionRange(messageText, variableRange).substring(messageText);
            TextRange range = TextRange.create((int)lastVariableRangeEndOffset, (int)variableRange.getStartOffset());
            injector.addPlace(null, substitutor2.getVariableValue(variableName, variableName, message2.getProject(), null), (PsiLanguageInjectionHost)message2, range.shiftRight(messageOffset));
            lastVariableRangeEndOffset = variableRange.getEndOffset();
        }
        TextRange range = TextRange.create((int)lastVariableRangeEndOffset, (int)messageText.length());
        injector.addPlace(null, suffix, (PsiLanguageInjectionHost)message2, range.shiftRight(messageOffset));
    }

    @Nullable
    private static Language getInjectedLanguage(@NotNull PsiElement context) {
        if (context == null) {
            HttpRequestBodyInjector.$$$reportNull$$$0(6);
        }
        HttpRequestContentDescriptor descriptor = (HttpRequestContentDescriptor)PsiTreeUtil.getParentOfType((PsiElement)context, HttpRequestContentDescriptor.class);
        String mimeType = null;
        if (descriptor != null) {
            mimeType = descriptor.getMimeType();
        }
        if (mimeType == null) {
            HttpRequest httpRequest = (HttpRequest)PsiTreeUtil.getParentOfType((PsiElement)context, HttpRequest.class);
            if (httpRequest == null) {
                return null;
            }
            for (ImplicitMimeTypeProvider provider : ImplicitMimeTypeProvider.EP_NAME.getExtensionList()) {
                String providedType = provider.getRequestPayloadMimeType(httpRequest);
                if (providedType == null) continue;
                mimeType = providedType;
                break;
            }
        }
        return HttpRequestBodyInjector.getLanguageByMimeType(mimeType);
    }

    @Nullable
    static Language getLanguageByMimeType(@Nullable String mimeType) {
        if (mimeType == null) {
            return null;
        }
        if (mimeType.endsWith("+json")) {
            mimeType = "application/json";
        }
        return (Language)ContainerUtil.getFirstItem((Collection)Language.findInstancesByMimeType((String)mimeType));
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<? extends HttpRequestMessagesGroup>> list2 = INJECTION_CONTEXT;
        if (list2 == null) {
            HttpRequestBodyInjector.$$$reportNull$$$0(7);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/injection/http/request/HttpRequestBodyInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/injection/http/request/HttpRequestBodyInjector";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "injectBody";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedLanguage";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

