/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.variables;

import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpVariableNameInfo;
import com.intellij.httpClient.http.request.psi.HttpFileVariable;
import com.intellij.httpClient.http.request.psi.HttpFileVariableValue;
import com.intellij.httpClient.http.request.variables.HttpClientFileVariableStorage;
import com.intellij.httpClient.http.request.variables.HttpSingleVariableSubstitutionInfo;
import com.intellij.httpClient.http.request.variables.HttpVariableOrigin;
import com.intellij.httpClient.http.request.variables.HttpVariableSubstitutionInfo;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bp\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013J\b\u0010\u0002\u001a\u00020\u0000H&J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\nH&J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH&\u0082\u0001\u0002\u0014\u0015\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0016\u00c0\u0006\u0001"}, d2={"Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider;", "", "clone", "getFileVariableValue", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value;", "name", "", "unambiguous", "", "valueComputer", "Lkotlin/Function1;", "Lcom/intellij/httpClient/http/request/psi/HttpFileVariable;", "getVariablesSubstitutions", "", "Lcom/intellij/httpClient/http/request/variables/HttpVariableSubstitutionInfo;", "names", "Lcom/intellij/httpClient/http/request/HttpVariableNameInfo;", "Empty", "FileBased", "Value", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Empty;", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$FileBased;", "intellij.httpClient.executor"})
public interface HttpFileVariablesProvider {
    @NotNull
    public Value getFileVariableValue(@NotNull String var1, boolean var2, @NotNull Function1<? super HttpFileVariable, String> var3);

    @NotNull
    public List<HttpVariableSubstitutionInfo> getVariablesSubstitutions(@NotNull List<HttpVariableNameInfo> var1);

    @NotNull
    public HttpFileVariablesProvider clone();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0001H\u0016J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0\u000eH\u0016J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011H\u0016J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\u0018"}, d2={"Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Empty;", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider;", "()V", "clone", "equals", "", "other", "", "getFileVariableValue", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value;", "name", "", "unambiguous", "valueComputer", "Lkotlin/Function1;", "Lcom/intellij/httpClient/http/request/psi/HttpFileVariable;", "getVariablesSubstitutions", "", "Lcom/intellij/httpClient/http/request/variables/HttpVariableSubstitutionInfo;", "names", "Lcom/intellij/httpClient/http/request/HttpVariableNameInfo;", "hashCode", "", "toString", "intellij.httpClient.executor"})
    public static final class Empty
    implements HttpFileVariablesProvider {
        @NotNull
        public static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        @NotNull
        public Value getFileVariableValue(@NotNull String name, boolean unambiguous, @NotNull Function1<? super HttpFileVariable, String> valueComputer) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(valueComputer, (String)"valueComputer");
            return Value.None.INSTANCE;
        }

        @Override
        @NotNull
        public List<HttpVariableSubstitutionInfo> getVariablesSubstitutions(@NotNull List<HttpVariableNameInfo> names) {
            Intrinsics.checkNotNullParameter(names, (String)"names");
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        public HttpFileVariablesProvider clone() {
            return INSTANCE;
        }

        @NotNull
        public String toString() {
            return "Empty";
        }

        public int hashCode() {
            return 1096454808;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Empty)) {
                return false;
            }
            Empty cfr_ignored_0 = (Empty)other;
            return true;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\u0001H\u0016J,\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u000fH\u0016J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$FileBased;", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider;", "file", "Lcom/intellij/httpClient/http/request/HttpRequestPsiFile;", "(Lcom/intellij/httpClient/http/request/HttpRequestPsiFile;)V", "computedValues", "", "", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value;", "clone", "getFileVariableValue", "name", "unambiguous", "", "valueComputer", "Lkotlin/Function1;", "Lcom/intellij/httpClient/http/request/psi/HttpFileVariable;", "getVariablesSubstitutions", "", "Lcom/intellij/httpClient/http/request/variables/HttpVariableSubstitutionInfo;", "names", "Lcom/intellij/httpClient/http/request/HttpVariableNameInfo;", "intellij.httpClient.executor"})
    @SourceDebugExtension(value={"SMAP\nHttpFileVariablesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpFileVariablesProvider.kt\ncom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$FileBased\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1603#2,9:66\n1855#2:75\n1856#2:77\n1612#2:78\n1#3:76\n*S KotlinDebug\n*F\n+ 1 HttpFileVariablesProvider.kt\ncom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$FileBased\n*L\n50#1:66,9\n50#1:75\n50#1:77\n50#1:78\n50#1:76\n*E\n"})
    public static final class FileBased
    implements HttpFileVariablesProvider {
        @NotNull
        private final HttpRequestPsiFile file;
        @NotNull
        private final Map<String, Value> computedValues;

        public FileBased(@NotNull HttpRequestPsiFile file) {
            Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
            this.file = file;
            this.computedValues = new LinkedHashMap();
        }

        @Override
        @NotNull
        public Value getFileVariableValue(@NotNull String name, boolean unambiguous, @NotNull Function1<? super HttpFileVariable, String> valueComputer) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(valueComputer, (String)"valueComputer");
            if (this.computedValues.containsKey(name)) {
                Value value2 = this.computedValues.get(name);
                Intrinsics.checkNotNull((Object)value2);
                return value2;
            }
            List<HttpFileVariable> variables2 = HttpClientFileVariableStorage.Companion.findVariableIn((PsiFile)this.file, name);
            if (variables2.size() > 1 && unambiguous) {
                this.computedValues.put(name, Value.Ambiguous.INSTANCE);
                return Value.Ambiguous.INSTANCE;
            }
            HttpFileVariable variable2 = (HttpFileVariable)CollectionsKt.firstOrNull(variables2);
            if (variable2 == null) {
                this.computedValues.put(name, Value.None.INSTANCE);
                return Value.None.INSTANCE;
            }
            this.computedValues.put(name, Value.InProgress.INSTANCE);
            Value.Computed value3 = new Value.Computed((String)valueComputer.invoke((Object)variable2));
            this.computedValues.put(name, value3);
            return value3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<HttpVariableSubstitutionInfo> getVariablesSubstitutions(@NotNull List<HttpVariableNameInfo> names) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter(names, (String)"names");
            Iterable $this$mapNotNull$iv = names;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                HttpSingleVariableSubstitutionInfo httpSingleVariableSubstitutionInfo;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                HttpVariableNameInfo name = (HttpVariableNameInfo)element$iv$iv;
                boolean bl2 = false;
                if ((HttpFileVariable)CollectionsKt.firstOrNull(HttpClientFileVariableStorage.Companion.findVariableIn((PsiFile)this.file, name.getName())) == null) {
                    httpSingleVariableSubstitutionInfo = null;
                } else {
                    String string;
                    String string2;
                    HttpFileVariable value2;
                    HttpFileVariableValue httpFileVariableValue = value2.getFileVariableValue();
                    String string3 = string2 = httpFileVariableValue != null ? httpFileVariableValue.getText() : null;
                    if (string3 == null) {
                        string = "";
                    } else {
                        Intrinsics.checkNotNull((Object)string3);
                        string = string2;
                    }
                    httpSingleVariableSubstitutionInfo = new HttpSingleVariableSubstitutionInfo(name, HttpVariableOrigin.FILE, string);
                }
                if (httpSingleVariableSubstitutionInfo == null) continue;
                HttpSingleVariableSubstitutionInfo it$iv$iv = httpSingleVariableSubstitutionInfo;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public HttpFileVariablesProvider clone() {
            return new FileBased(this.file);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u0082\u0001\u0004\u0006\u0007\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value;", "", "Ambiguous", "Computed", "InProgress", "None", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value$Ambiguous;", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value$Computed;", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value$InProgress;", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value$None;", "intellij.httpClient.executor"})
    public static interface Value {

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value$Ambiguous;", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value;", "()V", "intellij.httpClient.executor"})
        public static final class Ambiguous
        implements Value {
            @NotNull
            public static final Ambiguous INSTANCE = new Ambiguous();

            private Ambiguous() {
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value$Computed;", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value;", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "intellij.httpClient.executor"})
        public static final class Computed
        implements Value {
            @NotNull
            private final String value;

            public Computed(@NotNull String value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                this.value = value2;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value$InProgress;", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value;", "()V", "intellij.httpClient.executor"})
        public static final class InProgress
        implements Value {
            @NotNull
            public static final InProgress INSTANCE = new InProgress();

            private InProgress() {
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value$None;", "Lcom/intellij/httpClient/http/request/variables/HttpFileVariablesProvider$Value;", "()V", "intellij.httpClient.executor"})
        public static final class None
        implements Value {
            @NotNull
            public static final None INSTANCE = new None();

            private None() {
            }
        }
    }
}

