/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.searcheverywhere;

import com.intellij.httpClient.RestClientIcons;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestNameSupport;
import com.intellij.httpClient.http.request.HttpRequestPsiFileIdentifiersScope;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.index.HttpRequestNameIndexKt;
import com.intellij.httpClient.http.request.psi.HttpMethod;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.httpClient.http.request.psi.HttpRequestCompositeElement;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0000\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u00020\u00042\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00060\b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/httpClient/http/request/searcheverywhere/HttpRequestChooseByNameContributor;", "Lcom/intellij/navigation/ChooseByNameContributorEx;", "()V", "processElementsWithName", "", "name", "", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/navigation/NavigationItem;", "parameters", "Lcom/intellij/util/indexing/FindSymbolParameters;", "processNames", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "filter", "Lcom/intellij/util/indexing/IdFilter;", "MyNavigationItem", "intellij.restClient"})
public final class HttpRequestChooseByNameContributor
implements ChooseByNameContributorEx {
    public void processNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        FileBasedIndex.getInstance().processAllKeys(HttpRequestNameIndexKt.getHTTP_REQUEST_NAME_INDEX_ID(), processor, scope, filter2);
    }

    public void processElementsWithName(@NotNull String name, @NotNull Processor<? super NavigationItem> processor, @NotNull FindSymbolParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        PsiManager psiManager = PsiManager.getInstance((Project)parameters.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        FileBasedIndex.getInstance().getFilesWithKey(HttpRequestNameIndexKt.getHTTP_REQUEST_NAME_INDEX_ID(), SetsKt.setOf((Object)name), arg_0 -> HttpRequestChooseByNameContributor.processElementsWithName$lambda$0((Function1)new Function1<VirtualFile, Boolean>(psiManager2, name, processor){
            final /* synthetic */ PsiManager $psiManager;
            final /* synthetic */ String $name;
            final /* synthetic */ Processor<? super NavigationItem> $processor;
            {
                this.$psiManager = $psiManager;
                this.$name = $name;
                this.$processor = $processor;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Boolean invoke(VirtualFile file) {
                boolean bl;
                block8: {
                    void $this$all$iv;
                    List list2;
                    List list3;
                    Processor<? super NavigationItem> processor;
                    Object object = this.$psiManager.findFile(file);
                    if (object != null) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        processor = object;
                        String string = this.$name;
                        Processor<? super NavigationItem> psiFile = processor;
                        boolean bl2 = false;
                        HttpRequestPsiFileIdentifiersScope identifierScope = new HttpRequestPsiFileIdentifiersScope((PsiFile)psiFile);
                        HttpRequestBlock[] httpRequestBlockArray = HttpRequestPsiUtils.getRequestBlocks(psiFile);
                        Intrinsics.checkNotNullExpressionValue((Object)httpRequestBlockArray, (String)"getRequestBlocks(...)");
                        Object[] objectArray = httpRequestBlockArray;
                        boolean $i$f$filter = false;
                        void var10_13 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (HttpRequestBlock element$iv$iv : $this$filterTo$iv$iv) {
                            HttpRequestBlock it = element$iv$iv;
                            boolean bl3 = false;
                            HttpRequest httpRequest = it.getRequest();
                            Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"getRequest(...)");
                            if (!Intrinsics.areEqual((Object)HttpRequestNameSupport.getDeclaredName(httpRequest), (Object)string)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            HttpRequestBlock element$iv$iv;
                            element$iv$iv = (HttpRequestBlock)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl4 = false;
                            HttpRequest httpRequest = it.getRequest();
                            Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"getRequest(...)");
                            HttpRequest httpRequest2 = it.getRequest();
                            Intrinsics.checkNotNullExpressionValue((Object)httpRequest2, (String)"getRequest(...)");
                            collection.add(new MyNavigationItem(httpRequest, identifierScope.getIdentifier(httpRequest2)));
                        }
                        list3 = (List)destination$iv$iv;
                    } else {
                        list3 = list2 = null;
                    }
                    if (list3 == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    object = list2;
                    processor = this.$processor;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            MyNavigationItem it = (MyNavigationItem)element$iv;
                            boolean bl5 = false;
                            if (processor.process((Object)it)) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                return bl;
            }
        }, arg_0), parameters.getSearchScope());
    }

    private static final boolean processElementsWithName$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016R\u0018\u0010\u0007\u001a\f0\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0018\u00010\u0005\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/httpClient/http/request/searcheverywhere/HttpRequestChooseByNameContributor$MyNavigationItem;", "Lcom/intellij/navigation/NavigationItem;", "request", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "requestIdentifier", "", "(Lcom/intellij/httpClient/http/request/psi/HttpRequest;Ljava/lang/String;)V", "fileName", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "hostPresentation", "Lorg/jetbrains/annotations/Nullable;", "getRequest", "()Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "getRequestIdentifier", "()Ljava/lang/String;", "canNavigate", "", "canNavigateToSource", "getName", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "navigate", "", "requestFocus", "navigationRequest", "Lcom/intellij/platform/backend/navigation/NavigationRequest;", "intellij.restClient"})
    private static final class MyNavigationItem
    implements NavigationItem {
        @NotNull
        private final HttpRequest request;
        @NotNull
        private final String requestIdentifier;
        @Nullable
        private final String hostPresentation;
        @NotNull
        private final String fileName;

        @RequiresReadLock
        public MyNavigationItem(@NotNull HttpRequest request2, @NotNull String requestIdentifier) {
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            Intrinsics.checkNotNullParameter((Object)requestIdentifier, (String)"requestIdentifier");
            this.request = request2;
            this.requestIdentifier = requestIdentifier;
            this.hostPresentation = this.request.getHttpHost(HttpRequestVariableSubstitutor.withoutAnySubstitution());
            String string = FileUtil.getNameWithoutExtension((String)this.request.getContainingFile().getName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
            this.fileName = string;
        }

        @NotNull
        public final HttpRequest getRequest() {
            return this.request;
        }

        @NotNull
        public final String getRequestIdentifier() {
            return this.requestIdentifier;
        }

        @NotNull
        public String getName() {
            return this.requestIdentifier;
        }

        @NotNull
        public ItemPresentation getPresentation() {
            return new ItemPresentation(this){
                final /* synthetic */ MyNavigationItem this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public String getPresentableText() {
                    String string;
                    String string2;
                    StringBuilder stringBuilder;
                    MyNavigationItem myNavigationItem = this.this$0;
                    StringBuilder $this$getPresentableText_u24lambda_u241 = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    HttpMethod httpMethod = myNavigationItem.getRequest().getMethod();
                    String string3 = string2 = httpMethod != null ? httpMethod.getText() : null;
                    if (string3 == null) {
                        string = "GET";
                    } else {
                        Intrinsics.checkNotNull((Object)string3);
                        string = string2;
                    }
                    $this$getPresentableText_u24lambda_u241.append(string);
                    $this$getPresentableText_u24lambda_u241.append(" ");
                    HttpRequestCompositeElement httpRequestCompositeElement = myNavigationItem.getRequest().getRequestTarget();
                    if (httpRequestCompositeElement != null && (httpRequestCompositeElement = httpRequestCompositeElement.getScheme()) != null) {
                        HttpRequestCompositeElement it = httpRequestCompositeElement;
                        boolean bl2 = false;
                        $this$getPresentableText_u24lambda_u241.append(it.getText());
                        $this$getPresentableText_u24lambda_u241.append("://");
                    }
                    $this$getPresentableText_u24lambda_u241.append(MyNavigationItem.access$getHostPresentation$p(myNavigationItem));
                    String string4 = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                    return string4;
                }

                @NotNull
                public Icon getIcon(boolean unused) {
                    Icon icon = RestClientIcons.Http_requests_filetype;
                    Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Http_requests_filetype");
                    return icon;
                }

                @NotNull
                public String getLocationString() {
                    Object[] objectArray = new Object[]{this.this$0.getRequestIdentifier(), MyNavigationItem.access$getFileName$p(this.this$0)};
                    String string = RestClientBundle.message("http.request.run.anything.element.from.file.name", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return string;
                }
            };
        }

        @Nullable
        public NavigationRequest navigationRequest() {
            return this.request.navigationRequest();
        }

        public void navigate(boolean requestFocus) {
            this.request.navigate(requestFocus);
        }

        public boolean canNavigate() {
            return this.request.canNavigate();
        }

        public boolean canNavigateToSource() {
            return this.request.canNavigateToSource();
        }

        public static final /* synthetic */ String access$getFileName$p(MyNavigationItem $this) {
            return $this.fileName;
        }

        public static final /* synthetic */ String access$getHostPresentation$p(MyNavigationItem $this) {
            return $this.hostPresentation;
        }
    }
}

