/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.js.graalvm.dom.xml;

import com.intellij.httpClient.http.request.run.js.graalvm.dom.xml.XmlSerializerKt;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u001e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0000\u001a\u00020\u0002\u00a8\u0006\b"}, d2={"indent", "", "", "writer", "Ljava/io/StringWriter;", "serializeXml", "node", "Lorg/w3c/dom/Node;", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nXmlSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlSerializer.kt\ncom/intellij/httpClient/http/request/run/js/graalvm/dom/xml/XmlSerializerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1855#2,2:79\n1855#2,2:81\n1#3:83\n*S KotlinDebug\n*F\n+ 1 XmlSerializer.kt\ncom/intellij/httpClient/http/request/run/js/graalvm/dom/xml/XmlSerializerKt\n*L\n31#1:79,2\n39#1:81,2\n*E\n"})
public final class XmlSerializerKt {
    public static final void serializeXml(@NotNull Node node, @NotNull StringWriter writer, int indent) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Node node2 = node;
        if (node2 instanceof Element) {
            XmlSerializerKt.indent(indent, writer);
            writer.append("<" + ((Element)node).getTagName());
            if (node.hasAttributes()) {
                List attributes = new ArrayList();
                Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)((Element)node).getAttributes().getLength());
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int attrIndex = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl = false;
                    Node attr = ((Element)node).getAttributes().item(attrIndex);
                    attributes.add(attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
                }
                writer.append(CollectionsKt.joinToString$default((Iterable)attributes, (CharSequence)" ", (CharSequence)" ", null, (int)0, null, (Function1)serializeXml.2.INSTANCE, (int)28, null));
            }
            if (node.hasChildNodes()) {
                Appendable appendable = ((Appendable)writer).append(">");
                Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
                Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)((Element)node).getChildNodes().getLength());
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int childIndex = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl = false;
                    Node node3 = ((Element)node).getChildNodes().item(childIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"item(...)");
                    XmlSerializerKt.serializeXml(node3, writer, indent + 2);
                }
                XmlSerializerKt.indent(indent, writer);
                Appendable appendable2 = ((Appendable)writer).append("</" + ((Element)node).getTagName() + ">");
                Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)appendable2.append('\n'), (String)"append(...)");
            } else {
                Appendable appendable = ((Appendable)writer).append("/>");
                Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
            }
        } else if (node2 instanceof CDATASection) {
            XmlSerializerKt.indent(indent, writer);
            Appendable appendable = ((Appendable)writer).append("<![CDATA[" + ((CDATASection)node).getData() + "]]>");
            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
        } else if (node2 instanceof Text) {
            String string = ((Text)node).getData();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getData(...)");
            if (StringsKt.isBlank((CharSequence)string)) {
                return;
            }
            XmlSerializerKt.indent(indent, writer);
            Appendable appendable = ((Appendable)writer).append(((Text)node).getTextContent());
            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
        } else if (node2 instanceof Document) {
            Intrinsics.checkNotNullExpressionValue((Object)((Appendable)writer).append('\n'), (String)"append(...)");
            Element element = ((Document)node).getDocumentElement();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getDocumentElement(...)");
            XmlSerializerKt.serializeXml(element, writer, indent);
        } else if (node2 instanceof Comment) {
            XmlSerializerKt.indent(indent, writer);
            Appendable appendable = ((Appendable)writer).append("<!--" + ((Comment)node).getTextContent() + "-->");
            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
        } else if (node2 instanceof Attr) {
            XmlSerializerKt.indent(indent, writer);
            Appendable appendable = ((Appendable)writer).append(((Attr)node).getName() + "=\"" + ((Attr)node).getValue() + "\"");
            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
        } else {
            throw new NotImplementedError(null, 1, null);
        }
    }

    private static final void indent(int indent, StringWriter writer) {
        int n = 0;
        while (n < indent) {
            int it = n++;
            boolean bl = false;
            writer.append(" ");
        }
    }
}

