/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.js.graalvm.dom;

import com.intellij.httpClient.http.request.run.js.graalvm.dom.xml.XmlDomDocument;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/intellij/httpClient/http/request/run/js/graalvm/dom/DOMParser;", "", "()V", "parseFromString", "Lorg/graalvm/polyglot/proxy/ProxyObject;", "xmlString", "", "mimeType", "intellij.httpClient.executor"})
public final class DOMParser {
    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final ProxyObject parseFromString(@NotNull String xmlString, @NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)xmlString, (String)"xmlString");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        switch (mimeType) {
            case "application/xml": 
            case "text/xml": {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder2 = factory.newDocumentBuilder();
                String string = xmlString;
                Charset charset = Charsets.UTF_8;
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                Document document = builder2.parse(new ByteArrayInputStream(byArray));
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
                return new XmlDomDocument(document);
            }
            case "text/html": {
                throw new IllegalStateException("Unsupported type".toString());
            }
            case "application/xhtml+xml": {
                throw new IllegalStateException("Unsupported type".toString());
            }
            case "image/svg+xml": {
                throw new IllegalStateException("Unsupported type".toString());
            }
        }
        throw new IllegalStateException(("invalid mime type: " + mimeType).toString());
    }
}

