/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.console;

import com.intellij.httpClient.execution.common.CommonClientRequest;
import com.intellij.httpClient.execution.common.RequestContext;
import com.intellij.httpClient.execution.common.RequestConverter;
import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.http.request.HttpRequestExecutionEnvironment;
import com.intellij.httpClient.http.request.HttpRequestListVariableSubstitutor;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutorImpl;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.HttpRunRequestInfo;
import com.intellij.httpClient.http.request.run.console.HttpClientConsoleUtilKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a*\u0010\u0000\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u001a\u001c\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a8\u0006\u000f"}, d2={"collectVariablesRanges", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/TextRange;", "", "substitutor", "Lcom/intellij/httpClient/http/request/HttpRequestVariableSubstitutor;", "presentableForm", "getPresentableForm", "info", "Lcom/intellij/httpClient/http/request/run/HttpRunRequestInfo;", "withRequestSeparator", "", "removeRequestSeparator", "externalForm", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientConsoleUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientConsoleUtil.kt\ncom/intellij/httpClient/http/request/run/console/HttpClientConsoleUtilKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n643#2,5:69\n1855#3,2:74\n1002#3,2:76\n1549#3:78\n1620#3,3:79\n*S KotlinDebug\n*F\n+ 1 HttpClientConsoleUtil.kt\ncom/intellij/httpClient/http/request/run/console/HttpClientConsoleUtilKt\n*L\n22#1:69,5\n36#1:74,2\n51#1:76,2\n67#1:78\n67#1:79,3\n*E\n"})
public final class HttpClientConsoleUtilKt {
    @Nullable
    public static final String getPresentableForm(@NotNull HttpRunRequestInfo info, boolean withRequestSeparator) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        String string = info.getRequestMethod();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestMethod(...)");
        RequestExecutionSupport<?> requestExecutionSupport = RequestExecutionSupport.All.forContext(new RequestContext(string, false, info.getRequestScheme()));
        if (requestExecutionSupport == null) {
            return null;
        }
        RequestExecutionSupport<?> support = requestExecutionSupport;
        RequestConverter<?> requestConverter = support.getRequestConverter();
        SmartPsiElementPointer<HttpRequest> smartPsiElementPointer = info.getRequestPointer();
        Intrinsics.checkNotNullExpressionValue(smartPsiElementPointer, (String)"getRequestPointer(...)");
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = info.getVariableSubstitutor();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequestVariableSubstitutor, (String)"getVariableSubstitutor(...)");
        Object commonClientRequest = requestConverter.psiToCommonRequest(smartPsiElementPointer, httpRequestVariableSubstitutor);
        String externalForm = requestConverter.toExternalForm((CommonClientRequest)commonClientRequest, null);
        return !withRequestSeparator ? HttpClientConsoleUtilKt.removeRequestSeparator(externalForm) : externalForm;
    }

    public static /* synthetic */ String getPresentableForm$default(HttpRunRequestInfo httpRunRequestInfo, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return HttpClientConsoleUtilKt.getPresentableForm(httpRunRequestInfo, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final String removeRequestSeparator(String externalForm) {
        String string;
        block1: {
            void var1_1;
            String $this$takeWhile$iv = externalForm;
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it != '#') continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block1;
            }
            string = var1_1;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Pair<TextRange, String>> collectVariablesRanges(@NotNull HttpRequestVariableSubstitutor substitutor2, @NotNull String presentableForm) {
        void $this$mapTo$iv$iv;
        Iterable last;
        List<HttpRequestExecutionEnvironment.VariableInfo> list2;
        Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
        Intrinsics.checkNotNullParameter((Object)presentableForm, (String)"presentableForm");
        List variables2 = new ArrayList();
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = substitutor2;
        if (httpRequestVariableSubstitutor instanceof HttpRequestVariableSubstitutorImpl) {
            List<HttpRequestExecutionEnvironment.VariableInfo> list3 = ((HttpRequestVariableSubstitutorImpl)substitutor2).getEnvironment().getAllVariables();
            list2 = list3;
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getAllVariables(...)");
        } else {
            list2 = httpRequestVariableSubstitutor instanceof HttpRequestListVariableSubstitutor ? ((HttpRequestListVariableSubstitutor)substitutor2).getAllEnvVariables() : CollectionsKt.emptyList();
        }
        List<HttpRequestExecutionEnvironment.VariableInfo> allVariables = list2;
        Iterable $this$forEach$iv = allVariables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HttpRequestExecutionEnvironment.VariableInfo variable2 = (HttpRequestExecutionEnvironment.VariableInfo)element$iv;
            boolean bl = false;
            if (!variable2.isPrivate()) continue;
            String string = variable2.value();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value(...)");
            if (StringsKt.isBlank((CharSequence)string)) continue;
            int index = 0;
            do {
                CharSequence charSequence = presentableForm;
                String string2 = variable2.value();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value(...)");
                index = StringsKt.indexOf$default((CharSequence)charSequence, (String)string2, (int)index, (boolean)false, (int)4, null);
                if (index == -1) continue;
                variables2.add(TuplesKt.to((Object)TextRange.create((int)index, (int)(index + variable2.value().length())), (Object)variable2.name()));
                index += variable2.value().length();
            } while (index != -1);
        }
        List $this$sortBy$iv = variables2;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(((TextRange)it.getFirst()).getStartOffset());
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((TextRange)it.getFirst()).getStartOffset()));
                }
            });
        }
        List collapsedVariables = new ArrayList();
        for (Pair variable3 : variables2) {
            Collection newLast;
            last = (Pair)CollectionsKt.lastOrNull((List)collapsedVariables);
            if (last != null && ((TextRange)last.getFirst()).intersects((TextRange)variable3.getFirst())) {
                ((Collection)last.getSecond()).add(variable3.getSecond());
                newLast = TuplesKt.to((Object)((TextRange)last.getFirst()).union((TextRange)variable3.getFirst()), (Object)last.getSecond());
                CollectionsKt.removeLast((List)collapsedVariables);
                ((Collection)collapsedVariables).add(newLast);
                continue;
            }
            newLast = collapsedVariables;
            Object[] bl = new String[]{variable3.getSecond()};
            newLast.add(TuplesKt.to((Object)variable3.getFirst(), (Object)SetsKt.mutableSetOf((Object[])bl)));
        }
        Iterable $this$map$iv = collapsedVariables;
        boolean $i$f$map = false;
        last = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TextRange range = (TextRange)pair.component1();
            Set names = (Set)pair.component2();
            collection.add(TuplesKt.to((Object)range, (Object)CollectionsKt.joinToString$default((Iterable)names, null, null, null, (int)0, null, (Function1)collectVariablesRanges.3.1.INSTANCE, (int)31, null)));
        }
        return (List)destination$iv$iv;
    }
}

