/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.config;

import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.config.HttpRequestExecutionConfig;
import com.intellij.httpClient.http.request.run.config.HttpRequestRuntimeConfigurationProducer;
import com.intellij.httpClient.http.request.run.config.HttpSingleRequestRuntimeConfigurationProducer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpSingleRequestExecutionConfig
implements HttpRequestExecutionConfig {
    private final SmartPsiElementPointer<HttpRequest> myRequestPointer;
    private final boolean myShowInformationAboutRequest;

    public HttpSingleRequestExecutionConfig(@NotNull HttpRequest request2) {
        if (request2 == null) {
            HttpSingleRequestExecutionConfig.$$$reportNull$$$0(0);
        }
        this(request2, true);
    }

    public HttpSingleRequestExecutionConfig(@NotNull HttpRequest request2, boolean showInformationAboutRequest) {
        if (request2 == null) {
            HttpSingleRequestExecutionConfig.$$$reportNull$$$0(1);
        }
        this.myRequestPointer = SmartPointerManager.createPointer((PsiElement)request2);
        this.myShowInformationAboutRequest = showInformationAboutRequest;
    }

    @Override
    @NotNull
    public List<HttpRequest> getRequests() {
        HttpRequest element = this.getRequest();
        List list2 = ContainerUtil.packNullables((Object[])new HttpRequest[]{element});
        if (list2 == null) {
            HttpSingleRequestExecutionConfig.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    private HttpRequest getRequest() {
        HttpRequest element = (HttpRequest)this.myRequestPointer.getElement();
        if (element == null) {
            throw new HttpRequestExecutionConfig.InvalidConfigException("Request is absent");
        }
        HttpRequest httpRequest = element;
        if (httpRequest == null) {
            HttpSingleRequestExecutionConfig.$$$reportNull$$$0(3);
        }
        return httpRequest;
    }

    @Override
    @NotNull
    public PsiFile getContext() {
        PsiFile psiFile = this.getRequest().getContainingFile();
        if (psiFile == null) {
            HttpSingleRequestExecutionConfig.$$$reportNull$$$0(4);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public String getName(@NotNull HttpRequestVariableSubstitutor substitutor2) {
        if (substitutor2 == null) {
            HttpSingleRequestExecutionConfig.$$$reportNull$$$0(5);
        }
        String string = StringUtil.notNullize((String)this.getRequest().getHttpUrl(substitutor2));
        if (string == null) {
            HttpSingleRequestExecutionConfig.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String getActionDescription(@NotNull @Nls String actionName, @Nullable String env) {
        if (actionName == null) {
            HttpSingleRequestExecutionConfig.$$$reportNull$$$0(7);
        }
        if (StringUtil.isEmpty((String)env)) {
            String string = actionName + " " + StringUtil.notNullize((String)this.getRequest().getHttpHost(HttpRequestVariableSubstitutor.empty()));
            if (string == null) {
                HttpSingleRequestExecutionConfig.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = RestClientBundle.message("rest.client.request.execute.with.environment", actionName, env);
        if (string == null) {
            HttpSingleRequestExecutionConfig.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public HttpRequestRuntimeConfigurationProducer getRuntimeConfigurationProducer() {
        HttpRequestRuntimeConfigurationProducer httpRequestRuntimeConfigurationProducer = (HttpRequestRuntimeConfigurationProducer)RunConfigurationProducer.getInstance(HttpSingleRequestRuntimeConfigurationProducer.class);
        if (httpRequestRuntimeConfigurationProducer == null) {
            HttpSingleRequestExecutionConfig.$$$reportNull$$$0(10);
        }
        return httpRequestRuntimeConfigurationProducer;
    }

    @Override
    public boolean isShowInformationAboutRequest() {
        return this.myShowInformationAboutRequest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/config/HttpSingleRequestExecutionConfig";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/config/HttpSingleRequestExecutionConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequests";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionDescription";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getActionDescription";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

