/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.config;

import com.intellij.DynamicBundle;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.run.config.HttpEnvironmentComboBox;
import com.intellij.httpClient.http.request.run.config.HttpRequestComboBox;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunConfiguration;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestRunConfigurationEditor
extends SettingsEditor<HttpRequestRunConfiguration> {
    private JPanel myMainPanel;
    private JPanel myRequestPanel;
    private TextFieldWithBrowseButton myPathField;
    private HttpEnvironmentComboBox myEnvironmentComboBox;
    private HttpRequestComboBox myRequestNameComboBox;
    private JBLabel myEnvLabel;
    private JBLabel myRequestLabel;
    private JBRadioButton myRunFileRadioButton;
    private JBRadioButton myRunSingleRequestRadioButton;
    private final Project myProject;

    public HttpRequestRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            HttpRequestRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myPathField.addBrowseFolderListener(null, null, project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.myPathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                HttpEnvironmentComboBox.HttpEnvironmentItem env;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                String envName = (env = HttpRequestRunConfigurationEditor.this.myEnvironmentComboBox.getSelectedItem()) != null ? env.getName() : null;
                HttpRequestRunConfigurationEditor.this.updateState(HttpRequestRunConfigurationEditor.this.myPathField.getText(), envName, HttpRequestRunConfigurationEditor.this.myRequestNameComboBox.getSelectedRequestIndex(), HttpRequestRunConfigurationEditor.this.myRequestNameComboBox.getSelectedRequestIdentifier(), HttpRequestRunConfigurationEditor.this.getSelectedRunType());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/httpClient/http/request/run/config/HttpRequestRunConfigurationEditor$1", "textChanged"));
            }
        });
        this.myEnvLabel.setLabelFor((Component)((Object)this.myEnvironmentComboBox));
        this.myRequestLabel.setLabelFor((Component)((Object)this.myRequestNameComboBox));
        this.myRunSingleRequestRadioButton.addItemListener((ItemListener)new RunTypeSelectionButtonItemListener(HttpRequestRunType.SINGLE_REQUEST));
        this.myRunFileRadioButton.addItemListener((ItemListener)new RunTypeSelectionButtonItemListener(HttpRequestRunType.ALL_IN_FILE));
    }

    protected void resetEditorFrom(@NotNull HttpRequestRunConfiguration configuration) {
        if (configuration == null) {
            HttpRequestRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        HttpRequestRunConfiguration.Settings settings = configuration.getSettings();
        this.myPathField.setText(settings.getFilePath());
        this.updateState(settings.getFilePath(), settings.getEnvironment(), settings.getIndex(), settings.getRequestIdentifier(), settings.getRunType());
    }

    private void updateState(@Nullable String path2, @Nullable String env, int index, @Nullable String identifier, @Nullable HttpRequestRunType runType) {
        PsiFile file = HttpRequestRunConfiguration.findFileByPath(this.myProject, path2);
        this.myEnvironmentComboBox.reset(this.myProject, file, env);
        this.setSelectedRunType(runType);
        if (runType != null) {
            this.myRequestPanel.setVisible(runType == HttpRequestRunType.SINGLE_REQUEST);
        }
        if (file instanceof HttpRequestPsiFile) {
            this.myRequestNameComboBox.reset((HttpRequestPsiFile)file, index, identifier);
            this.myRequestNameComboBox.setEnabled(this.myRequestNameComboBox.getModel().getSize() > 1);
        } else {
            this.myRequestNameComboBox.setEnabled(false);
        }
    }

    protected void applyEditorTo(@NotNull HttpRequestRunConfiguration configuration) {
        if (configuration == null) {
            HttpRequestRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        HttpRequestRunConfiguration.Settings settings = configuration.getSettings();
        settings.setFilePath(this.myPathField.getText());
        settings.setIndex(this.myRequestNameComboBox.getSelectedRequestIndex());
        settings.setRunType(this.getSelectedRunType());
        settings.setRequestIdentifier(this.myRequestNameComboBox.getSelectedRequestIdentifier());
        HttpEnvironmentComboBox.HttpEnvironmentItem env = this.myEnvironmentComboBox.getSelectedItem();
        settings.setEnvironment(env == null ? "" : env.getName());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            HttpRequestRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myEnvironmentComboBox = new HttpEnvironmentComboBox((Disposable)this);
        this.myRequestNameComboBox = new HttpRequestComboBox();
        ComboboxSpeedSearch.installSpeedSearch((JComboBox)((Object)this.myRequestNameComboBox), Object::toString);
        this.myRunFileRadioButton = new JBRadioButton(HttpRequestRunType.ALL_IN_FILE.getName());
        this.myRunSingleRequestRadioButton = new JBRadioButton(HttpRequestRunType.SINGLE_REQUEST.getName());
    }

    @Nullable
    private HttpRequestRunType getSelectedRunType() {
        if (this.myRunFileRadioButton.isSelected()) {
            return HttpRequestRunType.ALL_IN_FILE;
        }
        if (this.myRunSingleRequestRadioButton.isSelected()) {
            return HttpRequestRunType.SINGLE_REQUEST;
        }
        return null;
    }

    private void setSelectedRunType(@Nullable HttpRequestRunType runType) {
        if (runType == HttpRequestRunType.ALL_IN_FILE) {
            this.myRunFileRadioButton.setSelected(true);
        } else if (runType == HttpRequestRunType.SINGLE_REQUEST) {
            this.myRunSingleRequestRadioButton.setSelected(true);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JBLabel jBLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/RestClientBundle", HttpRequestRunConfigurationEditor.class).getString("http.request.run.configuration.panel.title"), (int)0, (int)0, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/RestClientBundle", HttpRequestRunConfigurationEditor.class).getString("http.request.run.configuration.file.label"));
        jPanel4.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myEnvLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/RestClientBundle", HttpRequestRunConfigurationEditor.class).getString("http.request.run.configuration.env.label"));
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        HttpEnvironmentComboBox httpEnvironmentComboBox = this.myEnvironmentComboBox;
        jPanel4.add((Component)((Object)httpEnvironmentComboBox), new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myRequestPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myRequestLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/RestClientBundle", HttpRequestRunConfigurationEditor.class).getString("http.request.run.configuration.index.label"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(92, 16), null));
        HttpRequestComboBox httpRequestComboBox = this.myRequestNameComboBox;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        ((JComboBox)((Object)httpRequestComboBox)).setModel(defaultComboBoxModel);
        jPanel.add((Component)((Object)httpRequestComboBox), new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JBRadioButton jBRadioButton = this.myRunFileRadioButton;
        jPanel5.add((Component)jBRadioButton, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        JBRadioButton jBRadioButton2 = this.myRunSingleRequestRadioButton;
        jPanel5.add((Component)jBRadioButton2, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jBLabel3.setLabelFor((Component)textFieldWithBrowseButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton);
        buttonGroup.add((AbstractButton)jBRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/config/HttpRequestRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/config/HttpRequestRunConfigurationEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private class RunTypeSelectionButtonItemListener
    implements ItemListener {
        private final HttpRequestRunType myRunType;

        RunTypeSelectionButtonItemListener(HttpRequestRunType runType) {
            if (runType == null) {
                RunTypeSelectionButtonItemListener.$$$reportNull$$$0(0);
            }
            this.myRunType = runType;
        }

        @Override
        public void itemStateChanged(@NotNull ItemEvent event) {
            if (event == null) {
                RunTypeSelectionButtonItemListener.$$$reportNull$$$0(1);
            }
            if (event.getStateChange() == 1) {
                HttpEnvironmentComboBox.HttpEnvironmentItem env = HttpRequestRunConfigurationEditor.this.myEnvironmentComboBox.getSelectedItem();
                String envName = env != null ? env.getName() : null;
                HttpRequestRunConfigurationEditor.this.updateState(HttpRequestRunConfigurationEditor.this.myPathField.getText(), envName, HttpRequestRunConfigurationEditor.this.myRequestNameComboBox.getSelectedRequestIndex(), HttpRequestRunConfigurationEditor.this.myRequestNameComboBox.getSelectedRequestIdentifier(), this.myRunType);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/run/config/HttpRequestRunConfigurationEditor$RunTypeSelectionButtonItemListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "itemStateChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

