/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.config;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestPsiFactory;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiFileIdentifiersScope;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutorImpl;
import com.intellij.httpClient.http.request.debug.DebugHttpRequestProfileState;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironment;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.httpClient.http.request.run.HttpRequestValidationException;
import com.intellij.httpClient.http.request.run.RunHttpRequestProfileState;
import com.intellij.httpClient.http.request.run.config.HttpRequestExecutionConfig;
import com.intellij.httpClient.http.request.run.config.HttpRequestExecutionSettings;
import com.intellij.httpClient.http.request.run.config.HttpRequestFileExecutionConfig;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunConfigurationEditor;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunType;
import com.intellij.httpClient.http.request.run.config.HttpSingleRequestExecutionConfig;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestRunConfiguration
extends LocatableConfigurationBase<Element> {
    private static final Logger LOG = Logger.getInstance(HttpRequestRunConfiguration.class);
    private static final String TEST_FRAMEWORK_NAME = "HTTP Client";
    public static final String FILE_AND_REQUEST_SEPARATOR = " | ";
    private Settings mySettings;

    public HttpRequestRunConfiguration(@NotNull Project project, ConfigurationFactory factory, String name) {
        if (project == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(0);
        }
        super(project, factory, name);
        this.mySettings = this.createSettings();
    }

    @NotNull
    public Settings createSettings() {
        return new Settings();
    }

    public Settings getSettings() {
        return this.mySettings;
    }

    public void setSettings(Settings settings) {
        this.mySettings = settings;
    }

    @Nullable
    public String suggestedName() {
        String path2 = this.mySettings.getFilePath();
        if (StringUtil.isNotEmpty((String)path2)) {
            @NlsSafe String name = FileUtilRt.getNameWithoutExtension((String)PathUtil.getFileName((String)path2));
            HttpRequestRunType runType = this.mySettings.getRunType();
            if (runType != null) {
                if (runType == HttpRequestRunType.ALL_IN_FILE) {
                    return RestClientBundle.message("http.request.run.configuration.run.all.in", name);
                }
                if (runType == HttpRequestRunType.SINGLE_REQUEST) {
                    if (StringUtil.isNotEmpty((String)this.mySettings.getRequestIdentifier())) {
                        return name + FILE_AND_REQUEST_SEPARATOR + this.mySettings.getRequestIdentifier();
                    }
                    return name + " | #" + this.mySettings.getIndex();
                }
            }
        }
        return null;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new HttpRequestRunConfigurationEditor(this.getProject());
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(1);
        }
        if (env == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(2);
        }
        return this.getState(executor);
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor) throws ExecutionException {
        if (executor == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(3);
        }
        Project project = this.getProject();
        try {
            HttpRequestExecutionConfig config = this.createConfig(project);
            HttpRequestEnvironment environment = this.mySettings.myEnvironmentHolder.environment();
            HttpRequestVariableSubstitutorImpl substitutor2 = HttpRequestVariableSubstitutorImpl.create(project, environment, config.getContext());
            SMTRunnerConsoleProperties properties = new SMTRunnerConsoleProperties(project, (RunProfile)this, TEST_FRAMEWORK_NAME, executor);
            if (executor.getId().equals("Debug")) {
                LOG.info("Debugging " + config.getName(substitutor2));
                return new DebugHttpRequestProfileState(this.getProject(), this.getSettings(), config, properties, substitutor2);
            }
            LOG.info("Executing " + config.getName(substitutor2));
            return new RunHttpRequestProfileState(this.getProject(), this.getSettings(), config, properties, substitutor2);
        }
        catch (RuntimeConfigurationException e) {
            throw new ExecutionException(e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private HttpRequestExecutionConfig createConfig(@NotNull Project project) throws RuntimeConfigurationException {
        void var3_6;
        Settings settings;
        if (project == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)(settings = this.getSettings()).getFilePath()) && settings.getFileText() == null) {
            throw new RuntimeConfigurationException(RestClientBundle.message("http.request.run.configuration.file.is.not.configured", new Object[0]));
        }
        PsiFile existingFile2 = HttpRequestRunConfiguration.findFileByPath(project, settings.getFilePath());
        if (existingFile2 == null) {
            if (settings.getFileText() == null) throw new RuntimeConfigurationException(RestClientBundle.message("http.request.run.configuration.file.doesn.exists", new Object[0]));
            HttpRequestPsiFile httpRequestPsiFile = HttpRequestPsiFactory.createDummyFile(project, settings.getFileText());
        } else {
            PsiFile psiFile = existingFile2;
        }
        if (!(var3_6 instanceof HttpRequestPsiFile) || settings.getRunType() != HttpRequestRunType.ALL_IN_FILE) return new HttpSingleRequestExecutionConfig(HttpRequestRunConfiguration.findRequestInFile((PsiFile)var3_6, this.mySettings), settings.isShowInformationAboutRequest());
        return new HttpRequestFileExecutionConfig((HttpRequestPsiFile)var3_6, settings.isShowInformationAboutRequest());
    }

    @NotNull
    public static HttpRequest findRequestInFile(@NotNull PsiFile file, @NotNull Settings settings) throws RuntimeConfigurationException {
        int index;
        if (file == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(6);
        }
        if (StringUtil.isNotEmpty((String)settings.getRequestIdentifier())) {
            HttpRequestPsiFileIdentifiersScope identifiersScope = new HttpRequestPsiFileIdentifiersScope(file);
            HttpRequest request2 = identifiersScope.resolveRequest(settings.getRequestIdentifier());
            if (request2 == null) {
                throw new RuntimeConfigurationException(RestClientBundle.message("http.request.run.configuration.request.doesn.exists.by.identifier", settings.getRequestIdentifier()));
            }
            HttpRequest httpRequest = request2;
            if (httpRequest == null) {
                HttpRequestRunConfiguration.$$$reportNull$$$0(7);
            }
            return httpRequest;
        }
        HttpRequestBlock[] blocks = HttpRequestPsiUtils.getRequestBlocks(file);
        int length2 = blocks.length;
        if (length2 < (index = settings.getIndex()) || index <= 0) {
            String message2 = length2 == 1 ? RestClientBundle.message("http.request.run.configuration.request.doesn.exists", index) : RestClientBundle.message("http.request.run.configuration.request.doesn.exists.many", index, length2);
            throw new RuntimeConfigurationException(message2);
        }
        HttpRequestBlock block = blocks[index - 1];
        HttpRequest httpRequest = block.getRequest();
        if (httpRequest == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(8);
        }
        return httpRequest;
    }

    @NotNull
    private HttpRequestEnvironment getEnvironment(@NotNull Project project, @NotNull PsiFile context) throws RuntimeConfigurationException {
        String environment;
        block10: {
            block9: {
                HttpRequestEnvironment httpRequestEnvironment;
                if (project == null) {
                    HttpRequestRunConfiguration.$$$reportNull$$$0(9);
                }
                if (context == null) {
                    HttpRequestRunConfiguration.$$$reportNull$$$0(10);
                }
                environment = this.mySettings.getEnvironment();
                try {
                    if (!StringUtil.isEmpty((String)environment) && !StringUtil.equals((CharSequence)environment, (CharSequence)HttpRequestEnvironment.EMPTY_NAME)) break block9;
                    httpRequestEnvironment = HttpRequestEnvironment.empty();
                }
                catch (HttpRequestValidationException e) {
                    throw new RuntimeConfigurationException(e.getMessage());
                }
                if (httpRequestEnvironment == null) {
                    HttpRequestRunConfiguration.$$$reportNull$$$0(11);
                }
                return httpRequestEnvironment;
            }
            if (!StringUtil.equals((CharSequence)environment, (CharSequence)HttpRequestEnvironment.DEFAULT_NAME)) break block10;
            HttpRequestEnvironment env = HttpRequestEnvironment.isNextForcedToUseStored(project) ? (HttpRequestEnvironment.isStoredDefaultEnvironmentValid(project, context) ? HttpRequestEnvironment.getStoredDefault(project, context) : null) : HttpRequestEnvironment.getDefault(project, context);
            HttpRequestEnvironment httpRequestEnvironment = env != null ? env : HttpRequestEnvironment.empty();
            if (httpRequestEnvironment == null) {
                HttpRequestRunConfiguration.$$$reportNull$$$0(12);
            }
            return httpRequestEnvironment;
        }
        HttpRequestEnvironment httpRequestEnvironment = HttpRequestEnvironment.create(project, environment, context);
        if (httpRequestEnvironment == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(13);
        }
        return httpRequestEnvironment;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        Project project = this.getProject();
        HttpRequestExecutionConfig config = this.createConfig(project);
        try {
            HttpRequestEnvironment env = this.getEnvironment(project, config.getContext());
            this.mySettings.myEnvironmentHolder = new EnvironmentResult.Success(env);
        }
        catch (RuntimeConfigurationException e) {
            this.mySettings.myEnvironmentHolder = new EnvironmentResult.Error(e);
            throw e;
        }
    }

    @Nullable
    public static PsiFile findFileByPath(@NotNull Project project, @Nullable String path2) {
        if (project == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(14);
        }
        if (StringUtil.isEmpty((String)path2)) {
            return null;
        }
        String url = StringUtil.isEmpty((String)VirtualFileManager.extractProtocol((String)path2)) ? VfsUtilCore.pathToUrl((String)path2) : path2;
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        return file != null ? PsiManager.getInstance((Project)project).findFile(file) : null;
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(15);
        }
        super.readExternal(element);
        this.mySettings = this.createSettings();
        XmlSerializer.deserializeInto((Element)element, (Object)this.mySettings);
        String path2 = this.mySettings.getFilePath();
        if (StringUtil.isNotEmpty((String)path2)) {
            this.mySettings.setFilePath(HttpRequestRunConfiguration.toSystemDependentUrl(path2));
        }
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(16);
        }
        super.writeExternal(element);
        if (this.mySettings != null) {
            Settings settings = this.mySettings.clone();
            String filePath2 = settings.getFilePath();
            if (StringUtil.isNotEmpty((String)filePath2)) {
                settings.setFilePath(HttpRequestRunConfiguration.toSystemIndependentUrl(filePath2));
            }
            XmlSerializer.serializeObjectInto((Object)settings, (Element)element);
        }
    }

    @NotNull
    private static String toSystemDependentUrl(@NotNull String filePath2) {
        String protocol;
        if (filePath2 == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(17);
        }
        if (StringUtil.isEmpty((String)(protocol = VirtualFileManager.extractProtocol((String)filePath2)))) {
            String string = FileUtil.toSystemDependentName((String)filePath2);
            if (string == null) {
                HttpRequestRunConfiguration.$$$reportNull$$$0(18);
            }
            return string;
        }
        String path2 = VirtualFileManager.extractPath((String)filePath2);
        String string = VirtualFileManager.constructUrl((String)protocol, (String)FileUtil.toSystemDependentName((String)path2));
        if (string == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private static String toSystemIndependentUrl(@NotNull String filePath2) {
        String protocol;
        if (filePath2 == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(20);
        }
        if (StringUtil.isEmpty((String)(protocol = VirtualFileManager.extractProtocol((String)filePath2)))) {
            String string = FileUtil.toSystemIndependentName((String)filePath2);
            if (string == null) {
                HttpRequestRunConfiguration.$$$reportNull$$$0(21);
            }
            return string;
        }
        String path2 = VirtualFileManager.extractPath((String)filePath2);
        String string = VirtualFileManager.constructUrl((String)protocol, (String)FileUtil.toSystemIndependentName((String)path2));
        if (string == null) {
            HttpRequestRunConfiguration.$$$reportNull$$$0(22);
        }
        return string;
    }

    public final RunConfiguration clone() {
        HttpRequestRunConfiguration clone = (HttpRequestRunConfiguration)super.clone();
        Element element = new Element("tmp");
        this.writeExternal(element);
        clone.mySettings = this.createSettings();
        clone.readExternal(element);
        return clone;
    }

    @Nullable
    public String getActionName() {
        Object name = StringUtil.isNotEmpty((String)this.mySettings.getRequestIdentifier()) ? this.mySettings.getRequestIdentifier() : "#" + this.mySettings.getIndex();
        Object shortName = ((String)name).length() < 20 ? name : ((String)name).substring(0, 20) + "...";
        return (String)shortName + this.getPresentableType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 11, 12, 13, 18, 19, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/config/HttpRequestRunConfiguration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/config/HttpRequestRunConfiguration";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findRequestInFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemDependentUrl";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemIndependentUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConfig";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findRequestInFile";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironment";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "toSystemDependentUrl";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "toSystemIndependentUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 11, 12, 13, 18, 19, 21, 22 -> new IllegalStateException(string);
        };
    }

    public static class Settings
    implements HttpRequestExecutionSettings {
        private String myEnvironment = HttpRequestEnvironment.DEFAULT_NAME;
        private String myDebugger = null;
        private String myPathToFile = null;
        private int myIndex = 1;
        private String myRequestIdentifier = "";
        private HttpRequestRunType myRunType = HttpRequestRunType.ALL_IN_FILE;
        private String myFileText = null;
        private boolean myShowInformationAboutRequest = true;
        private volatile EnvironmentResult myEnvironmentHolder = new EnvironmentResult.Success(HttpRequestEnvironment.empty());

        @Override
        @Attribute(value="debugger")
        public String getDebugger() {
            return this.myDebugger;
        }

        public void setDebugger(String debugger) {
            this.myDebugger = debugger;
        }

        @Attribute(value="environment")
        public String getEnvironment() {
            return this.myEnvironment;
        }

        public void setEnvironment(String environment) {
            this.myEnvironment = environment;
        }

        public boolean isDefaultEnvironment() {
            return StringUtil.equals((CharSequence)this.myEnvironment, (CharSequence)HttpRequestEnvironment.DEFAULT_NAME);
        }

        public void setNoEnvironment() {
            this.myEnvironment = HttpRequestEnvironment.EMPTY_NAME;
        }

        @Attribute(value="path")
        @NlsSafe
        public String getFilePath() {
            return this.myPathToFile;
        }

        public void setFilePath(String pathToFile) {
            this.myPathToFile = pathToFile;
        }

        @Attribute(value="index")
        public int getIndex() {
            return this.myIndex;
        }

        public void setIndex(int index) {
            this.myIndex = index;
        }

        @Attribute(value="requestIdentifier")
        @NlsSafe
        public String getRequestIdentifier() {
            return this.myRequestIdentifier;
        }

        public void setRequestIdentifier(@NlsSafe String requestIdentifier) {
            this.myRequestIdentifier = requestIdentifier;
        }

        @Attribute(value="runType")
        @Nullable
        public HttpRequestRunType getRunType() {
            return this.myRunType;
        }

        public void setRunType(@Nullable HttpRequestRunType runType) {
            this.myRunType = runType;
        }

        @Transient
        @Nullable
        public String getFileText() {
            return this.myFileText;
        }

        public void setFileText(@Nullable String fileText) {
            this.myFileText = fileText;
        }

        @Transient
        public boolean isShowInformationAboutRequest() {
            return this.myShowInformationAboutRequest;
        }

        public void setShowInformationAboutRequest(boolean showInformationAboutRequest) {
            this.myShowInformationAboutRequest = showInformationAboutRequest;
        }

        @NotNull
        protected Settings clone() {
            Settings settings = new Settings();
            settings.setDebugger(this.getDebugger());
            settings.setEnvironment(this.getEnvironment());
            settings.setFilePath(this.getFilePath());
            settings.setIndex(this.getIndex());
            settings.setRequestIdentifier(this.getRequestIdentifier());
            settings.setRunType(this.getRunType());
            Settings settings2 = settings;
            if (settings2 == null) {
                Settings.$$$reportNull$$$0(0);
            }
            return settings2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/httpClient/http/request/run/config/HttpRequestRunConfiguration$Settings", "clone"));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface EnvironmentResult {
        public HttpRequestEnvironment environment() throws RuntimeConfigurationException;

        public record Error(RuntimeConfigurationException exception) implements EnvironmentResult
        {
            @Override
            public HttpRequestEnvironment environment() throws RuntimeConfigurationException {
                throw this.exception;
            }
        }

        public record Success(HttpRequestEnvironment environment) implements EnvironmentResult
        {
        }
    }
}

