/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.config;

import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiFileIdentifiersScope;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestComboBox
extends ComboBox<HttpRequestItem> {
    public void reset(@NotNull HttpRequestPsiFile file, int selectedIndex, @Nullable String identifier) {
        boolean isValid;
        if (file == null) {
            HttpRequestComboBox.$$$reportNull$$$0(0);
        }
        HttpRequestBlock[] blocks = HttpRequestPsiUtils.getRequestBlocks((PsiFile)file);
        ArrayList<HttpRequestItem> items = new ArrayList<HttpRequestItem>();
        HttpRequestPsiFileIdentifiersScope scope = new HttpRequestPsiFileIdentifiersScope((PsiFile)file);
        for (int i = 0; i < blocks.length; ++i) {
            items.add(new HttpOrderAndIdentifierRequestItem(i + 1, true, scope.getIdentifier(blocks[i].getRequest())));
        }
        if (items.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        boolean byIdentifier = identifier != null;
        HttpRequestItem selectedItem = byIdentifier ? (HttpRequestItem)ContainerUtil.find(items, item -> ((HttpOrderAndIdentifierRequestItem)item).getIdentifier().equals(identifier)) : (HttpRequestItem)ContainerUtil.find(items, item -> ((HttpOrderAndIdentifierRequestItem)item).getIndex() == selectedIndex);
        boolean bl = isValid = selectedItem != null;
        if (!isValid) {
            selectedItem = new HttpOrderAndIdentifierRequestItem(selectedIndex, false, identifier);
            items.add(selectedItem);
        }
        this.setModel((ComboBoxModel)new CollectionComboBoxModel(items));
        this.getModel().setSelectedItem(selectedItem);
        this.setRenderer((ListCellRenderer)new ColoredListCellRenderer<HttpRequestItem>(){

            protected void customizeCellRenderer(@NotNull JList<? extends HttpRequestItem> list2, HttpRequestItem value2, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value2 != null) {
                    this.append(value2.getPresentableName(), value2.isValid() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/httpClient/http/request/run/config/HttpRequestComboBox$1", "customizeCellRenderer"));
            }
        });
    }

    public int getSelectedRequestIndex() {
        HttpRequestItem item = (HttpRequestItem)this.getSelectedItem();
        return item instanceof HttpOrderAndIdentifierRequestItem ? ((HttpOrderAndIdentifierRequestItem)item).getIndex() : 1;
    }

    @Nullable
    public String getSelectedRequestIdentifier() {
        HttpRequestItem item = (HttpRequestItem)this.getSelectedItem();
        return item instanceof HttpOrderAndIdentifierRequestItem ? ((HttpOrderAndIdentifierRequestItem)item).getIdentifier() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/httpClient/http/request/run/config/HttpRequestComboBox", "reset"));
    }

    public static class HttpOrderAndIdentifierRequestItem
    implements HttpRequestItem {
        private final int myIndex;
        private final boolean myIsValid;
        @NlsSafe
        private final String myIdentifier;

        public HttpOrderAndIdentifierRequestItem(int index, boolean isValid, @NlsSafe String identifier) {
            this.myIndex = index;
            this.myIsValid = isValid;
            this.myIdentifier = identifier;
        }

        public int getIndex() {
            return this.myIndex;
        }

        public String getIdentifier() {
            return this.myIdentifier;
        }

        @Override
        public String getPresentableName() {
            if (StringUtil.isNotEmpty((String)this.myIdentifier)) {
                return this.myIdentifier;
            }
            return "#" + this.myIndex;
        }

        @Override
        public boolean isValid() {
            return this.myIsValid;
        }

        public String toString() {
            return this.getPresentableName();
        }
    }

    public static interface HttpRequestItem {
        @Nls
        public String getPresentableName();

        public boolean isValid();
    }
}

