/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.execution.ExecutionException;
import com.intellij.httpClient.execution.HttpClientExecutorBundle;
import com.intellij.httpClient.execution.RestClientResponseListener;
import com.intellij.httpClient.execution.ssl.HttpRequestSslConfigurationException;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.HttpRequestSubstitutionValidationException;
import com.intellij.httpClient.http.request.run.HttpRequestValidationException;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.SmartPsiElementPointer;
import java.net.URISyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RestClientResponseErrorHandlerListener
implements RestClientResponseListener {
    private static final Logger LOG = Logger.getInstance(RestClientResponseErrorHandlerListener.class);

    @Override
    public void onErrorResponse(@Nullable Throwable throwable) {
        if (throwable == null) {
            this.onErrorResponse("");
        } else if (throwable instanceof NoClassDefFoundError || throwable instanceof ExceptionWithAttachments || throwable instanceof NullPointerException || throwable instanceof IllegalStateException) {
            this.onErrorResponse(HttpClientExecutorBundle.message("http.client.internal.error", new Object[0]));
            LOG.error(throwable);
        } else if (throwable instanceof URISyntaxException) {
            URISyntaxException uriSyntaxException = (URISyntaxException)throwable;
            this.onErrorResponseURISyntaxException(uriSyntaxException);
        } else {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 instanceof URISyntaxException) {
                URISyntaxException uriSyntaxException = (URISyntaxException)throwable2;
                this.onErrorResponseURISyntaxException(uriSyntaxException);
            } else if (throwable.getCause() != null && (throwable2 = throwable.getCause().getCause()) instanceof URISyntaxException) {
                URISyntaxException uriSyntaxException = (URISyntaxException)throwable2;
                this.onErrorResponseURISyntaxException(uriSyntaxException);
            } else if (throwable instanceof HttpRequestSslConfigurationException) {
                this.onErrorResponse(HttpClientExecutorBundle.message("http.request.ssl.error.response", throwable.getMessage()));
            } else if (throwable instanceof HttpRequestValidationException) {
                this.onErrorResponse(throwable.getMessage());
            } else if (throwable instanceof ExecutionException) {
                this.onErrorResponse(throwable.getMessage());
            } else if (throwable instanceof HttpRequestSubstitutionValidationException) {
                this.onErrorResponse(throwable.getMessage());
            } else {
                this.onErrorResponse(throwable.toString());
            }
        }
    }

    private void onErrorResponseURISyntaxException(@NotNull URISyntaxException throwable) {
        if (throwable == null) {
            RestClientResponseErrorHandlerListener.$$$reportNull$$$0(0);
        }
        this.onErrorResponse(throwable.toString());
    }

    @NotNull
    protected abstract SmartPsiElementPointer<HttpRequest> getRequestPointer();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwable", "com/intellij/httpClient/http/request/run/RestClientResponseErrorHandlerListener", "onErrorResponseURISyntaxException"));
    }
}

