/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.httpClient.http.request.HttpRequestListVariableSubstitutor;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.SubstitutionVariableValue;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBody;
import com.intellij.httpClient.http.request.psi.HttpVariable;
import com.intellij.httpClient.http.request.run.HttpRequestSubstitutionValidationException;
import com.intellij.httpClient.http.request.run.HttpRunRequestInfo;
import com.intellij.httpClient.http.request.run.UnsubstitutedHttpVariableInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\"\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"findAllUnsubstitutedVariables", "", "Lcom/intellij/httpClient/http/request/run/UnsubstitutedHttpVariableInfo;", "request", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "substitutor", "Lcom/intellij/httpClient/http/request/HttpRequestVariableSubstitutor;", "findAllVariablesWithStartOffset", "Lkotlin/Pair;", "", "", "findVariablePosition", "Lcom/intellij/openapi/util/text/LineColumn;", "file", "Lcom/intellij/psi/PsiFile;", "offsetsInFile", "validateHttpRequestAllSubstitutionsExist", "", "info", "Lcom/intellij/httpClient/http/request/run/HttpRunRequestInfo;", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nRequestInfoValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestInfoValidator.kt\ncom/intellij/httpClient/http/request/run/RequestInfoValidatorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1603#2,9:113\n1855#2:122\n1856#2:124\n1612#2:125\n1855#2,2:126\n1855#2,2:128\n1#3:123\n*S KotlinDebug\n*F\n+ 1 RequestInfoValidator.kt\ncom/intellij/httpClient/http/request/run/RequestInfoValidatorKt\n*L\n35#1:113,9\n35#1:122\n35#1:124\n35#1:125\n55#1:126,2\n65#1:128,2\n35#1:123\n*E\n"})
public final class RequestInfoValidatorKt {
    public static final void validateHttpRequestAllSubstitutionsExist(@NotNull HttpRunRequestInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        HttpRequest httpRequest = (HttpRequest)info.getRequestPointer().getElement();
        if (httpRequest == null) {
            return;
        }
        HttpRequest request2 = httpRequest;
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = info.getVariableSubstitutor();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequestVariableSubstitutor, (String)"getVariableSubstitutor(...)");
        HttpRequestVariableSubstitutor substitutor2 = httpRequestVariableSubstitutor;
        List<UnsubstitutedHttpVariableInfo> unsubstituted = RequestInfoValidatorKt.findAllUnsubstitutedVariables(request2, substitutor2);
        UnsubstitutedHttpVariableInfo unsubstitutedHttpVariableInfo = (UnsubstitutedHttpVariableInfo)CollectionsKt.firstOrNull(unsubstituted);
        if (unsubstitutedHttpVariableInfo == null) {
            return;
        }
        UnsubstitutedHttpVariableInfo first = unsubstitutedHttpVariableInfo;
        PsiFile psiFile = request2.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        throw new HttpRequestSubstitutionValidationException(first, psiFile);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<UnsubstitutedHttpVariableInfo> findAllUnsubstitutedVariables(HttpRequest request2, HttpRequestVariableSubstitutor substitutor2) {
        void $this$mapNotNullTo$iv$iv;
        Project project = request2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiFile file = request2.getContainingFile();
        List<Pair<String, Integer>> variablesWithOffsets = RequestInfoValidatorKt.findAllVariablesWithStartOffset(request2);
        Iterable $this$mapNotNull$iv = variablesWithOffsets;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            UnsubstitutedHttpVariableInfo unsubstitutedHttpVariableInfo;
            SubstitutionVariableValue value2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pair pair = (Pair)element$iv$iv;
            boolean bl2 = false;
            String name = (String)pair.component1();
            int offset = ((Number)pair.component2()).intValue();
            SubstitutionVariableValue substitutionVariableValue = value2 = substitutor2 instanceof HttpRequestListVariableSubstitutor ? ((HttpRequestListVariableSubstitutor)substitutor2).getVariableValueWithIndex(name, project2) : new SubstitutionVariableValue(substitutor2.getVariableValue(name, null, project2, null), null);
            if (value2.getValue() != null) {
                unsubstitutedHttpVariableInfo = null;
            } else {
                LineColumn lineColumn;
                Intrinsics.checkNotNull((Object)file);
                unsubstitutedHttpVariableInfo = RequestInfoValidatorKt.findVariablePosition(file, offset) == null ? null : new UnsubstitutedHttpVariableInfo(name, lineColumn, value2.getIterationNumber());
            }
            if (unsubstitutedHttpVariableInfo == null) continue;
            UnsubstitutedHttpVariableInfo it$iv$iv = unsubstitutedHttpVariableInfo;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List<Pair<String, Integer>> findAllVariablesWithStartOffset(HttpRequest request2) {
        List variablesWithOffsets = new ArrayList();
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)request2), HttpVariable.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        Collection variables2 = collection;
        Iterable $this$forEach$iv = variables2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            HttpVariable variable2 = (HttpVariable)element$iv;
            boolean bl = false;
            if (variable2.getName() == null) continue;
            Intrinsics.checkNotNull((Object)object);
            String name = object;
            Intrinsics.checkNotNull((Object)variable2);
            variablesWithOffsets.add(TuplesKt.to((Object)name, (Object)PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)variable2))));
        }
        HttpRequestBody requestBody = request2.getRequestBody();
        if (requestBody != null) {
            String bodyText = requestBody.getText();
            List<TextRange> list2 = HttpRequestPsiUtils.collectVariablesRangesInMessageBody(bodyText);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"collectVariablesRangesInMessageBody(...)");
            List<TextRange> inBody = list2;
            int bodyOffset2 = PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)requestBody));
            Iterable $this$forEach$iv2 = inBody;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String name;
                TextRange range = (TextRange)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)HttpRequestPsiUtils.getVariableName(bodyText, range), (String)"getVariableName(...)");
                variablesWithOffsets.add(TuplesKt.to((Object)name, (Object)(bodyOffset2 + range.getStartOffset())));
            }
        }
        return variablesWithOffsets;
    }

    private static final LineColumn findVariablePosition(PsiFile file, int offsetsInFile) {
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file.getContainingFile().getOriginalFile());
        if (document == null) {
            return null;
        }
        int lineNumber = document.getLineNumber(offsetsInFile);
        int columnNumber = offsetsInFile - document.getLineStartOffset(lineNumber);
        return LineColumn.of((int)lineNumber, (int)columnNumber);
    }
}

