/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocComment;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocNoLogResponseTag;
import com.intellij.httpClient.http.request.psi.HttpDifferenceFile;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.HttpRequestFilePostProcessor;
import com.intellij.httpClient.http.request.run.HttpRequestHistoryManager;
import com.intellij.httpClient.http.request.run.HttpRequestResponseFileResult;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpScratchRequestPostProcessor
extends HttpRequestFilePostProcessor {
    public HttpScratchRequestPostProcessor(@NotNull SmartPsiElementPointer<HttpRequest> request2) {
        if (request2 == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(0);
        }
        super(request2);
    }

    @Override
    @RequiresEdt
    protected void updateRequest(@NotNull Document document, @NotNull HttpRequest request2, @Nullable HttpRequestResponseFileResult responseFileName) {
        if (document == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(1);
        }
        if (request2 == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        HttpDocComment docComment = HttpRequestPsiUtils.findDocComment(request2);
        if (docComment != null) {
            if (ContainerUtil.exists(docComment.getTags(), HttpDocNoLogResponseTag.class::isInstance)) {
                return;
            }
        }
        List<Editor> editors = HttpScratchRequestPostProcessor.getEditors(request2.getProject(), document);
        if (!(responseFileName instanceof HttpRequestResponseFileResult.ExactFile)) {
            return;
        }
        String fileName = ((HttpRequestResponseFileResult.ExactFile)responseFileName).getFileName();
        if (StringUtil.isNotEmpty((String)fileName)) {
            String text2 = "<> " + fileName;
            int insertedOffset = (Integer)WriteCommandAction.writeCommandAction((Project)request2.getProject()).compute(() -> {
                int offset;
                List<HttpDifferenceFile> diffFiles = request2.getDifferenceFileList();
                if (!diffFiles.isEmpty()) {
                    offset = diffFiles.get(0).getTextRange().getStartOffset();
                    document.insertString(offset, (CharSequence)(text2 + "\n"));
                } else {
                    offset = request2.getTextRange().getEndOffset();
                    document.insertString(offset, (CharSequence)("\n\n" + text2));
                }
                return offset;
            });
            List<HttpDifferenceFile> diffFiles = request2.getDifferenceFileList();
            HttpScratchRequestPostProcessor.moveCaretsToRespectFoldings(editors, diffFiles);
            HttpScratchRequestPostProcessor.foldWhenFoldRegionIsReady(editors, insertedOffset);
        }
    }

    @NotNull
    public static GlobalSearchScope getResponseReferencesSearchScope(@NotNull Project project) {
        if (project == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(3);
        }
        GlobalSearchScope globalSearchScope = ScratchesSearchScope.getScratchesScope((Project)project);
        if (globalSearchScope == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    @NotNull
    private static List<Editor> getEditors(@NotNull Project project, @NotNull Document document) {
        VirtualFile file;
        if (project == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(5);
        }
        if (document == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(6);
        }
        if ((file = FileDocumentManager.getInstance().getFile(document)) == null) {
            List<Editor> list2 = Collections.emptyList();
            if (list2 == null) {
                HttpScratchRequestPostProcessor.$$$reportNull$$$0(7);
            }
            return list2;
        }
        List list3 = StreamEx.of((Object[])FileEditorManager.getInstance((Project)project).getEditors(file)).map(editor2 -> {
            if (editor2 instanceof TextEditor) {
                return ((TextEditor)editor2).getEditor();
            }
            return null;
        }).nonNull().toList();
        if (list3 == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(8);
        }
        return list3;
    }

    private static void moveCaretsToRespectFoldings(@NotNull List<Editor> editors, @NotNull List<HttpDifferenceFile> diffFiles) {
        if (editors == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(9);
        }
        if (diffFiles == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(10);
        }
        for (Editor editor2 : editors) {
            CaretModel caretModel = editor2.getCaretModel();
            int caretOffset = caretModel.getOffset();
            if (!ContainerUtil.exists(diffFiles, diff -> diff.getTextRange().contains(caretOffset))) continue;
            LogicalPosition currentPosition = editor2.offsetToLogicalPosition(caretOffset);
            LogicalPosition newLogicalPosition = new LogicalPosition(currentPosition.line - 1, currentPosition.column);
            caretModel.moveToLogicalPosition(newLogicalPosition);
        }
    }

    private static void foldWhenFoldRegionIsReady(@NotNull List<Editor> editors, final int offset) {
        if (editors == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(11);
        }
        for (final Editor editor2 : editors) {
            if (editor2.getProject() == null) continue;
            final FoldingModelEx foldingModel = (FoldingModelEx)editor2.getFoldingModel();
            final Disposable disposable2 = Disposer.newDisposable((Disposable)HttpRequestHistoryManager.getInstance(editor2.getProject()), (String)"disposable for folding listener");
            foldingModel.addListener(new FoldingListener(){

                public void onFoldProcessingEnd() {
                    Disposer.dispose((Disposable)disposable2);
                    LogicalPosition logicalPosition = editor2.offsetToLogicalPosition(offset);
                    FoldRegion foldRegion = FoldingUtil.findFoldRegionStartingAtLine((Editor)editor2, (int)(logicalPosition.line + 3));
                    if (foldRegion != null && foldRegion.isExpanded() && HttpScratchRequestPostProcessor.isRecentlyCreated(foldRegion)) {
                        foldingModel.runBatchFoldingOperation(() -> foldRegion.setExpanded(false));
                    }
                }
            }, disposable2);
        }
    }

    private static boolean isRecentlyCreated(@NotNull FoldRegion foldRegion) {
        if (foldRegion == null) {
            HttpScratchRequestPostProcessor.$$$reportNull$$$0(12);
        }
        Editor editor2 = foldRegion.getEditor();
        LogicalPosition start = editor2.offsetToLogicalPosition(foldRegion.getStartOffset());
        LogicalPosition end = editor2.offsetToLogicalPosition(foldRegion.getEndOffset());
        return end.line - start.line == 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/HttpScratchRequestPostProcessor";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffFiles";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldRegion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpScratchRequestPostProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponseReferencesSearchScope";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateRequest";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getResponseReferencesSearchScope";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEditors";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretsToRespectFoldings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "foldWhenFoldRegionIsReady";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isRecentlyCreated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 8 -> new IllegalStateException(string);
        };
    }
}

