/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.httpClient.execution.HttpClientExecutorBundle;
import com.intellij.httpClient.http.request.HttpRequestListVariableSubstitutor;
import com.intellij.httpClient.http.request.HttpRequestPlaceholderUtil;
import com.intellij.httpClient.http.request.HttpRequestPsiConvertersKt;
import com.intellij.httpClient.http.request.HttpRequestUrlAccessor;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutorImpl;
import com.intellij.httpClient.http.request.psi.HttpFilePath;
import com.intellij.httpClient.http.request.psi.HttpHandlerScriptDescriptor;
import com.intellij.httpClient.http.request.psi.HttpPreRequestHandler;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpResponseHandler;
import com.intellij.httpClient.http.request.psi.HttpScriptBody;
import com.intellij.httpClient.http.request.run.HttpClientResponseHandler;
import com.intellij.httpClient.http.request.run.HttpRequestExecutionHelperService;
import com.intellij.httpClient.http.request.run.HttpRequestPostProcessor;
import com.intellij.httpClient.http.request.run.preScript.HttpClientPreRequestHandler;
import com.intellij.httpClient.http.request.run.preScript.HttpClientRequestElementsProvider;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRunRequestInfo {
    @NotNull
    @NlsSafe
    private final String myRequestMethod;
    @Nullable
    @NlsSafe
    private final String myRequestScheme;
    private final HttpClientResponseHandler myResponseHandler;
    private final HttpClientPreRequestHandler myPreRequestHandler;
    private final HttpRequestPostProcessor myPostProcessor;
    private final SmartPsiElementPointer<HttpRequest> myRequestPointer;
    @Nullable
    @Nls
    private final String myIgnoreMessage;
    @NotNull
    private final HttpRequestVariableSubstitutor myVariableSubstitutor;

    public HttpRunRequestInfo(@NotNull HttpRequestPostProcessor postProcessor, @NotNull SmartPsiElementPointer<HttpRequest> pointer, @Nullable HttpClientResponseHandler responseHandler, @Nullable HttpClientPreRequestHandler preRequestHandler, @Nullable @Nls String message2, @NotNull String requestMethod, @Nullable String scheme, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        if (postProcessor == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(0);
        }
        if (pointer == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(1);
        }
        if (requestMethod == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(2);
        }
        if (substitutor2 == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(3);
        }
        this.myResponseHandler = responseHandler;
        this.myPostProcessor = postProcessor;
        this.myRequestPointer = pointer;
        this.myPreRequestHandler = preRequestHandler;
        this.myIgnoreMessage = message2;
        this.myRequestMethod = requestMethod;
        this.myVariableSubstitutor = substitutor2;
        this.myRequestScheme = scheme;
    }

    @Nullable
    public String getRequestScheme() {
        return this.myRequestScheme;
    }

    public static HttpRunRequestInfo create(@NotNull HttpRequest psiRequest, @NotNull SmartPsiElementPointer<HttpRequest> pointerToOriginalElement, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        HttpClientPreRequestHandler preRequestHandler;
        if (psiRequest == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(4);
        }
        if (pointerToOriginalElement == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(5);
        }
        if (substitutor2 == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(6);
        }
        if ((preRequestHandler = HttpRunRequestInfo.createPreRequestHandler(psiRequest.getPreRequestHandler(), substitutor2)) != null) {
            substitutor2 = preRequestHandler.getSubstitutor$intellij_httpClient_executor();
        }
        String method = psiRequest.getHttpMethod();
        HttpClientResponseHandler responseHandler = HttpRunRequestInfo.createHandler(psiRequest.getResponseHandler(), pointerToOriginalElement, substitutor2, method);
        PsiFile file = psiRequest.getContainingFile();
        HttpRequestExecutionHelperService service = HttpRequestExecutionHelperService.getInstance();
        HttpRequestPostProcessor processor = service != null ? service.getProcessor(file, pointerToOriginalElement) : HttpRequestPostProcessor.EMPTY_PROCESSOR;
        String originalURL = StringUtil.notNullize((String)psiRequest.getHttpUrl(HttpRequestVariableSubstitutor.empty()));
        String message2 = HttpRequestPlaceholderUtil.containsPlaceholder(psiRequest) ? HttpClientExecutorBundle.message("http.request.placeholder.run.ignore", originalURL) : null;
        return new HttpRunRequestInfo(processor, pointerToOriginalElement, responseHandler, preRequestHandler, message2, method, psiRequest.getScheme(), substitutor2.invalidVariablesAware());
    }

    @Nullable
    public static HttpClientResponseHandler createHandler(@Nullable HttpResponseHandler handler, @NotNull SmartPsiElementPointer<HttpRequest> pointerToOriginalElement, @NotNull HttpRequestVariableSubstitutor substitutor2, @NotNull String requestMethod) {
        ScriptSource scriptSource;
        if (pointerToOriginalElement == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(7);
        }
        if (substitutor2 == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(8);
        }
        if (requestMethod == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(9);
        }
        if ((scriptSource = HttpRunRequestInfo.readScript(handler, HttpClientExecutorBundle.message("rest.client.cannot.execute.response.handler.failed.title", new Object[0]), path2 -> HttpClientExecutorBundle.message("rest.client.request.cannot.find.response.handler", path2))) == null) {
            return null;
        }
        return new HttpClientResponseHandler(pointerToOriginalElement, substitutor2, requestMethod, scriptSource.text(), scriptSource.file(), scriptSource.lineOffset());
    }

    @Nullable
    public static HttpClientPreRequestHandler createPreRequestHandler(@Nullable HttpPreRequestHandler handler, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        boolean isListSubstitutor;
        HttpRequestVariableSubstitutor parentSubstitutor;
        if (substitutor2 == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(10);
        }
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = parentSubstitutor = (isListSubstitutor = substitutor2 instanceof HttpRequestListVariableSubstitutor) ? ((HttpRequestListVariableSubstitutor)substitutor2).getParentSubstitutor() : substitutor2;
        if (!(parentSubstitutor instanceof HttpRequestVariableSubstitutorImpl)) {
            return null;
        }
        HttpRequestVariableSubstitutorImpl substitutorImpl = (HttpRequestVariableSubstitutorImpl)parentSubstitutor;
        ScriptSource scriptSource = HttpRunRequestInfo.readScript(handler, HttpClientExecutorBundle.message("rest.client.cannot.execute.pre.request.handler.failed.title", new Object[0]), path2 -> HttpClientExecutorBundle.message("rest.client.request.cannot.find.pre.request.handler", path2));
        if (scriptSource == null) {
            return null;
        }
        HttpRequestVariableSubstitutorImpl.HttpRequestUpdatedVariableSubstitutor updated = substitutorImpl.updateAware();
        HttpRequestVariableSubstitutorImpl updatedSubstitutor2 = updated.substitutor();
        HttpRequestVariableSubstitutorImpl newSubstitutor = isListSubstitutor ? ((HttpRequestListVariableSubstitutor)substitutor2).copyWithNewParent(updatedSubstitutor2) : updatedSubstitutor2;
        return new HttpClientPreRequestHandler(scriptSource.text(), newSubstitutor, updated.updater(), scriptSource.file(), scriptSource.lineOffset());
    }

    @Nullable
    private static ScriptSource readScript(@Nullable HttpHandlerScriptDescriptor scriptDescriptor, @NotNull @NlsContexts.NotificationTitle String errorTitle, @NotNull Function<String, @NlsContexts.NotificationContent String> errorProducer) {
        String text2;
        if (errorTitle == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(11);
        }
        if (errorProducer == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(12);
        }
        if (scriptDescriptor == null) {
            return null;
        }
        HttpScriptBody script = scriptDescriptor.getScriptBody();
        if (script != null && StringUtil.isNotEmpty((String)(text2 = script.getText()))) {
            if (script.getContainingFile().getVirtualFile() == null) {
                Logger.getInstance(HttpRunRequestInfo.class).error("Virtual file is null.");
                return null;
            }
            VirtualFile sourceFile = script.getContainingFile().getVirtualFile();
            int lineOffset = script.getContainingFile().getViewProvider().getDocument() != null ? script.getContainingFile().getViewProvider().getDocument().getLineNumber(script.getTextOffset()) : 0;
            return new ScriptSource(text2, sourceFile, lineOffset);
        }
        HttpFilePath filePath2 = scriptDescriptor.getFilePath();
        if (filePath2 != null) {
            PsiFile file;
            HttpRequestExecutionHelperService service = HttpRequestExecutionHelperService.getInstance();
            PsiFile psiFile = file = service != null ? service.resolveFilePath(filePath2) : null;
            if (file != null) {
                String text3;
                VirtualFile virtualFile = file.getVirtualFile();
                try {
                    text3 = VfsUtilCore.loadText((VirtualFile)virtualFile);
                }
                catch (IOException e) {
                    HttpRunRequestInfo.showWarningIfPossible(scriptDescriptor, errorTitle, errorProducer, filePath2, service);
                    return null;
                }
                return new ScriptSource(text3, virtualFile, 0);
            }
            HttpRunRequestInfo.showWarningIfPossible(scriptDescriptor, errorTitle, errorProducer, filePath2, service);
        }
        return null;
    }

    private static void showWarningIfPossible(@NotNull HttpHandlerScriptDescriptor scriptDescriptor, @NotNull String errorTitle, @NotNull Function<String, @NlsContexts.NotificationContent String> errorProducer, @NotNull HttpFilePath filePath2, @Nullable HttpRequestExecutionHelperService service) {
        if (scriptDescriptor == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(13);
        }
        if (errorTitle == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(14);
        }
        if (errorProducer == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(15);
        }
        if (filePath2 == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(16);
        }
        Project project = scriptDescriptor.getProject();
        String path2 = filePath2.getPresentablePath();
        if (service != null) {
            service.showWarning(project, errorTitle, errorProducer.apply(path2));
        }
    }

    @NotNull
    public HttpRequestPostProcessor getPostProcessor() {
        HttpRequestPostProcessor httpRequestPostProcessor = this.myPostProcessor;
        if (httpRequestPostProcessor == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(17);
        }
        return httpRequestPostProcessor;
    }

    @Nullable
    public HttpClientResponseHandler getResponseHandler() {
        return this.myResponseHandler;
    }

    @Nullable
    public HttpClientPreRequestHandler getPreRequestHandler() {
        return this.myPreRequestHandler;
    }

    @NotNull
    public SmartPsiElementPointer<HttpRequest> getRequestPointer() {
        SmartPsiElementPointer<HttpRequest> smartPsiElementPointer = this.myRequestPointer;
        if (smartPsiElementPointer == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(18);
        }
        return smartPsiElementPointer;
    }

    @Nls
    @Nullable
    public String getIgnoreMessage() {
        return this.myIgnoreMessage;
    }

    @NotNull
    public HttpRequestVariableSubstitutor getVariableSubstitutor() {
        HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = this.myVariableSubstitutor;
        if (httpRequestVariableSubstitutor == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(19);
        }
        return httpRequestVariableSubstitutor;
    }

    @NotNull
    @NlsSafe
    public String getRequestMethod() {
        String string = this.myRequestMethod;
        if (string == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public String getRequestURL() {
        return (String)ReadAction.compute(() -> {
            HttpRequest element = (HttpRequest)this.myRequestPointer.getElement();
            if (element == null) {
                return null;
            }
            return HttpRunRequestInfo.getUrlWithQuery(element, this.myVariableSubstitutor);
        });
    }

    @Nullable
    public String getRequestBody() {
        return (String)this.httpClientRequestElementsProvider().getSubstitutedBody().getValue();
    }

    @Nullable
    public HttpClientRequestElementsProvider.Headers getHeaders() {
        return (HttpClientRequestElementsProvider.Headers)this.httpClientRequestElementsProvider().getHeaders().getValue();
    }

    private HttpClientRequestElementsProvider httpClientRequestElementsProvider() {
        return new HttpClientRequestElementsProvider(this.myRequestPointer, this.myVariableSubstitutor, Objects.requireNonNull((HttpRequest)this.myRequestPointer.getElement()).getHttpMethod());
    }

    @Nullable
    private static String getUrlWithQuery(@NotNull HttpRequest request2, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        HttpRequestUrlAccessor fullUrl;
        if (request2 == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(21);
        }
        if (substitutor2 == null) {
            HttpRunRequestInfo.$$$reportNull$$$0(22);
        }
        if ((fullUrl = HttpRequestPsiConvertersKt.getFullUrl(request2, substitutor2)) == null) {
            return null;
        }
        return fullUrl.toUrlString(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestMethod";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiRequest";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointerToOriginalElement";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorTitle";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorProducer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptDescriptor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/HttpRunRequestInfo";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRunRequestInfo";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPostProcessor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestPointer";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableSubstitutor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createPreRequestHandler";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readScript";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showWarningIfPossible";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getUrlWithQuery";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 18, 19, 20 -> new IllegalStateException(string);
        };
    }

    private record ScriptSource(@NotNull String text, @NotNull VirtualFile file, int lineOffset) {
        @NotNull
        private final String text;
        @NotNull
        private final VirtualFile file;

        private ScriptSource(@NotNull String text2, @NotNull VirtualFile file, int lineOffset) {
            if (text2 == null) {
                ScriptSource.$$$reportNull$$$0(0);
            }
            if (file == null) {
                ScriptSource.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public String text() {
            String string = this.text;
            if (string == null) {
                ScriptSource.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public VirtualFile file() {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                ScriptSource.$$$reportNull$$$0(3);
            }
            return virtualFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/run/HttpRunRequestInfo$ScriptSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRunRequestInfo$ScriptSource";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "text";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

