/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.httpClient.execution.common.CommonClientBodyFileHint;
import com.intellij.httpClient.execution.common.CommonClientRequest;
import com.intellij.httpClient.execution.common.CommonClientResponseBody;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestSaveFileUtil {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HHmmss");

    @RequiresBackgroundThread
    @NotNull
    public static UniqueResponseFile createUniqueFile(@NotNull CommonClientRequest request2, @NotNull Path root, @NotNull String status, @NotNull String timestamp, @NotNull CommonClientResponseBody body2, @NotNull String ignoredPrefix, @NotNull @NotNull Function<@NotNull Path, @Nullable VirtualFile> vFileProvider) throws IOException {
        if (request2 == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(0);
        }
        if (root == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(1);
        }
        if (status == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(2);
        }
        if (timestamp == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(3);
        }
        if (body2 == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(4);
        }
        if (ignoredPrefix == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(5);
        }
        if (vFileProvider == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(6);
        }
        ThreadingAssertions.assertBackgroundThread();
        CommonClientRequest.OutputFilePath outputFilePath = request2.getOutputFilePath();
        if (outputFilePath == null) {
            String fileName = HttpRequestSaveFileUtil.unique(root, status, timestamp, body2, false);
            Path resultFile2 = HttpRequestSaveFileUtil.ensureChildExists(root, fileName);
            VirtualFile file = vFileProvider.apply(resultFile2);
            return new UniqueResponseFile(fileName, file);
        }
        Path path2 = outputFilePath.getPath();
        if (Files.isDirectory(path2, new LinkOption[0]) || outputFilePath.isDirectory()) {
            if (!Files.exists(path2, new LinkOption[0])) {
                Files.createDirectories(path2, new FileAttribute[0]);
            }
            String fileName = HttpRequestSaveFileUtil.unique(path2, status, timestamp, body2, outputFilePath.isForce());
            Path resultFile3 = HttpRequestSaveFileUtil.ensureChildExists(path2, fileName);
            VirtualFile file = vFileProvider.apply(resultFile3);
            return new UniqueResponseFile(HttpRequestSaveFileUtil.toPresentableHistoryPath(resultFile3, ignoredPrefix), file);
        }
        if (outputFilePath.isForce()) {
            if (!Files.exists(path2, new LinkOption[0])) {
                NioFiles.createDirectories((Path)outputFilePath.getPath().getParent());
                Files.createFile(path2, new FileAttribute[0]);
            }
            VirtualFile file = vFileProvider.apply(path2);
            Objects.requireNonNull(file, "Cannot find created by NIO file");
            return new UniqueResponseFile(HttpRequestSaveFileUtil.toPresentableHistoryPath(path2, ignoredPrefix), file);
        }
        Path parent = path2.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            NioFiles.createDirectories((Path)parent);
        }
        String newName = HttpRequestSaveFileUtil.createUniqueFileNameFromFullFileName(parent, path2.getFileName().toString());
        Path resultFile4 = HttpRequestSaveFileUtil.ensureChildExists(parent, newName);
        VirtualFile file = vFileProvider.apply(resultFile4);
        return new UniqueResponseFile(HttpRequestSaveFileUtil.toPresentableHistoryPath(resultFile4, ignoredPrefix), file);
    }

    @NotNull
    private static Path ensureChildExists(@NotNull Path root, @NotNull String fileName) throws IOException {
        Path resultFile2;
        if (root == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(7);
        }
        if (fileName == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(8);
        }
        if (!Files.exists(resultFile2 = root.resolve(fileName), new LinkOption[0])) {
            Files.createFile(resultFile2, new FileAttribute[0]);
        }
        Path path2 = resultFile2;
        if (path2 == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(9);
        }
        return path2;
    }

    @NotNull
    private static String toPresentableHistoryPath(@NotNull Path path2, String prefix) {
        if (path2 == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(10);
        }
        String string = StringUtil.trimStart((String)path2.normalize().toString(), (String)prefix);
        if (string == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static String unique(@NotNull Path root, @NotNull String status, @NotNull String timestamp, @NotNull CommonClientResponseBody body2, boolean isForce) {
        String fileNameHint;
        if (root == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(12);
        }
        if (status == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(13);
        }
        if (timestamp == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(14);
        }
        if (body2 == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(15);
        }
        if ((fileNameHint = (String)ObjectUtils.doIfNotNull((Object)body2.getFileHint(), CommonClientBodyFileHint::getFileNameHint)) != null && !isForce) {
            return HttpRequestSaveFileUtil.createUniqueFileNameFromFullFileName(root, fileNameHint);
        }
        if (fileNameHint != null) {
            String string = fileNameHint;
            if (string == null) {
                HttpRequestSaveFileUtil.$$$reportNull$$$0(16);
            }
            return string;
        }
        String extensionHint = (String)ObjectUtils.doIfNotNull((Object)body2.getFileHint(), CommonClientBodyFileHint::getFileExtensionHint);
        String fileExtension = extensionHint != null ? extensionHint : (body2 instanceof CommonClientResponseBody.Text ? "txt" : "");
        return HttpRequestSaveFileUtil.generateUniqueName(root, () -> PathUtil.makeFileName((String)(timestamp + "." + status), (String)fileExtension), counter -> PathUtil.makeFileName((String)(timestamp + "-" + counter + "." + status), (String)fileExtension));
    }

    @NotNull
    private static String createUniqueFileNameFromFullFileName(@NotNull Path root, String fileName) {
        String extension;
        String name;
        int extDot;
        if (root == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(17);
        }
        if ((extDot = fileName.lastIndexOf(".")) != -1) {
            name = fileName.substring(0, extDot);
            extension = fileName.substring(extDot + 1);
        } else {
            name = fileName;
            extension = "";
        }
        return HttpRequestSaveFileUtil.generateUniqueName(root, () -> fileName, counter -> PathUtil.makeFileName((String)(name + "-" + counter), (String)extension));
    }

    @NotNull
    private static String generateUniqueName(@NotNull Path root, @NotNull Supplier<String> nameProvider, @NotNull IntFunction<String> nameWithCounterProvider) {
        String fileName;
        if (root == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(18);
        }
        if (nameProvider == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(19);
        }
        if (nameWithCounterProvider == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(20);
        }
        if (!Files.exists(root.resolve(fileName = nameProvider.get()), new LinkOption[0])) {
            String string = fileName;
            if (string == null) {
                HttpRequestSaveFileUtil.$$$reportNull$$$0(21);
            }
            return string;
        }
        int counter = 1;
        while (Files.exists(root.resolve(fileName), new LinkOption[0])) {
            fileName = nameWithCounterProvider.apply(counter);
            ++counter;
        }
        String string = fileName;
        if (string == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public static String convertTimeToFileName(long startTimeMs) {
        Date date = new Date(startTimeMs);
        String string = DATE_FORMAT.format(date) + "T" + TIME_FORMAT.format(date);
        if (string == null) {
            HttpRequestSaveFileUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 11, 16, 21, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: 
            case 7: 
            case 12: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestamp";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredPrefix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFileProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 9: 
            case 11: 
            case 16: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/HttpRequestSaveFileUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameProvider";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameWithCounterProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRequestSaveFileUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureChildExists";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableHistoryPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "unique";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "generateUniqueName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "convertTimeToFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUniqueFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ensureChildExists";
                break;
            }
            case 9: 
            case 11: 
            case 16: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "toPresentableHistoryPath";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "unique";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createUniqueFileNameFromFullFileName";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "generateUniqueName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 11, 16, 21, 22, 23 -> new IllegalStateException(string);
        };
    }

    public record UniqueResponseFile(String fileName, VirtualFile virtualFile) {
    }
}

