/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.httpClient.http.request.HttpVariableNameInfo;
import com.intellij.httpClient.http.request.run.HttpClientJsonVariablesHelperKt;
import com.intellij.httpClient.http.request.run.HttpRequestExecutionHelperService;
import com.intellij.httpClient.http.request.variables.HttpListVariableSubstitutionInfo;
import com.intellij.httpClient.http.request.variables.HttpSingleVariableSubstitutionInfo;
import com.intellij.httpClient.http.request.variables.HttpVariableOrigin;
import com.intellij.httpClient.http.request.variables.HttpVariableSubstitutionInfo;
import com.intellij.httpClient.http.request.variables.HttpVariableValuesProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestGlobalContext
implements HttpVariableValuesProvider {
    private static final Logger LOG = Logger.getInstance(HttpRequestGlobalContext.class);
    private static final Map<String, HttpRequestGlobalContext> ourContexts = new HashMap<String, HttpRequestGlobalContext>();
    private final HttpClientVariables myGlobal = new HttpClientVariables();

    @NotNull
    public static synchronized HttpRequestGlobalContext getInstance(@NotNull Project project) {
        String projectName;
        if (project == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(0);
        }
        if (!ourContexts.containsKey(projectName = HttpRequestGlobalContext.getProjectNameKey(project))) {
            ourContexts.put(projectName, new HttpRequestGlobalContext());
            LOG.info("Global request context for '" + project.getName() + "' was created.");
        }
        HttpRequestGlobalContext httpRequestGlobalContext = ourContexts.get(projectName);
        if (httpRequestGlobalContext == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(1);
        }
        return httpRequestGlobalContext;
    }

    @NotNull
    private static String getProjectNameKey(@NotNull Project project) {
        HttpRequestExecutionHelperService service;
        if (project == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(2);
        }
        return (service = HttpRequestExecutionHelperService.getInstance()) != null ? service.getProjectNameKey(project) : "";
    }

    @Override
    @NotNull
    public List<HttpVariableSubstitutionInfo> getVariablesSubstitutions(@NotNull List<HttpVariableNameInfo> names) {
        if (names == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(3);
        }
        List list2 = ContainerUtil.mapNotNull(names, name -> this.getVariableSubstitutionInfo((HttpVariableNameInfo)name));
        if (list2 == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(4);
        }
        return list2;
    }

    public boolean isEmpty() {
        return this.myGlobal.isEmpty();
    }

    @Nullable
    public String getValue(@NotNull String name) {
        String value2;
        if (name == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(5);
        }
        if ((value2 = this.myGlobal.getAsString(name)) != null) {
            return value2;
        }
        HttpVariableSubstitutionInfo substitutionInfo = this.getVariableSubstitutionInfo(new HttpVariableNameInfo(name, 0));
        if (substitutionInfo == null || substitutionInfo instanceof HttpListVariableSubstitutionInfo) {
            return null;
        }
        return ((HttpSingleVariableSubstitutionInfo)substitutionInfo).getVariableValue();
    }

    public HttpVariableSubstitutionInfo getVariableSubstitutionInfo(HttpVariableNameInfo variableNameInfo) {
        return HttpClientJsonVariablesHelperKt.findVariablesInPotentialJson(variableNameInfo, HttpVariableOrigin.GLOBAL, this.myGlobal.getAllVars());
    }

    @NotNull
    public Collection<String> getAllVariables() {
        Set<String> set2 = this.myGlobal.myVariables.keySet();
        if (set2 == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(6);
        }
        return set2;
    }

    @NotNull
    public HttpClientVariables getGlobal() {
        HttpClientVariables httpClientVariables = this.myGlobal;
        if (httpClientVariables == null) {
            HttpRequestGlobalContext.$$$reportNull$$$0(7);
        }
        return httpClientVariables;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/HttpRequestGlobalContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRequestGlobalContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariablesSubstitutions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllVariables";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProjectNameKey";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVariablesSubstitutions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6, 7 -> new IllegalStateException(string);
        };
    }

    public static class HttpClientVariables {
        private final ConcurrentMap<String, Object> myVariables = new ConcurrentHashMap<String, Object>();

        public boolean isEmpty() {
            return this.myVariables.isEmpty();
        }

        public void set(@NotNull String name, @Nullable Object value2) {
            if (name == null) {
                HttpClientVariables.$$$reportNull$$$0(0);
            }
            Object stringValue = value2 == null ? "null" : value2;
            this.myVariables.put(name, stringValue);
        }

        @Nullable
        public Object get(@NotNull String name) {
            if (name == null) {
                HttpClientVariables.$$$reportNull$$$0(1);
            }
            return this.myVariables.get(name);
        }

        @Nullable
        public String getAsString(@NotNull String name) {
            Object value2;
            if (name == null) {
                HttpClientVariables.$$$reportNull$$$0(2);
            }
            return (value2 = this.myVariables.get(name)) != null ? HttpClientJsonVariablesHelperKt.convertToJsonIfNeeded(value2) : null;
        }

        public Map<String, Object> getAllVars() {
            return this.myVariables;
        }

        public void clear(@NotNull String name) {
            if (name == null) {
                HttpClientVariables.$$$reportNull$$$0(3);
            }
            this.myVariables.remove(name);
        }

        public void clearAll() {
            this.myVariables.clear();
        }

        public String toString() {
            return this.myVariables.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "name";
            objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRequestGlobalContext$HttpClientVariables";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "set";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAsString";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clear";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class HttpRequestGlobalContextProjectListener
    implements ProjectCloseListener {
        HttpRequestGlobalContextProjectListener() {
        }

        public void projectClosing(@NotNull Project project) {
            String closedProjectName;
            if (project == null) {
                HttpRequestGlobalContextProjectListener.$$$reportNull$$$0(0);
            }
            if (ourContexts.containsKey(closedProjectName = HttpRequestGlobalContext.getProjectNameKey(project))) {
                LOG.info("Global request context for '" + project.getName() + "' was disposed.");
                ourContexts.remove(closedProjectName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/httpClient/http/request/run/HttpRequestGlobalContext$HttpRequestGlobalContextProjectListener", "projectClosing"));
        }
    }
}

