/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.intellij.httpClient.http.request.HttpVariableNameInfo;
import com.intellij.httpClient.http.request.run.HttpClientJsonVariablesHelperKt;
import com.intellij.httpClient.http.request.variables.HttpListVariableSubstitutionInfo;
import com.intellij.httpClient.http.request.variables.HttpSingleVariableSubstitutionInfo;
import com.intellij.httpClient.http.request.variables.HttpVariableOrigin;
import com.intellij.httpClient.http.request.variables.HttpVariableSubstitutionInfo;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0004\u001a\u0010\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a.\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0013\u001a \u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "asString", "", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "compileJsonPathSafely", "path", "convertToJsonIfNeeded", "value", "", "findVariablesInPotentialJson", "Lcom/intellij/httpClient/http/request/variables/HttpVariableSubstitutionInfo;", "variableNameInfo", "Lcom/intellij/httpClient/http/request/HttpVariableNameInfo;", "variableType", "Lcom/intellij/httpClient/http/request/variables/HttpVariableOrigin;", "allVariables", "", "tryToFindInJson", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nHttpClientJsonVariablesHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientJsonVariablesHelper.kt\ncom/intellij/httpClient/http/request/run/HttpClientJsonVariablesHelperKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1549#2:103\n1620#2,3:104\n*S KotlinDebug\n*F\n+ 1 HttpClientJsonVariablesHelper.kt\ncom/intellij/httpClient/http/request/run/HttpClientJsonVariablesHelperKt\n*L\n72#1:103\n72#1:104,3\n*E\n"})
public final class HttpClientJsonVariablesHelperKt {
    private static final Logger logger = Logger.getLogger("HttpClientJsonVariablesHelper.kt");

    @Nullable
    public static final String compileJsonPathSafely(@NotNull String path2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        try {
            string = JsonPath.compile(path2, new Predicate[0]).getPath();
        }
        catch (Exception e) {
            logger.fine("Failed to compile jsonPath: " + path2);
            return null;
        }
        return string;
    }

    @Nullable
    public static final HttpVariableSubstitutionInfo findVariablesInPotentialJson(@NotNull HttpVariableNameInfo variableNameInfo, @NotNull HttpVariableOrigin variableType, @NotNull Map<String, ? extends Object> allVariables) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)variableNameInfo, (String)"variableNameInfo");
        Intrinsics.checkNotNullParameter((Object)((Object)variableType), (String)"variableType");
        Intrinsics.checkNotNullParameter(allVariables, (String)"allVariables");
        if (allVariables.isEmpty()) {
            return null;
        }
        String string = HttpClientJsonVariablesHelperKt.compileJsonPathSafely(variableNameInfo.getName());
        if (string == null || (string = StringsKt.removePrefix((String)string, (CharSequence)"$")) == null || (string = StringsKt.removePrefix((String)string, (CharSequence)"..")) == null) {
            return null;
        }
        Regex regex = new Regex("[^\\[|\\]]+");
        String jsonPath = string;
        List keys2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)regex, (CharSequence)jsonPath, (int)0, (int)2, null), (Function1)findVariablesInPotentialJson.keys.1.INSTANCE));
        String string2 = (String)CollectionsKt.firstOrNull((List)keys2);
        if (string2 == null || (string2 = StringsKt.removeSurrounding((String)string2, (CharSequence)"'")) == null) {
            return null;
        }
        String firstKey = string2;
        Object object = allVariables.get(firstKey);
        if (object == null) {
            return null;
        }
        Object value2 = object;
        if (value2 instanceof String) {
            return new HttpSingleVariableSubstitutionInfo(variableNameInfo, variableType, (String)value2);
        }
        try {
            jsonNode = new ObjectMapper().valueToTree(value2);
        }
        catch (Exception e) {
            return null;
        }
        JsonNode tree = jsonNode;
        ObjectNode fullTree = new ObjectMapper().createObjectNode();
        fullTree.set(firstKey, tree);
        Intrinsics.checkNotNull((Object)fullTree);
        return HttpClientJsonVariablesHelperKt.tryToFindInJson(variableNameInfo, (JsonNode)fullTree, variableType);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final HttpVariableSubstitutionInfo tryToFindInJson(@NotNull HttpVariableNameInfo variableNameInfo, @NotNull JsonNode node, @NotNull HttpVariableOrigin variableType) {
        HttpVariableSubstitutionInfo httpVariableSubstitutionInfo;
        Intrinsics.checkNotNullParameter((Object)variableNameInfo, (String)"variableNameInfo");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)((Object)variableType), (String)"variableType");
        Configuration configuration = Configuration.defaultConfiguration().jsonProvider(new JacksonJsonNodeJsonProvider()).mappingProvider(new JacksonMappingProvider());
        try {
            HttpVariableSubstitutionInfo httpVariableSubstitutionInfo2;
            DocumentContext document = JsonPath.using(configuration).parse(node);
            JsonNode result2 = (JsonNode)document.read(variableNameInfo.getName(), new Predicate[0]);
            if (result2.isNull()) {
                return null;
            }
            if (result2 instanceof ArrayNode) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)result2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void jsonNode;
                    JsonNode jsonNode2 = (JsonNode)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)jsonNode);
                    collection.add(HttpClientJsonVariablesHelperKt.asString((JsonNode)jsonNode));
                }
                List values = (List)destination$iv$iv;
                httpVariableSubstitutionInfo2 = new HttpListVariableSubstitutionInfo(variableNameInfo, variableType, values);
            } else {
                Intrinsics.checkNotNull((Object)result2);
                httpVariableSubstitutionInfo2 = new HttpSingleVariableSubstitutionInfo(variableNameInfo, variableType, HttpClientJsonVariablesHelperKt.asString(result2));
            }
            httpVariableSubstitutionInfo = httpVariableSubstitutionInfo2;
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Could not process jsonPath: " + variableNameInfo + ", variable type: " + variableType + ", failed: " + e.getMessage());
            httpVariableSubstitutionInfo = null;
        }
        return httpVariableSubstitutionInfo;
    }

    private static final String asString(JsonNode node) {
        String string;
        JsonNode jsonNode = node;
        if (jsonNode instanceof TextNode) {
            String string2 = node.asText();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asText(...)");
        } else if (jsonNode instanceof NumericNode) {
            String string3 = node.asText();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asText(...)");
        } else if (jsonNode instanceof BooleanNode) {
            String string4 = node.asText();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asText(...)");
        } else {
            String string5 = node.toPrettyString();
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toPrettyString(...)");
        }
        return string;
    }

    @NotNull
    public static final String convertToJsonIfNeeded(@Nullable Object value2) {
        String string;
        if (value2 == null) {
            return "null";
        }
        if (value2 instanceof CharSequence) {
            return value2.toString();
        }
        try {
            string = new ObjectMapper().writeValueAsString(value2);
            Intrinsics.checkNotNull((Object)string);
        }
        catch (JsonProcessingException e) {
            string = value2.toString();
        }
        return string;
    }
}

