/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.psi.codeStyle;

import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.httpClient.http.request.psi.codeStyle.HttpRequestBaseBlock;
import com.intellij.httpClient.http.request.psi.codeStyle.HttpRequestScriptBodyBlock;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u001c\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\bH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/httpClient/http/request/psi/codeStyle/HttpHandlerScriptBlock;", "Lcom/intellij/httpClient/http/request/psi/codeStyle/HttpRequestBaseBlock;", "node", "Lcom/intellij/lang/ASTNode;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/psi/codeStyle/CodeStyleSettings;)V", "createBlock", "Lcom/intellij/formatting/Block;", "getSpacing", "Lcom/intellij/formatting/Spacing;", "child1", "child2", "getWrap", "Lcom/intellij/formatting/Wrap;", "intellij.restClient"})
public final class HttpHandlerScriptBlock
extends HttpRequestBaseBlock {
    @NotNull
    private final CodeStyleSettings settings;

    public HttpHandlerScriptBlock(@NotNull ASTNode node, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(node);
        this.settings = settings;
    }

    @Nullable
    public Wrap getWrap() {
        return null;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child2");
        if (child1 instanceof HttpRequestScriptBodyBlock && !((HttpRequestScriptBodyBlock)child1).getTextRange().isEmpty() || child2 instanceof HttpRequestScriptBodyBlock && !((HttpRequestScriptBodyBlock)child2).getTextRange().isEmpty()) {
            return Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)true, (int)1, (int)1);
        }
        return null;
    }

    @Override
    @NotNull
    protected Block createBlock(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)HttpRequestElementTypes.SCRIPT_BODY)) {
            return (Block)new HttpRequestScriptBodyBlock(node, this.settings);
        }
        Block block = super.createBlock(node);
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"createBlock(...)");
        return block;
    }
}

