/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.highlighting;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestPsiFactory;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocTimeoutTag;
import com.intellij.httpClient.http.request.highlighting.HttpClientAdditionalSyntaxAnnotator;
import com.intellij.httpClient.http.request.highlighting.HttpRequestSyntaxHighlighter;
import com.intellij.httpClient.http.request.psi.HttpFileVariable;
import com.intellij.httpClient.http.request.psi.HttpFileVariableName;
import com.intellij.httpClient.http.request.variables.HttpClientFileVariableStorage;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/httpClient/http/request/highlighting/HttpClientAdditionalSyntaxAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientAdditionalSyntaxAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientAdditionalSyntaxAnnotator.kt\ncom/intellij/httpClient/http/request/highlighting/HttpClientAdditionalSyntaxAnnotator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public final class HttpClientAdditionalSyntaxAnnotator
implements Annotator,
DumbAware {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Object[] objectArray;
        PsiElement nameIdentifier;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (element instanceof HttpFileVariableName && (nameIdentifier = ((HttpFileVariableName)element).getFirstChild()) != null) {
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(nameIdentifier).textAttributes(HttpRequestSyntaxHighlighter.HTTP_REQUEST_FILE_VARIABLE_NAME).create();
        }
        if (element instanceof HttpFileVariable) {
            String string = ((HttpFileVariable)element).getName();
            if (string == null) {
                return;
            }
            String name = string;
            PsiElement psiElement = ((HttpFileVariable)element).getNameIdentifier();
            if (psiElement == null) {
                return;
            }
            PsiElement nameIdentifier2 = psiElement;
            PsiFile psiFile = ((HttpFileVariable)element).getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            if (HttpClientFileVariableStorage.Companion.findVariableIn(psiFile, name).size() <= 1) {
                return;
            }
            objectArray = new Object[]{name};
            holder.newAnnotation(HighlightSeverity.ERROR, RestClientBundle.message("http.client.multiple.declaration.error", objectArray)).range(nameIdentifier2).withFix((CommonIntentionAction)new PsiUpdateModCommandAction<HttpFileVariable>(element, name){
                final /* synthetic */ PsiElement $element;
                final /* synthetic */ String $name;
                {
                    this.$element = $element;
                    this.$name = $name;
                    super($element);
                }

                @NotNull
                public String getFamilyName() {
                    String string = RestClientBundle.message("http.client.multiple.declaration.error.fix", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return string;
                }

                protected void invoke(@NotNull ActionContext context, @NotNull HttpFileVariable element, @NotNull ModPsiUpdater updater) {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
                    List<String> suggestName2 = this.suggestName();
                    PsiElement psiElement = HttpRequestPsiFactory.createVariableIdentifier(context.project(), suggestName2.get(0));
                    Intrinsics.checkNotNull((Object)psiElement);
                    PsiElement newName = psiElement;
                    PsiElement psiElement2 = element.getNameIdentifier();
                    Intrinsics.checkNotNull((Object)psiElement2);
                    PsiElement newIdentifier = psiElement2.replace(newName);
                    updater.templateBuilder().field(newIdentifier, (Expression)new ConstantNode(suggestName2.get(0)).withLookupStrings((Collection)suggestName2));
                }

                private final List<String> suggestName() {
                    return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.take((Sequence)SequencesKt.filter((Sequence)SequencesKt.generateSequence((Object)1, (Function1)annotate.suggestName.1.INSTANCE), (Function1)((Function1)new Function1<Integer, Boolean>(this.$element, this.$name){
                        final /* synthetic */ PsiElement $element;
                        final /* synthetic */ String $name;
                        {
                            this.$element = $element;
                            this.$name = $name;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(int it) {
                            PsiFile psiFile = ((HttpFileVariable)this.$element).getContainingFile();
                            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                            return HttpClientFileVariableStorage.Companion.findVariableIn(psiFile, this.$name + it).isEmpty();
                        }
                    })), (int)2), (Function1)((Function1)new Function1<Integer, String>(this.$name){
                        final /* synthetic */ String $name;
                        {
                            this.$name = $name;
                            super(1);
                        }

                        @NotNull
                        public final String invoke(int it) {
                            return this.$name + it;
                        }
                    })));
                }
            }).create();
        }
        if (element instanceof HttpDocTimeoutTag) {
            Object object;
            HttpClientAdditionalSyntaxAnnotator httpClientAdditionalSyntaxAnnotator = this;
            try {
                HttpClientAdditionalSyntaxAnnotator $this$annotate_u24lambda_u240 = httpClientAdditionalSyntaxAnnotator;
                boolean bl = false;
                object = Result.constructor-impl((Object)((HttpDocTimeoutTag)element).getDurationInMillis());
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            objectArray = Result.exceptionOrNull-impl((Object)object);
            HttpDocTimeoutTag.InvalidDurationException invalidDurationException = objectArray instanceof HttpDocTimeoutTag.InvalidDurationException ? (HttpDocTimeoutTag.InvalidDurationException)objectArray : null;
            if (invalidDurationException == null) {
                return;
            }
            HttpDocTimeoutTag.InvalidDurationException error = invalidDurationException;
            PsiElement psiElement = ((HttpDocTimeoutTag)element).getValueElement();
            if (psiElement == null) {
                psiElement = ((HttpDocTimeoutTag)element).getFirstChild();
            }
            PsiElement errorElement = psiElement;
            holder.newAnnotation(HighlightSeverity.ERROR, error.getMessage()).range(errorElement).create();
        }
    }
}

