/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.completion.provider;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.httpClient.http.request.HttpRequestFileType;
import com.intellij.httpClient.http.request.completion.provider.HttpDynamicVariableCompletionProvider;
import com.intellij.httpClient.http.request.completion.provider.HttpEnvironmentVariableCompletionProvider;
import com.intellij.httpClient.http.request.completion.provider.HttpVariableCompletionProvider;
import com.intellij.httpClient.http.request.completion.provider.HttpVariableCompletionProviderKt;
import com.intellij.httpClient.http.request.dynamicVariables.HttpClientDynamicVariableDescription;
import com.intellij.httpClient.http.request.environment.HttpClientEnvironmentsProvider;
import com.intellij.httpClient.http.request.psi.HttpMessageBody;
import com.intellij.httpClient.http.request.psi.HttpOutputFilePath;
import com.intellij.httpClient.http.request.psi.HttpVariable;
import com.intellij.httpClient.http.request.run.HttpRequestGlobalContext;
import com.intellij.httpClient.http.request.variables.HttpClientFileVariableStorage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u001e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\f\u0010\u0017\u001a\u00020\u0015*\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/httpClient/http/request/completion/provider/HttpEnvironmentVariableCompletionProvider;", "Lcom/intellij/httpClient/http/request/completion/provider/HttpVariableCompletionProvider;", "()V", "addCompletions", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "element", "Lcom/intellij/psi/PsiElement;", "variableNameOffset", "", "context", "Lcom/intellij/util/ProcessingContext;", "fillEnvironmentVariables", "variables", "", "", "fillVariables", "isApplicable", "", "retrieveHostElement", "isHttpFile", "Lcom/intellij/psi/PsiFile;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpVariableCompletionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpVariableCompletionProvider.kt\ncom/intellij/httpClient/http/request/completion/provider/HttpEnvironmentVariableCompletionProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,189:1\n1#2:190\n*E\n"})
final class HttpEnvironmentVariableCompletionProvider
extends HttpVariableCompletionProvider {
    private final boolean isApplicable(CompletionParameters parameters) {
        Project project = parameters.getEditor().getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        InjectedLanguageManager inject = InjectedLanguageManager.getInstance((Project)project2);
        PsiFile psiFile = inject.getTopLevelFile((PsiElement)parameters.getOriginalFile());
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getTopLevelFile(...)");
        return this.isHttpFile(psiFile);
    }

    private final boolean isHttpFile(PsiFile $this$isHttpFile) {
        return Intrinsics.areEqual((Object)$this$isHttpFile.getFileType(), (Object)((Object)HttpRequestFileType.INSTANCE));
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            if (!this.isApplicable(parameters)) {
                return;
            }
            PsiElement psiElement = this.retrieveHostElement(parameters);
            if (psiElement == null) break block1;
            PsiElement it = psiElement;
            boolean bl = false;
            this.fillVariables(it, result2);
        }
    }

    @Override
    public void addCompletions(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, @NotNull PsiElement element, int variableNameOffset) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.fillVariables(element, result2);
    }

    private final PsiElement retrieveHostElement(CompletionParameters parameters) {
        PsiFile psiFile = parameters.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile originalFile = psiFile;
        Editor editor2 = parameters.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        Project project = editor3.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        InjectedLanguageManager inject = InjectedLanguageManager.getInstance((Project)project2);
        PsiLanguageInjectionHost host = inject.getInjectionHost((PsiElement)originalFile);
        return host instanceof HttpVariable ? (PsiElement)host : (host instanceof HttpMessageBody ? (PsiElement)host : null);
    }

    private final void fillVariables(PsiElement element, CompletionResultSet result2) {
        PsiFile psiFile = element.getContainingFile().getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile originalFile = psiFile;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Set variables2 = StreamEx.of((Collection)HttpClientEnvironmentsProvider.INSTANCE.provideEnvironments(originalFile).asList()).flatCollection(arg_0 -> HttpEnvironmentVariableCompletionProvider.fillVariables$lambda$1(fillVariables.variables.1.INSTANCE, arg_0)).toSet();
        List<String> fileVariables = HttpClientFileVariableStorage.Companion.listVariables(originalFile);
        HashSet declaredVariable = new HashSet(variables2);
        declaredVariable.addAll(fileVariables);
        this.fillEnvironmentVariables(result2, declaredVariable);
        Collection<String> collection = HttpRequestGlobalContext.getInstance(project2).getAllVariables();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getAllVariables(...)");
        this.fillEnvironmentVariables(result2, collection);
        HttpDynamicVariableCompletionProvider dynamicProvider = new HttpDynamicVariableCompletionProvider();
        dynamicProvider.fillDynamicVariables(result2, HttpClientDynamicVariableDescription.Position.ALL, true);
        if (PsiTreeUtil.getParentOfType((PsiElement)element, HttpOutputFilePath.class, (boolean)false) != null) {
            dynamicProvider.fillDynamicVariables(result2, HttpClientDynamicVariableDescription.Position.IN_FILE_PATH, true);
        }
    }

    private final void fillEnvironmentVariables(CompletionResultSet result2, Collection<String> variables2) {
        for (String var : variables2) {
            result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)LookupElementBuilder.create((String)var).withIcon(IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Variable)).withInsertHandler((InsertHandler)HttpVariableCompletionProviderKt.access$getVARIABLE_SUFFIX_HANDLER$p())), (double)20.0));
        }
    }

    private static final Collection fillVariables$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Collection)$tmp0.invoke(p0);
    }
}

