/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.executor.graphql.request.ws;

import com.intellij.httpClient.executor.graphql.request.ws.GraphQLAwsAppSyncOverWsProtocol;
import com.intellij.httpClient.executor.graphql.request.ws.GraphQLAwsAppSyncOverWsProtocolKt;
import com.intellij.httpClient.executor.util.json.JsonObject;
import com.intellij.httpClient.http.request.HttpRequestHeadersBuilder;
import com.intellij.httpClient.http.request.HttpRequestUrlAccessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.util.text.StringUtil;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IntellijInternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/httpClient/executor/graphql/request/ws/GraphQLAwsAppSyncOverWsProtocol;", "", "header", "Lcom/intellij/httpClient/executor/util/json/JsonObject;", "(Lcom/intellij/httpClient/executor/util/json/JsonObject;)V", "getMessage", "", "graphql", "Companion", "intellij.httpClient.executor"})
@ApiStatus.Internal
public final class GraphQLAwsAppSyncOverWsProtocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonObject header;
    @NotNull
    public static final String PROTOCOL_ID = "aws-app-sync";
    @NotNull
    private static final String DATE_PROP = "x-amz-date";
    @NotNull
    private static final String AMZ_HEADER_QUERY = "header";
    @NotNull
    private static final String AMZ_PAYLOAD_QUERY = "payload";
    @NotNull
    private static final Lazy<DateTimeFormatter> dateFormat$delegate = LazyKt.lazy((Function0)Companion.dateFormat.2.INSTANCE);

    private GraphQLAwsAppSyncOverWsProtocol(JsonObject header2) {
        this.header = header2;
    }

    @NotNull
    public final String getMessage(@NotNull String graphql) {
        Intrinsics.checkNotNullParameter((Object)graphql, (String)"graphql");
        char[] cArray = new char[]{'\\', '\"'};
        String string = StringUtil.escapeChars((String)graphql, (char[])cArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeChars(...)");
        String data = string;
        return StringsKt.trimIndent((String)("\n      {\n        \"id\": \"" + UUID.randomUUID() + "\",\n        \"type\": \"start\",\n        \"payload\": {\n          \"data\": \"" + data + "\",\n          \"extensions\": {\n            \"authorization\": " + this.header.getText() + "\n          }\n        }\n      }\n    "));
    }

    public /* synthetic */ GraphQLAwsAppSyncOverWsProtocol(JsonObject header2, DefaultConstructorMarker $constructor_marker) {
        this(header2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/httpClient/executor/graphql/request/ws/GraphQLAwsAppSyncOverWsProtocol$Companion;", "", "()V", "AMZ_HEADER_QUERY", "", "AMZ_PAYLOAD_QUERY", "DATE_PROP", "PROTOCOL_ID", "dateFormat", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getDateFormat", "()Ljava/time/format/DateTimeFormatter;", "dateFormat$delegate", "Lkotlin/Lazy;", "create", "Lcom/intellij/httpClient/executor/graphql/request/ws/GraphQLAwsAppSyncOverWsProtocol;", "header", "project", "Lcom/intellij/openapi/project/Project;", "prepareUrlAndHeadersForAws", "url", "Lcom/intellij/httpClient/http/request/HttpRequestUrlAccessor;", "headers", "Lcom/intellij/httpClient/http/request/HttpRequestHeadersBuilder;", "intellij.httpClient.executor"})
    @SourceDebugExtension(value={"SMAP\nGraphQLAwsAppSyncOverWsProtocol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphQLAwsAppSyncOverWsProtocol.kt\ncom/intellij/httpClient/executor/graphql/request/ws/GraphQLAwsAppSyncOverWsProtocol$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final GraphQLAwsAppSyncOverWsProtocol create(@Nullable String header2, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String string = header2;
            Object object = string;
            if (string == null) return null;
            Object it = object;
            boolean bl = false;
            JsonObject jsonObject = GraphQLAwsAppSyncOverWsProtocolKt.access$parseAwsRequestHeader(header2, project);
            object = jsonObject;
            if (jsonObject == null) return null;
            it = object;
            boolean bl2 = false;
            GraphQLAwsAppSyncOverWsProtocol graphQLAwsAppSyncOverWsProtocol = new GraphQLAwsAppSyncOverWsProtocol((JsonObject)it, null);
            return graphQLAwsAppSyncOverWsProtocol;
        }

        private final DateTimeFormatter getDateFormat() {
            Lazy lazy = dateFormat$delegate;
            return (DateTimeFormatter)lazy.getValue();
        }

        @Nullable
        public final GraphQLAwsAppSyncOverWsProtocol prepareUrlAndHeadersForAws(@NotNull Project project, @NotNull HttpRequestUrlAccessor url, @NotNull HttpRequestHeadersBuilder headers2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)headers2, (String)"headers");
            String string = url.getQuery(GraphQLAwsAppSyncOverWsProtocol.AMZ_HEADER_QUERY);
            if (string == null) {
                string = "";
            }
            Object header2 = string;
            headers2.setHeader("Sec-WebSocket-Protocol", "graphql-ws");
            if (StringsKt.startsWith$default((String)header2, (String)"{", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)((CharSequence)header2), (CharSequence)GraphQLAwsAppSyncOverWsProtocol.DATE_PROP, (boolean)false, (int)2, null)) {
                String now = this.getDateFormat().format(OffsetDateTime.now().atZoneSimilarLocal(ZoneId.of("GMT-0")));
                String dateField = ",\"x-amz-date\": \"" + now + "\" ";
                String string2 = ((String)header2).substring(0, ((String)header2).length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                header2 = string2 + dateField + "}";
                Base64.Encoder encoder = Base64.getUrlEncoder();
                byte[] byArray = ((String)header2).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                String string3 = encoder.encodeToString(byArray);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"encodeToString(...)");
                url.setQuery(GraphQLAwsAppSyncOverWsProtocol.AMZ_HEADER_QUERY, string3);
            }
            if (url.getQuery(GraphQLAwsAppSyncOverWsProtocol.AMZ_PAYLOAD_QUERY) == null) {
                Base64.Encoder encoder = Base64.getUrlEncoder();
                byte[] byArray = "{}".getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                String string4 = encoder.encodeToString(byArray);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"encodeToString(...)");
                url.setQuery(GraphQLAwsAppSyncOverWsProtocol.AMZ_PAYLOAD_QUERY, string4);
            } else {
                String string5 = url.getQuery(GraphQLAwsAppSyncOverWsProtocol.AMZ_PAYLOAD_QUERY);
                boolean bl = string5 != null ? StringsKt.startsWith$default((String)string5, (String)"{", (boolean)false, (int)2, null) : false;
                if (bl) {
                    String string6 = url.getQuery(GraphQLAwsAppSyncOverWsProtocol.AMZ_PAYLOAD_QUERY);
                    Intrinsics.checkNotNull((Object)string6);
                    String payload2 = string6;
                    Base64.Encoder encoder = Base64.getUrlEncoder();
                    byte[] byArray = payload2.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    String string7 = encoder.encodeToString(byArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"encodeToString(...)");
                    url.setQuery(GraphQLAwsAppSyncOverWsProtocol.AMZ_PAYLOAD_QUERY, string7);
                }
            }
            return this.create((String)header2, project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

