/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.impl.engineV2;

import com.intellij.codeWithMe.ClientId;
import com.intellij.httpClient.execution.HttpClientDnsResolverProvider;
import com.intellij.httpClient.execution.HttpRequestConfig;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.impl.HttpRequestHandlerUtil;
import com.intellij.httpClient.execution.impl.engineV2.CustomizedDnsResolverNettyGroup;
import com.intellij.httpClient.execution.impl.engineV2.NettyHttpClientKt;
import com.intellij.httpClient.execution.impl.engineV2.NettyProtocolConfigurator;
import com.intellij.httpClient.execution.impl.engineV2.NettySslConfigurationTarget;
import com.intellij.httpClient.execution.ssl.SslConfiguration;
import com.intellij.httpClient.http.request.HttpClientEventLoopHolder;
import com.intellij.httpClient.http.request.run.HttpRequestExecutionHelperService;
import com.intellij.openapi.application.ApplicationManager;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.tcp.SslProvider;
import reactor.netty.transport.ProxyProvider;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\r\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u0006H\u0002\u001a\u001c\u0010\u000e\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u001a.\u0010\u000f\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u00062\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002\u001a\u001c\u0010\u0015\u001a\u00060\u0005j\u0002`\u0006*\u00060\u0005j\u0002`\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000*\n\u0010\u0018\"\u00020\u00052\u00020\u0005\u00a8\u0006\u0019"}, d2={"HTTP_2", "Lio/netty/handler/codec/http/HttpVersion;", "HTTP_CLIENT_RESPONSE_LISTENER", "", "createReactorNettyClient", "Lreactor/netty/http/client/HttpClient;", "Lcom/intellij/httpClient/execution/impl/engineV2/ReactorHttpClient;", "request", "Lcom/intellij/httpClient/execution/RestClientRequest;", "url", "Ljava/net/URL;", "normalizedProtocolPresentation", "protocol", "configureDefaultResolver", "configureProxy", "configureSsl", "protocols", "Lcom/intellij/httpClient/execution/impl/engineV2/NettyProtocolConfigurator;", "sslConfiguration", "Lcom/intellij/httpClient/execution/ssl/SslConfiguration;", "host", "configureTimeouts", "config", "Lcom/intellij/httpClient/execution/HttpRequestConfig;", "ReactorHttpClient", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nNettyHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyHttpClient.kt\ncom/intellij/httpClient/execution/impl/engineV2/NettyHttpClientKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,260:1\n1#2:261\n40#3,3:262\n*S KotlinDebug\n*F\n+ 1 NettyHttpClient.kt\ncom/intellij/httpClient/execution/impl/engineV2/NettyHttpClientKt\n*L\n53#1:262,3\n*E\n"})
public final class NettyHttpClientKt {
    @NotNull
    private static final HttpVersion HTTP_2;
    @NotNull
    private static final String HTTP_CLIENT_RESPONSE_LISTENER = "IntelliJHttpClientResponseListener";

    @NotNull
    public static final HttpClient createReactorNettyClient(@NotNull RestClientRequest request2, @NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        NettyProtocolConfigurator protocolsConfigurator = new NettyProtocolConfigurator(Intrinsics.areEqual((Object)url.getProtocol(), (Object)"https"), request2.protocol);
        HttpClient it = HttpClient.create(((ConnectionProvider.Builder)ConnectionProvider.builder("IJ HTTP Client").maxConnections(1)).build()).disableRetry(true);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        HttpClient httpClient = protocolsConfigurator.configureProtocols(it).compress(true);
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"compress(...)");
        boolean $i$f$service = false;
        Class<HttpClientEventLoopHolder> serviceClass$iv = HttpClientEventLoopHolder.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        Object t = NettyHttpClientKt.configureDefaultResolver(httpClient).runOn((EventLoopGroup)((HttpClientEventLoopHolder)object).eventLoop);
        Intrinsics.checkNotNullExpressionValue(t, (String)"runOn(...)");
        HttpClient httpClient2 = NettyHttpClientKt.configureProxy((HttpClient)t, url);
        SslConfiguration sslConfiguration = request2.sslConfiguration;
        String string = url.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        HttpClient httpClient3 = NettyHttpClientKt.configureSsl(httpClient2, protocolsConfigurator, sslConfiguration, string);
        HttpRequestConfig httpRequestConfig = request2.config;
        Intrinsics.checkNotNullExpressionValue((Object)httpRequestConfig, (String)"config");
        HttpClient httpClient4 = NettyHttpClientKt.configureTimeouts(httpClient3, httpRequestConfig).doOnResponseError((arg_0, arg_1) -> NettyHttpClientKt.createReactorNettyClient$lambda$1(createReactorNettyClient.2.INSTANCE, arg_0, arg_1)).doOnRequest((arg_0, arg_1) -> NettyHttpClientKt.createReactorNettyClient$lambda$2(createReactorNettyClient.3.INSTANCE, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)httpClient4, (String)"doOnRequest(...)");
        return httpClient4;
    }

    private static final HttpClient configureProxy(HttpClient $this$configureProxy, URL url) {
        ProxyProvider.Proxy proxy;
        Proxy proxy2;
        HttpRequestExecutionHelperService executionHelperService;
        URI uri = url.toURI();
        HttpRequestExecutionHelperService httpRequestExecutionHelperService = executionHelperService = HttpRequestExecutionHelperService.getInstance();
        List list2 = httpRequestExecutionHelperService != null ? httpRequestExecutionHelperService.getProxy(uri) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        if ((proxy2 = (Proxy)CollectionsKt.firstOrNull(list2)) == null) {
            return $this$configureProxy;
        }
        if (Intrinsics.areEqual((Object)proxy2, (Object)Proxy.NO_PROXY)) {
            return $this$configureProxy;
        }
        Proxy.Type type = proxy2.type();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                proxy = ProxyProvider.Proxy.HTTP;
                break;
            }
            case 2: {
                proxy = ProxyProvider.Proxy.SOCKS5;
                break;
            }
            case 3: {
                return $this$configureProxy;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ProxyProvider.Proxy type2 = proxy;
        SocketAddress socketAddress = proxy2.address();
        Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
        InetSocketAddress proxyAddress = (InetSocketAddress)socketAddress;
        HttpRequestExecutionHelperService httpRequestExecutionHelperService2 = executionHelperService;
        if (httpRequestExecutionHelperService2 != null) {
            httpRequestExecutionHelperService2.initProxy();
        }
        PasswordAuthentication usernameAndPassword = type2 == ProxyProvider.Proxy.SOCKS5 ? Authenticator.requestPasswordAuthentication(proxyAddress.getHostString(), proxyAddress.getAddress(), proxyAddress.getPort(), "SOCKS5", "SOCKS authentication", null) : Authenticator.requestPasswordAuthentication(proxyAddress.getHostString(), null, proxyAddress.getPort(), "http", "Authentication for http proxy", null, url, Authenticator.RequestorType.PROXY);
        Object t = ((HttpClient)$this$configureProxy.proxy(arg_0 -> NettyHttpClientKt.configureProxy$lambda$3((Function1)new Function1<ProxyProvider.TypeSpec, Unit>(type2, proxyAddress, usernameAndPassword){
            final /* synthetic */ ProxyProvider.Proxy $type;
            final /* synthetic */ InetSocketAddress $proxyAddress;
            final /* synthetic */ PasswordAuthentication $usernameAndPassword;
            {
                this.$type = $type;
                this.$proxyAddress = $proxyAddress;
                this.$usernameAndPassword = $usernameAndPassword;
                super(1);
            }

            public final void invoke(ProxyProvider.TypeSpec spec) {
                ProxyProvider.Builder spec2 = spec.type(this.$type).address(this.$proxyAddress);
                if (this.$usernameAndPassword != null) {
                    spec2.username(this.$usernameAndPassword.getUserName()).password(arg_0 -> configureProxy.1.invoke$lambda$0((Function1)new Function1<String, String>(this.$usernameAndPassword){
                        final /* synthetic */ PasswordAuthentication $usernameAndPassword;
                        {
                            this.$usernameAndPassword = $usernameAndPassword;
                            super(1);
                        }

                        public final String invoke(String it) {
                            char[] cArray = this.$usernameAndPassword.getPassword();
                            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
                            char[] cArray2 = cArray;
                            return new String(cArray2);
                        }
                    }, arg_0));
                }
            }

            private static final String invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (String)$tmp0.invoke(p0);
            }
        }, arg_0))).resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(t, (String)"resolver(...)");
        return (HttpClient)t;
    }

    private static final HttpClient configureSsl(HttpClient $this$configureSsl, NettyProtocolConfigurator protocols, SslConfiguration sslConfiguration, String host) {
        if (!protocols.isSecure()) {
            return $this$configureSsl;
        }
        HttpRequestExecutionHelperService executionHelperService = HttpRequestExecutionHelperService.getInstance();
        if (sslConfiguration == null) {
            com.intellij.openapi.util.Pair<KeyManager[], TrustManager> defaultConfiguration;
            HttpRequestExecutionHelperService httpRequestExecutionHelperService = executionHelperService;
            Object object = defaultConfiguration = httpRequestExecutionHelperService != null ? httpRequestExecutionHelperService.getDefaultSslConfiguration() : null;
            if (defaultConfiguration != null) {
                HttpClient httpClient = $this$configureSsl.secure(arg_0 -> NettyHttpClientKt.configureSsl$lambda$4((Function1)new Function1<SslProvider.SslContextSpec, Unit>(protocols, defaultConfiguration){
                    final /* synthetic */ NettyProtocolConfigurator $protocols;
                    final /* synthetic */ com.intellij.openapi.util.Pair<KeyManager[], TrustManager> $defaultConfiguration;
                    {
                        this.$protocols = $protocols;
                        this.$defaultConfiguration = $defaultConfiguration;
                        super(1);
                    }

                    public final void invoke(SslProvider.SslContextSpec spec) {
                        spec.sslContext(this.$protocols.getSslContextSpec().configure(arg_0 -> configureSsl.1.invoke$lambda$1(this.$defaultConfiguration, arg_0)));
                    }

                    private static final void invoke$lambda$1(com.intellij.openapi.util.Pair $defaultConfiguration, SslContextBuilder builder2) {
                        block0: {
                            builder2.sslProvider(SslProvider.JDK).trustManager((TrustManager)$defaultConfiguration.second);
                            Object object = (KeyManager[])$defaultConfiguration.first;
                            if (object == null || (object = (KeyManager)ArraysKt.firstOrNull((Object[])object)) == null) break block0;
                            Object keyManager = object;
                            boolean bl = false;
                            builder2.keyManager((KeyManager)keyManager);
                        }
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"secure(...)");
                return httpClient;
            }
            return $this$configureSsl;
        }
        Pair pair = (Pair)sslConfiguration.applyTo(new NettySslConfigurationTarget());
        KeyManagerFactory keyManager = (KeyManagerFactory)pair.component1();
        TrustManagerFactory trustManager = (TrustManagerFactory)pair.component2();
        HttpClient httpClient = $this$configureSsl.secure(arg_0 -> NettyHttpClientKt.configureSsl$lambda$5((Function1)new Function1<SslProvider.SslContextSpec, Unit>(protocols, keyManager, trustManager, host){
            final /* synthetic */ NettyProtocolConfigurator $protocols;
            final /* synthetic */ KeyManagerFactory $keyManager;
            final /* synthetic */ TrustManagerFactory $trustManager;
            final /* synthetic */ String $host;
            {
                this.$protocols = $protocols;
                this.$keyManager = $keyManager;
                this.$trustManager = $trustManager;
                this.$host = $host;
                super(1);
            }

            public final void invoke(SslProvider.SslContextSpec spec) {
                SslProvider.Builder builder2 = spec.sslContext(this.$protocols.getSslContextSpec().configure(arg_0 -> configureSsl.2.invoke$lambda$0(this.$keyManager, this.$trustManager, arg_0)));
                String string = this.$host;
                SslProvider.Builder it = builder2;
                boolean bl = false;
                if (HttpRequestHandlerUtil.isLocalhost(string)) {
                    SNIServerName[] sNIServerNameArray = new SNIServerName[]{new SNIHostName(string)};
                    it.serverNames(sNIServerNameArray);
                }
            }

            private static final void invoke$lambda$0(KeyManagerFactory $keyManager, TrustManagerFactory $trustManager, SslContextBuilder builder2) {
                builder2.sslProvider(SslProvider.JDK);
                if ($keyManager != null) {
                    builder2.keyManager($keyManager);
                }
                if ($trustManager != null) {
                    builder2.trustManager($trustManager);
                }
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"secure(...)");
        return httpClient;
    }

    private static final HttpClient configureDefaultResolver(HttpClient $this$configureDefaultResolver) {
        HttpClientDnsResolverProvider resolverProvider = HttpClientDnsResolverProvider.Companion.getInstance();
        if (resolverProvider == null) {
            Object t = $this$configureDefaultResolver.resolver((AddressResolverGroup)DefaultAddressResolverGroup.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(t, (String)"resolver(...)");
            return (HttpClient)t;
        }
        Object t = $this$configureDefaultResolver.resolver(new CustomizedDnsResolverNettyGroup(resolverProvider.getDnsResolveFunction()));
        Intrinsics.checkNotNullExpressionValue(t, (String)"resolver(...)");
        return (HttpClient)t;
    }

    private static final HttpClient configureTimeouts(HttpClient $this$configureTimeouts, HttpRequestConfig config) {
        HttpRequestExecutionHelperService executionHelperService = HttpRequestExecutionHelperService.getInstance();
        if (executionHelperService == null) {
            return $this$configureTimeouts;
        }
        Integer n = config.getSocketTimeoutMs();
        Integer n2 = config.getConnectionTimeoutMs();
        Object t = $this$configureTimeouts.responseTimeout(Duration.ofMillis(n != null ? (long)n.intValue() : (long)executionHelperService.getSocketTimeout())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, n2 != null ? n2.intValue() : executionHelperService.getConnectionTimeout());
        Intrinsics.checkNotNullExpressionValue(t, (String)"option(...)");
        return (HttpClient)t;
    }

    @NotNull
    public static final String normalizedProtocolPresentation(@NotNull HttpVersion protocol) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        if (Intrinsics.areEqual((Object)protocol, (Object)HTTP_2)) {
            return "HTTP/2";
        }
        String string = protocol.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void createReactorNettyClient$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void createReactorNettyClient$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void configureProxy$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureSsl$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureSsl$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ HttpVersion access$getHTTP_2$p() {
        return HTTP_2;
    }

    static {
        HttpVersion httpVersion = HttpVersion.valueOf((String)"HTTP/2.0");
        Intrinsics.checkNotNullExpressionValue((Object)httpVersion, (String)"valueOf(...)");
        HTTP_2 = httpVersion;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Proxy.Type.values().length];
            try {
                nArray[Proxy.Type.HTTP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Proxy.Type.SOCKS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Proxy.Type.DIRECT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

