/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.impl.engineV2;

import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.adapters.HttpClientContentType;
import com.intellij.httpClient.execution.adapters.HttpClientMessagesAdaptersKt;
import com.intellij.httpClient.execution.impl.engineV2.NettyAdaptersKt;
import com.intellij.openapi.util.text.StringUtil;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.cookie.Cookie;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.netty.http.client.HttpClientResponse;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u000e\u001a\u00020\u0007*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0012\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\u000bH\u0000\u001a\f\u0010\u0012\u001a\u00020\u0004*\u00020\u0004H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"specialChars", "", "", "biscuitsToHeader", "", "biscuits", "", "Lcom/intellij/httpClient/execution/RestClientRequest$Biscuit;", "extractContentType", "Lcom/intellij/httpClient/execution/adapters/HttpClientContentType;", "resp", "Lreactor/netty/http/client/HttpClientResponse;", "wrapInQuotes", "value", "asBiscuit", "Lio/netty/handler/codec/http/cookie/Cookie;", "receivedFrom", "Ljava/net/URL;", "unwrapQuotes", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nnettyAdapters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 nettyAdapters.kt\ncom/intellij/httpClient/execution/impl/engineV2/NettyAdaptersKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1083#2,2:132\n1549#3:134\n1620#3,3:135\n1045#3:138\n*S KotlinDebug\n*F\n+ 1 nettyAdapters.kt\ncom/intellij/httpClient/execution/impl/engineV2/NettyAdaptersKt\n*L\n72#1:132,2\n91#1:134\n91#1:135,3\n94#1:138\n*E\n"})
public final class NettyAdaptersKt {
    @NotNull
    private static final Set<Character> specialChars;

    private static final HttpClientContentType extractContentType(HttpClientResponse resp) {
        String contentTypeHeader = resp.responseHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentTypeHeader == null) {
            return HttpClientContentType.TEXT_PLAIN;
        }
        return HttpClientMessagesAdaptersKt.parseContentType(contentTypeHeader);
    }

    private static final RestClientRequest.Biscuit asBiscuit(Cookie $this$asBiscuit, URL receivedFrom) {
        String string;
        String string2;
        String string3 = $this$asBiscuit.name();
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = $this$asBiscuit.value()) == null) {
            string2 = "";
        }
        String string4 = NettyAdaptersKt.unwrapQuotes(string2);
        String string5 = $this$asBiscuit.domain();
        if (string5 == null) {
            string5 = receivedFrom.getHost();
        }
        if ((string = $this$asBiscuit.path()) == null) {
            string = receivedFrom.getPath();
        }
        return new RestClientRequest.Biscuit(string3, string4, string5, string, $this$asBiscuit.maxAge() != Long.MIN_VALUE ? Instant.now().toEpochMilli() + $this$asBiscuit.maxAge() : -1L);
    }

    private static final String wrapInQuotes(String value2) {
        Object object;
        boolean needQuotes;
        block3: {
            boolean bl;
            CharSequence $this$any$iv = value2;
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl2 = false;
                if (!specialChars.contains(Character.valueOf(it))) continue;
                bl = true;
                break block3;
            }
            bl = needQuotes = false;
        }
        if (needQuotes) {
            char[] cArray = new char[]{'\"', '\\'};
            object = "\"" + StringUtil.escapeChars((String)value2, (char[])cArray) + "\"";
        } else {
            object = value2;
        }
        return object;
    }

    private static final String unwrapQuotes(String $this$unwrapQuotes) {
        String string;
        if (StringsKt.startsWith$default((CharSequence)$this$unwrapQuotes, (char)'\"', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)$this$unwrapQuotes, (char)'\"', (boolean)false, (int)2, null)) {
            String withoutQuotes = StringsKt.removeSurrounding((String)$this$unwrapQuotes, (CharSequence)"\"");
            String string2 = StringUtil.unescapeChar((String)withoutQuotes, (char)'\\');
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = $this$unwrapQuotes;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<RestClientRequest.Biscuit> biscuits(@NotNull HttpClientResponse $this$biscuits) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$biscuits, (String)"<this>");
        Iterable $this$map$iv = CollectionsKt.flatten((Iterable)$this$biscuits.cookies().values());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Cookie cookie = (Cookie)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(NettyAdaptersKt.asBiscuit((Cookie)it, new URL($this$biscuits.resourceUrl())));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final String biscuitsToHeader(@NotNull List<? extends RestClientRequest.Biscuit> biscuits) {
        Intrinsics.checkNotNullParameter(biscuits, (String)"biscuits");
        Iterable $this$sortedBy$iv = biscuits;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                RestClientRequest.Biscuit it = (RestClientRequest.Biscuit)a;
                boolean bl = false;
                String string = it.getPath();
                it = (RestClientRequest.Biscuit)b;
                Comparable comparable = Integer.valueOf(-(string != null ? string.length() : 1));
                bl = false;
                String string2 = it.getPath();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(-(string2 != null ? string2.length() : 1)));
            }
        }), (CharSequence)"; ", null, null, (int)0, null, (Function1)biscuitsToHeader.2.INSTANCE, (int)30, null);
    }

    public static final /* synthetic */ HttpClientContentType access$extractContentType(HttpClientResponse resp) {
        return NettyAdaptersKt.extractContentType(resp);
    }

    public static final /* synthetic */ String access$wrapInQuotes(String value2) {
        return NettyAdaptersKt.wrapInQuotes(value2);
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('\"'), Character.valueOf('\\'), Character.valueOf('\n'), Character.valueOf('\r'), Character.valueOf('\t'), Character.valueOf(' '), Character.valueOf(','), Character.valueOf(';')};
        specialChars = SetsKt.setOf((Object[])objectArray);
    }
}

