/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.impl.engineV2;

import com.google.common.net.InetAddresses;
import com.google.common.net.InternetDomainName;
import com.intellij.httpClient.execution.RestClientRequest;
import java.net.URL;
import java.time.Instant;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0002H\u0002\u001a\u0014\u0010\u0006\u001a\u00020\u0004*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\f\u0010\n\u001a\u00020\u0004*\u00020\u0007H\u0002\u001a\u0014\u0010\u000b\u001a\u00020\u0004*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"localDomains", "", "", "isIpAwareLocalhost", "", "host", "hostMatches", "Lcom/intellij/httpClient/execution/RestClientRequest$Biscuit;", "url", "Ljava/net/URL;", "isExpired", "pathMatches", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nHttpClientCookieJar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientCookieJar.kt\ncom/intellij/httpClient/execution/impl/engineV2/HttpClientCookieJarKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
public final class HttpClientCookieJarKt {
    @NotNull
    private static final Set<String> localDomains;

    private static final boolean isExpired(RestClientRequest.Biscuit $this$isExpired) {
        if ($this$isExpired.getDate() == -1L) {
            return false;
        }
        return Instant.ofEpochMilli($this$isExpired.getDate()).compareTo(Instant.now()) < 0;
    }

    private static final boolean pathMatches(RestClientRequest.Biscuit $this$pathMatches, URL url) {
        String string;
        String urlPath;
        block8: {
            block7: {
                urlPath = url.getPath();
                string = $this$pathMatches.getPath();
                if (string == null) break block7;
                String it = string;
                boolean bl = false;
                String string2 = it.length() > 1 ? StringsKt.removeSuffix((String)it, (CharSequence)"/") : it;
                string = string2;
                if (string2 != null) break block8;
            }
            string = "/";
        }
        String cookiePath = string;
        Intrinsics.checkNotNull((Object)urlPath);
        if (StringsKt.startsWith$default((String)urlPath, (String)cookiePath, (boolean)false, (int)2, null)) {
            if (Intrinsics.areEqual((Object)cookiePath, (Object)"/")) {
                return true;
            }
            if (urlPath.length() == cookiePath.length()) {
                return true;
            }
            if (urlPath.charAt(cookiePath.length()) == '/') {
                return true;
            }
        }
        return false;
    }

    private static final boolean hostMatches(RestClientRequest.Biscuit $this$hostMatches, URL url) {
        String cookieDomain;
        String urlHost;
        block16: {
            block15: {
                String string;
                block14: {
                    block13: {
                        urlHost = url.getHost();
                        string = $this$hostMatches.getDomain();
                        if (string == null || (string = StringsKt.removePrefix((String)string, (CharSequence)".")) == null) break block13;
                        String string2 = string.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                        string = string2;
                        if (string2 != null) break block14;
                    }
                    return false;
                }
                cookieDomain = string;
                if (Intrinsics.areEqual((Object)urlHost, (Object)cookieDomain)) {
                    return true;
                }
                Intrinsics.checkNotNull((Object)urlHost);
                if (HttpClientCookieJarKt.isIpAwareLocalhost(urlHost) && HttpClientCookieJarKt.isIpAwareLocalhost(cookieDomain)) {
                    return true;
                }
                if (InetAddresses.isInetAddress((String)urlHost) || InetAddresses.isInetAddress((String)cookieDomain)) {
                    return false;
                }
                int dotIndex = StringsKt.indexOf$default((CharSequence)cookieDomain, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (dotIndex == -1) break block15;
                String string3 = cookieDomain.substring(dotIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                if (localDomains.contains(string3)) break block16;
            }
            if (InternetDomainName.from((String)cookieDomain).isPublicSuffix()) {
                return false;
            }
        }
        if (StringsKt.endsWith$default((String)urlHost, (String)cookieDomain, (boolean)false, (int)2, null)) {
            int prefix = urlHost.length() - cookieDomain.length();
            if (prefix == 0) {
                return true;
            }
            if (prefix > 1 && urlHost.charAt(prefix - 1) == '.') {
                return true;
            }
        }
        return false;
    }

    private static final boolean isIpAwareLocalhost(String host) {
        return Intrinsics.areEqual((Object)host, (Object)"127.0.0.1") || Intrinsics.areEqual((Object)host, (Object)"localhost");
    }

    public static final /* synthetic */ boolean access$hostMatches(RestClientRequest.Biscuit $receiver, URL url) {
        return HttpClientCookieJarKt.hostMatches($receiver, url);
    }

    public static final /* synthetic */ boolean access$pathMatches(RestClientRequest.Biscuit $receiver, URL url) {
        return HttpClientCookieJarKt.pathMatches($receiver, url);
    }

    public static final /* synthetic */ boolean access$isExpired(RestClientRequest.Biscuit $receiver) {
        return HttpClientCookieJarKt.isExpired($receiver);
    }

    static {
        Object[] objectArray = new String[]{".localhost.", ".localhost", ".test.", ".local.", ".local", ".localdomain"};
        localDomains = SetsKt.setOf((Object[])objectArray);
    }
}

