/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.adapters;

import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/intellij/httpClient/execution/adapters/HttpClientContentType;", "", "mimeType", "", "charset", "Ljava/nio/charset/Charset;", "(Ljava/lang/String;Ljava/nio/charset/Charset;)V", "getCharset", "()Ljava/nio/charset/Charset;", "getMimeType", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "withCharset", "Companion", "intellij.httpClient.executor"})
public final class HttpClientContentType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String mimeType;
    @Nullable
    private final Charset charset;
    @JvmField
    @NotNull
    public static final HttpClientContentType TEXT_PLAIN = new HttpClientContentType("text/plain", Charsets.ISO_8859_1);
    @JvmField
    @NotNull
    public static final HttpClientContentType APPLICATION_JSON = new HttpClientContentType("application/json", Charsets.UTF_8);
    @JvmField
    @NotNull
    public static final HttpClientContentType APPLICATION_OCTET_STREAM = new HttpClientContentType("application/octet-stream", null, 2, null);
    @JvmField
    @NotNull
    public static final HttpClientContentType APPLICATION_XML = new HttpClientContentType("application/xml", Charsets.UTF_8);

    public HttpClientContentType(@NotNull String mimeType, @Nullable Charset charset) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        this.mimeType = mimeType;
        this.charset = charset;
    }

    public /* synthetic */ HttpClientContentType(String string, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            charset = null;
        }
        this(string, charset);
    }

    @NotNull
    public final String getMimeType() {
        return this.mimeType;
    }

    @Nullable
    public final Charset getCharset() {
        return this.charset;
    }

    @NotNull
    public final HttpClientContentType withCharset(@NotNull String charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return HttpClientContentType.copy$default(this, null, Charset.forName(charset), 1, null);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append(this.mimeType);
        if (this.charset != null) {
            $this$toString_u24lambda_u240.append("; charset=" + this.charset.name());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String component1() {
        return this.mimeType;
    }

    @Nullable
    public final Charset component2() {
        return this.charset;
    }

    @NotNull
    public final HttpClientContentType copy(@NotNull String mimeType, @Nullable Charset charset) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return new HttpClientContentType(mimeType, charset);
    }

    public static /* synthetic */ HttpClientContentType copy$default(HttpClientContentType httpClientContentType, String string, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            string = httpClientContentType.mimeType;
        }
        if ((n & 2) != 0) {
            charset = httpClientContentType.charset;
        }
        return httpClientContentType.copy(string, charset);
    }

    public int hashCode() {
        int result2 = this.mimeType.hashCode();
        result2 = result2 * 31 + (this.charset == null ? 0 : this.charset.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpClientContentType)) {
            return false;
        }
        HttpClientContentType httpClientContentType = (HttpClientContentType)other;
        if (!Intrinsics.areEqual((Object)this.mimeType, (Object)httpClientContentType.mimeType)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.charset, (Object)httpClientContentType.charset);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/httpClient/execution/adapters/HttpClientContentType$Companion;", "", "()V", "APPLICATION_JSON", "Lcom/intellij/httpClient/execution/adapters/HttpClientContentType;", "APPLICATION_OCTET_STREAM", "APPLICATION_XML", "TEXT_PLAIN", "intellij.httpClient.executor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

